/*
 * Decompiled with CFR 0.152.
 */
package mdxreader;

import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mdxreader.LittleEndian;
import mdxreader.MDXDataInput;

public class MDXReader {
    private String modelName;
    private List sequences = new ArrayList();
    private List materials = new ArrayList();
    private List textures = new ArrayList();
    private List geosets = new ArrayList();

    public static void main(String[] args) throws IOException {
        new MDXReader().read(new LittleEndian(new FileInputStream("HeroArchMage.mdx")));
    }

    public Node makeNode() {
        int c = 0;
        Node node = new Node(this.modelName);
        for (Geoset geo : this.geosets) {
            node.attachChild((Spatial)this.makeMesh(geo, c++));
        }
        return node;
    }

    private TriMesh makeMesh(Geoset geo, int id) {
        TriMesh mesh = new TriMesh("geo");
        mesh.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])geo.getVertices()));
        mesh.setIndexBuffer(0, BufferUtils.createIntBuffer((int[])geo.getFaces()));
        Vector2f[][] uvs = geo.getUvs();
        for (int i = 0; i < uvs.length; ++i) {
            mesh.setTextureBuffer(i, BufferUtils.createFloatBuffer((Vector2f[])uvs[i]));
        }
        mesh.setRenderState((RenderState)this.makeState((Material)this.materials.get(geo.getMaterialID())));
        mesh.updateRenderState();
        return mesh;
    }

    private TextureState makeState(Material material) {
        TextureState state = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Layer[] layers = material.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            Texture texture = this.makeTexture((TextureDef)this.textures.get(layers[i].getTextureID()));
            state.setTexture(texture, 0);
        }
        state.setEnabled(true);
        return state;
    }

    private Texture makeTexture(TextureDef def) {
        boolean wrapV;
        System.out.println(this.mungPath(def.getPath()));
        Texture texture = TextureManager.loadTexture((String)this.mungPath(def.getPath()), (int)6, (int)1);
        boolean wrapU = (def.getWrapFlags() & 1) > 0;
        boolean bl = wrapV = (def.getWrapFlags() & 2) > 0;
        if (wrapU) {
            if (wrapV) {
                texture.setWrap(3);
            } else {
                texture.setWrap(2);
            }
        } else if (wrapV) {
            texture.setWrap(1);
        } else {
            texture.setWrap(0);
        }
        return texture;
    }

    private String mungPath(String str) {
        if (str.endsWith(".blp")) {
            return str.substring(0, str.length() - 3) + "tga";
        }
        return str;
    }

    public void hexdump(DataInput in) throws IOException {
        int cur = 0;
        StringBuffer str = new StringBuffer();
        try {
            while (true) {
                if (cur++ % 16 == 0) {
                    System.out.print(" " + str + "\n" + MDXReader.pad(Integer.toHexString(cur), 6) + ":");
                    str.setLength(0);
                }
                int read = in.readByte() & 0xFF;
                String x = Integer.toHexString(read);
                if (read >= 32) {
                    str.append((char)read);
                } else {
                    str.append('.');
                }
                System.out.print(" " + MDXReader.pad(x, 2));
            }
        }
        catch (EOFException e) {
            if (str.length() > 0) {
                System.out.println(" " + str);
            }
            return;
        }
    }

    private static String pad(String s, int amount) {
        while (s.length() < amount) {
            s = "0" + s;
        }
        return s;
    }

    public void read(DataInput inp) throws IOException {
        String id;
        MDXDataInput in = inp instanceof MDXDataInput ? (MDXDataInput)inp : new MDXDataInput(inp, "MDLX", -1);
        if (!in.readID().equals("MDLX")) {
            throw new IOException("Not an MDX file");
        }
        while ((id = in.readID()) != null) {
            int length = in.readInt();
            MDXDataInput newIn = new MDXDataInput(in, id, length);
            if (id.equals("VERS")) {
                this.readVersion(newIn);
            } else if (id.equals("MODL")) {
                this.readModel(newIn);
            } else if (id.equals("SEQS")) {
                this.readSequences(newIn);
            } else if (id.equals("GLBS")) {
                this.readGlobalSequences(newIn);
            } else if (id.equals("MTLS")) {
                this.readMaterials(newIn);
            } else if (id.equals("TEXS")) {
                this.readTextures(newIn);
            } else if (id.equals("GEOS")) {
                this.readGeosets(newIn);
            } else if (id.equals("BONE")) {
                this.readBones(newIn);
            } else {
                System.out.println("Found " + id + ", length=" + length);
                newIn.skipBytes(Integer.MAX_VALUE);
            }
            if (newIn.getRemaining() <= 0) continue;
            throw new IOException("Bytes remaining at end of " + id);
        }
        System.out.println("Read " + this.modelName);
    }

    private void readVersion(MDXDataInput in) throws IOException {
        int version = in.readInt();
        if (version != 800) {
            throw new IOException("Incorrect version: got " + Integer.toHexString(version));
        }
    }

    private void readModel(MDXDataInput in) throws IOException {
        this.modelName = in.readString(336);
        in.skipBytes(32);
        in.skipBytes(4);
    }

    private void readSequences(MDXDataInput in) throws IOException {
        while (in.getRemaining() > 0) {
            String name = in.readString(80);
            int startFrame = in.readInt();
            int endFrame = in.readInt();
            in.skipBytes(12);
            in.skipBytes(32);
            this.sequences.add(new Sequence(name, startFrame, endFrame));
        }
    }

    private void readGlobalSequences(MDXDataInput in) throws IOException {
        in.skipBytes(Integer.MAX_VALUE);
    }

    private void readMaterials(MDXDataInput in) throws IOException {
        int i = 0;
        while (in.getRemaining() > 0) {
            int amount = in.readInt() - 4;
            MDXDataInput newIn = new MDXDataInput(in, "MTLS-" + i++, amount);
            newIn.skipBytes(4);
            int renderMode = newIn.readInt();
            List layerList = this.loadLayers(newIn);
            Layer[] layers = layerList.toArray(new Layer[layerList.size()]);
            this.materials.add(new Material(renderMode, layers));
            newIn.skipBytes(Integer.MAX_VALUE);
        }
    }

    private List loadLayers(MDXDataInput in) throws IOException {
        if (!in.readID().equals("LAYS")) {
            throw new IOException("Expected LAYS");
        }
        int numLayers = in.readInt();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (int i = 0; i < numLayers; ++i) {
            int amount = in.readInt() - 4;
            MDXDataInput newIn = new MDXDataInput(in, "LAYS-" + i, amount);
            int filterMode = newIn.readInt();
            int shading = newIn.readInt();
            int textureID = newIn.readInt();
            int textureVertexAnimID = newIn.readInt();
            int coordID = newIn.readInt();
            float alpha = newIn.readFloat();
            if (newIn.getRemaining() > 0) {
                throw new IOException("Unexpected data at end of layer");
            }
            layers.add(new Layer(filterMode, shading, textureID, textureVertexAnimID, coordID, alpha));
        }
        return layers;
    }

    private void readTextures(MDXDataInput in) throws IOException {
        while (in.getRemaining() > 0) {
            int replaceableID = in.readInt();
            String path = in.readString(256);
            in.skipBytes(4);
            int wrap = in.readInt();
            if (replaceableID != 0) continue;
            this.textures.add(new TextureDef(path, wrap));
        }
    }

    private void readGeosets(MDXDataInput in) throws IOException {
        int i = 0;
        while (in.getRemaining() > 0) {
            int amount = in.readInt();
            MDXDataInput newIn = new MDXDataInput(in, "GEOS-" + i++, amount);
            List vertexList = this.loadVertices(newIn);
            Vector3f[] vertices = vertexList.toArray(new Vector3f[vertexList.size()]);
            this.skipNormals(newIn);
            int[] faces = this.loadFaces(newIn);
            short[] groups = this.loadVertexGroups(newIn);
            this.skipMatrices(newIn);
            int materialID = newIn.readInt();
            int selectionGroup = newIn.readInt();
            int selectable = newIn.readInt();
            newIn.skipBytes(28);
            int nAnim = newIn.readInt();
            newIn.skipBytes(28 * nAnim);
            Vector2f[][] uvs = this.readUVs(newIn);
            this.geosets.add(new Geoset(vertices, faces, groups, materialID, uvs));
        }
    }

    private List loadVertices(MDXDataInput in) throws IOException {
        int numVertices = in.readIDSize("VRTX");
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        for (int i = 0; i < numVertices; ++i) {
            Vector3f vec = new Vector3f(in.readFloat(), in.readFloat(), in.readFloat());
            vertices.add(vec);
        }
        return vertices;
    }

    private void skipNormals(MDXDataInput in) throws IOException {
        int numNormals = in.readIDSize("NRMS");
        in.skipBytes(numNormals * 12);
    }

    private int[] loadFaces(MDXDataInput in) throws IOException {
        int count = in.readIDSize("PTYP");
        in.skipBytes(count * 4);
        count = in.readIDSize("PCNT");
        in.skipBytes(count * 4);
        count = in.readIDSize("PVTX");
        int[] faces = new int[count];
        for (int i = 0; i < count; ++i) {
            faces[i] = in.readShort();
        }
        return faces;
    }

    private short[] loadVertexGroups(MDXDataInput in) throws IOException {
        int amt = in.readIDSize("GNDX");
        short[] groups = new short[amt];
        for (int i = 0; i < amt; ++i) {
            groups[i] = (short)in.readUnsignedByte();
        }
        return groups;
    }

    private void skipMatrices(MDXDataInput in) throws IOException {
        int amt = in.readIDSize("MTGC");
        while (amt-- > 0) {
            in.readInt();
        }
        amt = in.readIDSize("MATS");
        while (amt-- > 0) {
            in.readInt();
        }
    }

    private Vector2f[][] readUVs(MDXDataInput in) throws IOException {
        int amt = in.readIDSize("UVAS");
        Vector2f[][] uvs = new Vector2f[amt][];
        for (int i = 0; i < amt; ++i) {
            int size = in.readIDSize("UVBS");
            uvs[i] = new Vector2f[size];
            for (int j = 0; j < size; ++j) {
                uvs[i][j] = new Vector2f(in.readFloat(), 1.0f - in.readFloat());
            }
        }
        return uvs;
    }

    private void readBones(MDXDataInput in) throws IOException {
        while (in.getRemaining() > 0) {
            ObjectDef object = this.loadObject(in);
            int geosetID = in.readInt();
            int geosetAnimID = in.readInt();
        }
    }

    private ObjectDef loadObject(MDXDataInput in) throws IOException {
        in = new MDXDataInput(in, "OBJ", in.readInt() - 4);
        String name = in.readString(80);
        int objectID = in.readInt();
        int parentID = in.readInt();
        int type = in.readInt();
        throw new UnsupportedOperationException();
    }

    private static class Geoset {
        private Vector3f[] vertices;
        private int[] faces;
        private short[] groups;
        private int materialID;
        private Vector2f[][] uvs;

        public Geoset(Vector3f[] vertices, int[] faces, short[] groups, int materialid, Vector2f[][] uvs) {
            this.vertices = vertices;
            this.faces = faces;
            this.groups = groups;
            this.materialID = materialid;
            this.uvs = uvs;
        }

        public int[] getFaces() {
            return this.faces;
        }

        public short[] getGroups() {
            return this.groups;
        }

        public int getMaterialID() {
            return this.materialID;
        }

        public Vector2f[][] getUvs() {
            return this.uvs;
        }

        public Vector3f[] getVertices() {
            return this.vertices;
        }
    }

    private static class TextureDef {
        public static final int FLAG_WRAP_WIDTH = 1;
        public static final int FLAG_WRAP_HEIGHT = 2;
        String path;
        int wrapFlags;

        public TextureDef(String path, int flags) {
            this.path = path;
            this.wrapFlags = flags;
        }

        public String getPath() {
            return this.path;
        }

        public int getWrapFlags() {
            return this.wrapFlags;
        }
    }

    private static class Material {
        public static final int FLAGS_CONSTANT_COLOUR = 1;
        public static final int FLAGS_SORT_PRIMS_FAR_Z = 16;
        public static final int FLAGS_FULL_RESOLUTION = 32;
        private int renderFlags;
        private Layer[] layers;

        public Material(int flags, Layer[] layers) {
            this.renderFlags = flags;
            this.layers = layers;
        }

        public Layer[] getLayers() {
            return this.layers;
        }

        public int getRenderFlags() {
            return this.renderFlags;
        }
    }

    private static class Layer {
        public static final int MODE_NONE = 0;
        public static final int MODE_TRANSPARENT = 1;
        public static final int MODE_BLEND = 2;
        public static final int MODE_ADDITIVE = 3;
        public static final int MODE_ADDALPHA = 4;
        public static final int MODE_MODULATE = 5;
        public static final int FLAG_UNSHADED = 1;
        public static final int FLAG_SPHERE_ENV_MAP = 2;
        public static final int FLAG_TWO_SIDED = 16;
        public static final int FLAG_UNFOGGED = 32;
        public static final int FLAG_NODEPTHTEST = 64;
        public static final int FLAG_NODEPTHSET = 128;
        private int filterMode;
        private int flags;
        private int textureID;
        private int textureVertexAnimID;
        private int coordID;
        private float alpha;

        public Layer(int mode, int flags, int textureid, int animID, int coordid, float alpha) {
            this.filterMode = mode;
            this.flags = flags;
            this.textureID = textureid;
            this.textureVertexAnimID = animID;
            this.coordID = coordid;
            this.alpha = alpha;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public int getCoordID() {
            return this.coordID;
        }

        public int getFilterMode() {
            return this.filterMode;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getTextureID() {
            return this.textureID;
        }

        public int getTextureVertexAnimID() {
            return this.textureVertexAnimID;
        }
    }

    private static class Sequence {
        private String name;
        private int startFrame;
        private int endFrame;

        public Sequence(String name, int frame, int frame2) {
            this.name = name;
            this.startFrame = frame;
            this.endFrame = frame2;
        }

        public int getEndFrame() {
            return this.endFrame;
        }

        public String getName() {
            return this.name;
        }

        public int getStartFrame() {
            return this.startFrame;
        }
    }

    private static class ObjectDef {
        private ObjectDef() {
        }
    }
}

