/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream in) {
        super(in);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        InputStream in = this.in;
        int total = n;
        int cur = 0;
        while (n > 0 && (cur = (int)in.skip(n)) > 0) {
            n -= cur;
        }
        return total - n;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch2 << 8) + (ch1 << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() & 0xFFFFFFFFL) + ((long)this.readInt() << 32);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("Deprecated!");
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

