/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.sourceforge.akjrcp.draw.DecoratedShapePainter;
import jp.sourceforge.akjrcp.draw.TextLinesLayout;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import org.apache.commons.lang.StringUtils;

public class TextItem
extends AbstractItem {
    protected String text;
    protected Font font = new Font("MS Mincho", 0, 18);
    protected DecoratedShapePainter decoratedShapePainter = new DecoratedShapePainter();
    public static final String DEFAULT_FONT_NAME = "MS Mincho";
    public static final int DEFAULT_FONT_SIZE = 18;
    public static final int DEFAULT_FONT_STYLE = 0;
    protected int text_align = 1;
    protected int text_margin = 6;
    protected TextLinesLayout textLinesLayout;
    protected Rectangle textRect;
    private int firstOffsetX = 0;
    private int firstLineHeight = 0;
    private Point lastDrawPosition;
    private int lastLineY;
    private int maxDrawedX;
    private boolean debug = false;

    public TextItem(TextItem base, String text) {
        super(base);
        this.text = text;
        this.font = base.getFont();
        this.text_align = base.text_align;
        this.text_margin = base.text_margin;
        try {
            this.decoratedShapePainter = base.decoratedShapePainter.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public TextItem(String text) {
        this.text = text;
        this.setAlign(2);
        this.setValign(3);
        this.setFadeInTime(0.0);
        this.setFadeOutTime(0.3);
    }

    @Override
    public String toString() {
        return "TextItem:" + super.toString() + " text=" + this.text + " font=" + this.font;
    }

    public TextItem() {
        this("");
    }

    public void beforeWriteFrame(double time) {
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean written = false;
        if (this.duration == -1.0) {
            written = true;
        }
        double frameTime = (double)(frame - 1) / preference.getFps();
        if (!written) {
            written = this.isInFrame(preference, frame);
        }
        if (written) {
            int movedRotate;
            Graphics2D g2 = (Graphics2D)baseImage.getImage().getGraphics();
            g2.setFont(this.font);
            this.initializeShape(g2, preference);
            this.beforeWriteFrame(frameTime - this.startTime);
            float transparent = this.getFrameTransparent(preference, frameTime);
            g2.setComposite(AlphaComposite.getInstance(3, transparent));
            log.trace((Object)this.font);
            Rectangle drawRect = this.getDrawRect(preference, baseImage.getImage());
            if (drawRect == null) {
                return false;
            }
            if (this.debug) {
                g2.setColor(new Color(255, 0, 0));
                g2.drawRect(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
            }
            log.trace((Object)("drawrect:" + drawRect));
            int dx = drawRect.x + this.getMovedX(preference, frameTime);
            int dy = drawRect.y + g2.getFontMetrics().getAscent() + this.getMovedY(preference, frameTime);
            log.trace((Object)("translate dx=" + dx + ",dy=" + dy + "," + g2));
            g2.translate(dx, dy);
            Shape[] textShapes = this.textLinesLayout.getShapes();
            AffineTransform affin = new AffineTransform();
            if (this.shearX > 0.0 || this.shearY > 0.0) {
                g2.shear(this.shearX, this.shearY);
            }
            if ((movedRotate = this.getMovedRotate(preference, frameTime)) > 0) {
                affin.setToRotation((double)movedRotate * Math.PI / 180.0, this.textRect.width / 2, this.textRect.height / 2 - g2.getFontMetrics().getAscent());
            }
            g2.transform(affin);
            int lx = dx;
            int ly = drawRect.y;
            int i = 0;
            while (i < textShapes.length) {
                if (i == 0) {
                    g2.translate(this.firstOffsetX, 0);
                    lx += this.firstOffsetX;
                } else {
                    lx = dx;
                }
                this.decoratedShapePainter.setSelectionShape(this.getSelectionShape(i));
                log.trace((Object)("i=" + i + " dx=" + dx + " dy=" + dy + ",shape=" + textShapes[i].getBounds()));
                this.decoratedShapePainter.paint(g2, textShapes[i]);
                if (lx + textShapes[i].getBounds().width > this.maxDrawedX) {
                    this.maxDrawedX = lx + textShapes[i].getBounds().width;
                }
                int moveY = this.lastLineY - drawRect.y;
                if (this.font.getSize() + this.text_margin > moveY) {
                    moveY = this.font.getSize() + this.text_margin;
                }
                g2.translate(0, Math.max(this.firstLineHeight, moveY));
                if (i == 0) {
                    g2.translate(-this.firstOffsetX, 0);
                }
                if (i != textShapes.length - 1) {
                    if (this.lastLineY > (ly += this.font.getSize() + this.text_margin)) {
                        log.info((Object)"over Y:");
                        ly = this.lastLineY;
                    }
                } else {
                    lx += textShapes[i].getBounds().x + textShapes[i].getBounds().width;
                    if (this.text.endsWith(" ") || this.text.endsWith("\t")) {
                        lx += this.font.getSize() / 2;
                    }
                }
                ++i;
            }
            this.lastDrawPosition = new Point(lx, ly);
        }
        return written;
    }

    public Shape getSelectionShape(int index) {
        return null;
    }

    private int getDrawTextWidth(DougaPreference preference) {
        int w = this.getWidth();
        if (w == 0) {
            w = this.x == 0 ? preference.getWidth() : 9999;
        }
        return w;
    }

    public void clear() {
        this.textLinesLayout = null;
        this.textRect = null;
    }

    public void initializeShape(Graphics2D g2, DougaPreference preference) {
        if (this.textLinesLayout != null) {
            return;
        }
        int maxWidth = this.getDrawTextWidth(preference);
        this.textLinesLayout = new TextLinesLayout(g2, this.font, this.transformText(this.text), maxWidth - this.firstOffsetX, maxWidth);
        this.textRect = this.textLinesLayout.getBounds();
    }

    public String transformText(String text) {
        String out = StringUtils.replace((String)text, (String)"\\n", (String)"\n");
        return out;
    }

    public Rectangle getDrawRect(DougaPreference preference, BufferedImage baseImage) {
        if (this.text == null) {
            log.warn((Object)"text is null");
            return null;
        }
        if (this.text.length() == 0) {
            log.warn((Object)"text length=0");
            return null;
        }
        int drawwidth = Math.max(this.textRect.width, this.width);
        int drawheight = Math.max(this.textRect.height, this.height);
        log.trace((Object)("text:" + drawwidth + "," + drawheight));
        int dw = drawwidth;
        int dh = drawheight;
        int dx = 0;
        if (this.align == 0) {
            dx = this.x;
            dw = drawwidth;
        } else if (this.align == 1) {
            dx = this.x == 0 && this.width == 0 ? this.marginLeft : this.x;
            dw = drawwidth;
        } else if (this.align == 3) {
            dx = this.x == 0 && this.width == 0 ? preference.getWidth() - this.textRect.width - this.marginRight : this.x + (drawwidth - this.textRect.width);
            dw = drawwidth;
        } else if (this.align == 2) {
            dx = this.width == 0 ? this.marginRight + (preference.getWidth() - this.marginLeft - this.marginRight - dw) / 2 : this.x + (drawwidth - this.textRect.width) / 2;
            dw = drawwidth;
        } else {
            log.warn((Object)("invalid align:" + this.align));
        }
        int dy = 0;
        if (this.valign == 0) {
            dy = this.y;
            dh = drawheight;
        } else if (this.valign == 1) {
            dy = this.y == 0 && this.height == 0 ? this.y + this.marginTop : this.y;
            dh = drawheight;
        } else if (this.valign == 3) {
            dy = this.y == 0 && this.height == 0 ? preference.getHeight() - this.textRect.height - this.marginBottom : this.y + (drawheight - this.textRect.height);
            dh = drawheight;
        } else if (this.valign == 2) {
            dy = this.height == 0 ? (preference.getHeight() - this.textRect.height - this.marginBottom) / 2 : this.y + (drawheight - this.textRect.height) / 2;
            dh = drawheight;
        } else {
            log.warn((Object)("invalid valign:" + this.valign));
        }
        return new Rectangle(dx, dy, dw, dh);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public DecoratedShapePainter getDecoratedShapePainter() {
        return this.decoratedShapePainter;
    }

    public void setDecoratedShapePainter(DecoratedShapePainter decoratedShapePainter) {
        this.decoratedShapePainter = decoratedShapePainter;
    }

    public Rectangle getTextRect() {
        return this.textRect;
    }

    protected int getFirstOffset() {
        return this.firstOffsetX;
    }

    protected void setFirstOffset(int firstOffset) {
        this.firstOffsetX = firstOffset;
    }

    protected Point getLastDrawPosition() {
        return this.lastDrawPosition;
    }

    protected int getLastLineY() {
        return this.lastLineY;
    }

    protected void setLastLineY(int lastLineHeight) {
        this.lastLineY = lastLineHeight;
    }

    protected int getFirstLineHeight() {
        return this.firstLineHeight;
    }

    protected int getLineHeight() {
        return this.font.getSize() + this.text_margin;
    }

    protected int getMaxDrawedX() {
        return this.maxDrawedX;
    }

    public void setMaxDrawedX(int maxDrawedX) {
        this.maxDrawedX = maxDrawedX;
    }

    public int getFirstOffsetX() {
        return this.firstOffsetX;
    }

    public void setFirstOffsetX(int firstOffsetX) {
        this.firstOffsetX = firstOffsetX;
    }

    public void setFirstLineHeight(int firstLineHeight) {
        this.firstLineHeight = firstLineHeight;
    }

    public void setLastDrawPosition(Point lastDrawPosition) {
        this.lastDrawPosition = lastDrawPosition;
    }

    public void resetMultiStyledSupport() {
        this.setMaxDrawedX(0);
        this.setLastLineY(0);
        this.setFirstOffset(0);
        this.lastDrawPosition = null;
        this.firstLineHeight = 0;
        this.firstOffsetX = 0;
    }
}

