/*
 * Decompiled with CFR 0.152.
 */
package mdxreader;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

public class MDXDataInput
implements DataInput {
    private DataInput source;
    private String name;
    private int remaining;

    public MDXDataInput(DataInput source, String name, int remaining) {
        this.source = source;
        this.name = name;
        this.remaining = remaining;
    }

    private void dec(int amount) throws IOException {
        if (this.remaining < 0) {
            return;
        }
        this.remaining -= amount;
        if (this.remaining < 0) {
            this.remaining = 0;
            throw new EOFException(this.name);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.dec(1);
        return this.source.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.dec(1);
        return this.source.readByte();
    }

    @Override
    public char readChar() throws IOException {
        this.dec(2);
        return this.source.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.dec(8);
        return this.source.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.dec(4);
        return this.source.readFloat();
    }

    @Override
    public void readFully(byte[] array, int start, int length) throws IOException {
        this.dec(length);
        this.source.readFully(array, start, length);
    }

    @Override
    public void readFully(byte[] array) throws IOException {
        this.dec(array.length);
        this.source.readFully(array);
    }

    @Override
    public int readInt() throws IOException {
        this.dec(4);
        return this.source.readInt();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        this.dec(8);
        return this.source.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.dec(2);
        return this.source.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.dec(1);
        return this.source.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.dec(2);
        return this.source.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int skipBytes(int amt) throws IOException {
        if (amt > this.remaining && this.remaining >= 0) {
            amt = this.remaining;
        }
        amt = this.source.skipBytes(amt);
        this.remaining -= amt;
        return amt;
    }

    public String readID() throws IOException {
        char[] text = new char[4];
        try {
            text[0] = (char)this.readUnsignedByte();
        }
        catch (EOFException e) {
            return null;
        }
        text[1] = (char)this.readUnsignedByte();
        text[2] = (char)this.readUnsignedByte();
        text[3] = (char)this.readUnsignedByte();
        return new String(text);
    }

    public void readID(String id) throws IOException {
        if (!id.equals(this.readID())) {
            throw new IOException("Expected " + id);
        }
    }

    public int readIDSize(String id) throws IOException {
        if (!id.equals(this.readID())) {
            throw new IOException("Expected " + id);
        }
        return this.readInt();
    }

    public String readString(int length) throws IOException {
        byte[] data = new byte[length];
        this.readFully(data);
        int last = -1;
        while (last++ < length && data[last] != 0) {
        }
        return new String(data, 0, last, "US-ASCII");
    }

    public int getRemaining() {
        return this.remaining;
    }
}

