/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain;

import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.VBOInfo;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.system.DisplaySystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class TerrainBlock
extends AreaClodMesh {
    private static final long serialVersionUID = 1L;
    private int size;
    private int totalSize;
    private short quadrant = 1;
    private Vector3f stepScale;
    private boolean useClod;
    private Vector2f offset;
    private float offsetAmount;
    private int[] heightMap;
    private int[] oldHeightMap;
    private static Vector3f calcVec1 = new Vector3f();
    private static Vector3f calcVec2 = new Vector3f();
    private static Vector3f calcVec3 = new Vector3f();

    public TerrainBlock() {
    }

    public TerrainBlock(String string) {
        super(string);
    }

    public TerrainBlock(String string, int n, Vector3f vector3f, int[] nArray, Vector3f vector3f2, boolean bl) {
        this(string, n, vector3f, nArray, vector3f2, bl, n, new Vector2f(), 0.0f);
    }

    public TerrainBlock(String string, int n, Vector3f vector3f, int[] nArray, Vector3f vector3f2, boolean bl, int n2, Vector2f vector2f, float f) {
        super(string);
        this.useClod = bl;
        this.size = n;
        this.stepScale = vector3f;
        this.totalSize = n2;
        this.offsetAmount = f;
        this.offset = vector2f;
        this.heightMap = nArray;
        this.setLocalTranslation(vector3f2);
        this.buildVertices();
        this.buildTextureCoordinates();
        this.buildNormals();
        TriangleBatch triangleBatch = this.getBatch(0);
        VBOInfo vBOInfo = new VBOInfo(true);
        triangleBatch.setVBOInfo(vBOInfo);
        if (this.useClod) {
            this.create(null);
            this.setTrisPerPixel(0.02f);
        }
    }

    public int getType() {
        return 38;
    }

    public int chooseTargetRecord(Renderer renderer) {
        if (this.useClod) {
            return super.chooseTargetRecord(renderer);
        }
        return 0;
    }

    public void setDetailTexture(int n, int n2) {
        this.copyTextureCoords(0, 0, n, n2);
    }

    public float getHeight(Vector2f vector2f) {
        return this.getHeight(vector2f.x, vector2f.y);
    }

    public float getHeight(Vector3f vector3f) {
        return this.getHeight(vector3f.x, vector3f.z);
    }

    public float getHeight(float f, float f2) {
        float f3 = FastMath.floor((float)(f /= this.stepScale.x));
        float f4 = FastMath.floor((float)(f2 /= this.stepScale.z));
        if (f3 < 0.0f || f4 < 0.0f || f3 >= (float)(this.size - 1) || f4 >= (float)(this.size - 1)) {
            return Float.NaN;
        }
        float f5 = f - f3;
        float f6 = f2 - f4;
        int n = (int)(f3 + f4 * (float)this.size);
        float f7 = (float)this.heightMap[n] * this.stepScale.y;
        float f8 = (float)this.heightMap[n + 1] * this.stepScale.y;
        float f9 = (float)this.heightMap[n + this.size] * this.stepScale.y;
        float f10 = (float)this.heightMap[n + this.size + 1] * this.stepScale.y;
        if (f5 > f6) {
            return (1.0f - f5) * f7 + (f5 - f6) * f8 + f6 * f10;
        }
        return (1.0f - f6) * f7 + (f6 - f5) * f9 + f5 * f10;
    }

    public float getHeightFromWorld(Vector3f vector3f) {
        Vector3f vector3f2 = calcVec1.set(vector3f).subtractLocal(this.localTranslation);
        return this.getHeight(vector3f2.x, vector3f2.z);
    }

    public Vector3f getSurfaceNormal(Vector2f vector2f, Vector3f vector3f) {
        return this.getSurfaceNormal(vector2f.x, vector2f.y, vector3f);
    }

    public Vector3f getSurfaceNormal(Vector3f vector3f, Vector3f vector3f2) {
        return this.getSurfaceNormal(vector3f.x, vector3f.z, vector3f2);
    }

    public Vector3f getSurfaceNormal(float f, float f2, Vector3f vector3f) {
        float f3 = FastMath.floor((float)(f /= this.stepScale.x));
        float f4 = FastMath.floor((float)(f2 /= this.stepScale.z));
        if (f3 < 0.0f || f4 < 0.0f || f3 >= (float)(this.size - 1) || f4 >= (float)(this.size - 1)) {
            return null;
        }
        float f5 = f - f3;
        float f6 = f2 - f4;
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        Vector3f vector3f2 = vector3f;
        Vector3f vector3f3 = calcVec1;
        Vector3f vector3f4 = calcVec2;
        Vector3f vector3f5 = calcVec3;
        int n = (int)(f3 + f4 * (float)this.size);
        TriangleBatch triangleBatch = this.getBatch(0);
        BufferUtils.populateFromBuffer((Vector3f)vector3f2, (FloatBuffer)triangleBatch.getNormalBuffer(), (int)n);
        BufferUtils.populateFromBuffer((Vector3f)vector3f3, (FloatBuffer)triangleBatch.getNormalBuffer(), (int)(n + 1));
        BufferUtils.populateFromBuffer((Vector3f)vector3f4, (FloatBuffer)triangleBatch.getNormalBuffer(), (int)(n + this.size));
        BufferUtils.populateFromBuffer((Vector3f)vector3f5, (FloatBuffer)triangleBatch.getNormalBuffer(), (int)(n + this.size + 1));
        vector3f2.interpolate(vector3f3, f5);
        vector3f4.interpolate(vector3f5, f5);
        vector3f2.interpolate(vector3f4, f6);
        return vector3f2.normalizeLocal();
    }

    private void buildVertices() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(this.heightMap.length);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer((FloatBuffer)triangleBatch.getVertexBuffer(), (int)triangleBatch.getVertexCount()));
        Vector3f vector3f = new Vector3f();
        for (n = 0; n < this.size; ++n) {
            for (int i = 0; i < this.size; ++i) {
                vector3f.set((float)n * this.stepScale.x, (float)this.heightMap[n + i * this.size] * this.stepScale.y, (float)i * this.stepScale.z);
                BufferUtils.setInBuffer((Vector3f)vector3f, (FloatBuffer)triangleBatch.getVertexBuffer(), (int)(n + i * this.size));
            }
        }
        triangleBatch.setTriangleQuantity((this.size - 1) * (this.size - 1) * 2);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer((int)(triangleBatch.getTriangleCount() * 3)));
        for (n = 0; n < this.size * (this.size - 1); ++n) {
            if (n % (this.size * (n / this.size + 1) - 1) == 0 && n != 0) continue;
            triangleBatch.getIndexBuffer().put(n);
            triangleBatch.getIndexBuffer().put(1 + this.size + n);
            triangleBatch.getIndexBuffer().put(1 + n);
            triangleBatch.getIndexBuffer().put(n);
            triangleBatch.getIndexBuffer().put(this.size + n);
            triangleBatch.getIndexBuffer().put(1 + this.size + n);
        }
    }

    public void buildTextureCoordinates() {
        float f = this.offset.x + this.offsetAmount * this.stepScale.x;
        float f2 = this.offset.y + this.offsetAmount * this.stepScale.z;
        TriangleBatch triangleBatch = this.getBatch(0);
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer((FloatBuffer)((FloatBuffer)triangleBatch.getTextureBuffers().get(0)), (int)triangleBatch.getVertexCount());
        triangleBatch.getTextureBuffers().set(0, floatBuffer);
        floatBuffer.clear();
        triangleBatch.getVertexBuffer().rewind();
        for (int i = 0; i < triangleBatch.getVertexCount(); ++i) {
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + f) / (this.stepScale.x * (float)(this.totalSize - 1)));
            triangleBatch.getVertexBuffer().get();
            floatBuffer.put((triangleBatch.getVertexBuffer().get() + f2) / (this.stepScale.z * (float)(this.totalSize - 1)));
        }
    }

    private void buildNormals() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer((FloatBuffer)triangleBatch.getNormalBuffer(), (int)triangleBatch.getVertexCount()));
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                BufferUtils.populateFromBuffer((Vector3f)vector3f3, (FloatBuffer)triangleBatch.getVertexBuffer(), (int)n3);
                if (i == this.size - 1) {
                    if (j == this.size - 1) {
                        n = n3 - this.size;
                        n2 = n3 - 1;
                    } else {
                        n = n3 + 1;
                        n2 = n3 - this.size;
                    }
                } else if (j == this.size - 1) {
                    n = n3 - 1;
                    n2 = n3 + this.size;
                } else {
                    n = n3 + this.size;
                    n2 = n3 + 1;
                }
                BufferUtils.populateFromBuffer((Vector3f)vector3f2, (FloatBuffer)triangleBatch.getVertexBuffer(), (int)n);
                BufferUtils.populateFromBuffer((Vector3f)vector3f, (FloatBuffer)triangleBatch.getVertexBuffer(), (int)n2);
                vector3f4.set(vector3f2).subtractLocal(vector3f3).crossLocal(vector3f.subtractLocal(vector3f3)).normalizeLocal();
                BufferUtils.setInBuffer((Vector3f)vector3f4, (FloatBuffer)triangleBatch.getNormalBuffer(), (int)n3);
                ++n3;
            }
        }
    }

    public int[] getHeightMap() {
        return this.heightMap;
    }

    public float getOffsetAmount() {
        return this.offsetAmount;
    }

    public Vector3f getStepScale() {
        return this.stepScale;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setUseClod(boolean bl) {
        this.useClod = bl;
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f vector2f) {
        this.offset = vector2f;
    }

    public boolean isUseClod() {
        return this.useClod;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public void setStepScale(Vector3f vector3f) {
        this.stepScale = vector3f;
    }

    public void setOffsetAmount(float f) {
        this.offsetAmount = f;
    }

    public void setHeightMap(int[] nArray) {
        this.heightMap = nArray;
    }

    public void updateFromHeightMap() {
        if (!this.hasChanged()) {
            return;
        }
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                vector3f.set((float)i * this.stepScale.x, (float)this.heightMap[i + j * this.size] * this.stepScale.y, (float)j * this.stepScale.z);
                BufferUtils.setInBuffer((Vector3f)vector3f, (FloatBuffer)triangleBatch.getVertexBuffer(), (int)(i + j * this.size));
            }
        }
        this.buildNormals();
        if (triangleBatch.getVBOInfo() != null) {
            triangleBatch.getVBOInfo().setVBOVertexID(-1);
            triangleBatch.getVBOInfo().setVBONormalID(-1);
            DisplaySystem.getDisplaySystem().getRenderer().deleteVBO((Buffer)this.getVertexBuffer(0));
            DisplaySystem.getDisplaySystem().getRenderer().deleteVBO((Buffer)this.getNormalBuffer(0));
        }
    }

    public void setHeightMapValue(int n, int n2, int n3) {
        this.heightMap[n + n2 * this.size] = n3;
    }

    public void addHeightMapValue(int n, int n2, int n3) {
        int n4 = n + n2 * this.size;
        this.heightMap[n4] = this.heightMap[n4] + n3;
    }

    public void multHeightMapValue(int n, int n2, int n3) {
        int n4 = n + n2 * this.size;
        this.heightMap[n4] = this.heightMap[n4] * n3;
    }

    protected boolean hasChanged() {
        boolean bl = false;
        if (this.oldHeightMap == null) {
            this.oldHeightMap = new int[this.heightMap.length];
            bl = true;
        }
        for (int i = 0; i < this.oldHeightMap.length; ++i) {
            if (this.oldHeightMap[i] == this.heightMap[i] && !bl) continue;
            bl = true;
            this.oldHeightMap[i] = this.heightMap[i];
        }
        return bl;
    }

    public short getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short s) {
        this.quadrant = s;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write(this.size, "size", 0);
        outputCapsule.write(this.totalSize, "totalSize", 0);
        outputCapsule.write(this.quadrant, "quadrant", (short)1);
        outputCapsule.write((Savable)this.stepScale, "stepScale", (Savable)Vector3f.ZERO);
        outputCapsule.write(this.useClod, "useClod", false);
        outputCapsule.write((Savable)this.offset, "offset", (Savable)new Vector2f());
        outputCapsule.write(this.offsetAmount, "offsetAmount", 0.0f);
        outputCapsule.write(this.heightMap, "heightMap", null);
        outputCapsule.write(this.oldHeightMap, "oldHeightMap", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.size = inputCapsule.readInt("size", 0);
        this.totalSize = inputCapsule.readInt("totalSize", 0);
        this.quadrant = inputCapsule.readShort("quadrant", (short)1);
        this.stepScale = (Vector3f)inputCapsule.readSavable("stepScale", (Savable)Vector3f.ZERO.clone());
        this.useClod = inputCapsule.readBoolean("useClod", false);
        this.offset = (Vector2f)inputCapsule.readSavable("offset", (Savable)new Vector2f());
        this.offsetAmount = inputCapsule.readFloat("offsetAmount", 0.0f);
        this.heightMap = inputCapsule.readIntArray("heightMap", null);
        this.oldHeightMap = inputCapsule.readIntArray("oldHeightMap", null);
    }
}

