/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.intersection.IntersectionRecord;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class BoundingBox
extends BoundingVolume {
    private static final long serialVersionUID = 2L;
    public float xExtent;
    public float yExtent;
    public float zExtent;
    private static final transient Matrix3f _compMat = new Matrix3f();
    private static final float[] fWdU = new float[3];
    private static final float[] fAWdU = new float[3];
    private static final float[] fDdU = new float[3];
    private static final float[] fADdU = new float[3];
    private static final float[] fAWxDdU = new float[3];
    private static final Vector3f[] verts = new Vector3f[3];

    public BoundingBox() {
    }

    public BoundingBox(Vector3f vector3f, float f, float f2, float f3) {
        this.center.set(vector3f);
        this.xExtent = f;
        this.yExtent = f2;
        this.zExtent = f3;
    }

    public int getType() {
        return 1;
    }

    public void computeFromPoints(FloatBuffer floatBuffer) {
        this.containAABB(floatBuffer);
    }

    public void computeFromBatches(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.containAABB(((GeomBatch)arrayList.get(0)).getVertexBuffer());
        for (int i = 1; i < arrayList.size(); ++i) {
            BoundingBox boundingBox2 = new BoundingBox();
            boundingBox2.containAABB(((GeomBatch)arrayList.get(i)).getVertexBuffer());
            boundingBox.mergeLocal(boundingBox2);
        }
        this.center = boundingBox.getCenter();
        this.xExtent = boundingBox.xExtent;
        this.yExtent = boundingBox.yExtent;
        this.zExtent = boundingBox.zExtent;
    }

    public void computeFromTris(Triangle[] triangleArray, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f vector3f = _compVect1.set(new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
        Vector3f vector3f2 = _compVect2.set(new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY));
        for (int i = n; i < n2; ++i) {
            Vector3f vector3f3 = triangleArray[i].get(0);
            this.checkMinMax(vector3f, vector3f2, vector3f3);
            vector3f3 = triangleArray[i].get(1);
            this.checkMinMax(vector3f, vector3f2, vector3f3);
            vector3f3 = triangleArray[i].get(2);
            this.checkMinMax(vector3f, vector3f2, vector3f3);
        }
        this.center.set(vector3f.addLocal(vector3f2));
        this.center.multLocal(0.5f);
        this.xExtent = vector3f2.x - this.center.x;
        this.yExtent = vector3f2.y - this.center.y;
        this.zExtent = vector3f2.z - this.center.z;
    }

    public void computeFromTris(int[] nArray, TriangleBatch triangleBatch, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f vector3f = _compVect1.set(new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
        Vector3f vector3f2 = _compVect2.set(new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY));
        for (int i = n; i < n2; ++i) {
            triangleBatch.getTriangle(nArray[i], verts);
            Vector3f vector3f3 = verts[0];
            this.checkMinMax(vector3f, vector3f2, vector3f3);
            vector3f3 = verts[1];
            this.checkMinMax(vector3f, vector3f2, vector3f3);
            vector3f3 = verts[2];
            this.checkMinMax(vector3f, vector3f2, vector3f3);
        }
        this.center.set(vector3f.addLocal(vector3f2));
        this.center.multLocal(0.5f);
        this.xExtent = vector3f2.x - this.center.x;
        this.yExtent = vector3f2.y - this.center.y;
        this.zExtent = vector3f2.z - this.center.z;
    }

    private void checkMinMax(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (vector3f3.x < vector3f.x) {
            vector3f.x = vector3f3.x;
        } else if (vector3f3.x > vector3f2.x) {
            vector3f2.x = vector3f3.x;
        }
        if (vector3f3.y < vector3f.y) {
            vector3f.y = vector3f3.y;
        } else if (vector3f3.y > vector3f2.y) {
            vector3f2.y = vector3f3.y;
        }
        if (vector3f3.z < vector3f.z) {
            vector3f.z = vector3f3.z;
        } else if (vector3f3.z > vector3f2.z) {
            vector3f2.z = vector3f3.z;
        }
    }

    public void containAABB(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return;
        }
        floatBuffer.rewind();
        if (floatBuffer.remaining() <= 2) {
            return;
        }
        BufferUtils.populateFromBuffer(_compVect1, floatBuffer, 0);
        float f = BoundingBox._compVect1.x;
        float f2 = BoundingBox._compVect1.y;
        float f3 = BoundingBox._compVect1.z;
        float f4 = BoundingBox._compVect1.x;
        float f5 = BoundingBox._compVect1.y;
        float f6 = BoundingBox._compVect1.z;
        int n = floatBuffer.remaining() / 3;
        for (int i = 1; i < n; ++i) {
            BufferUtils.populateFromBuffer(_compVect1, floatBuffer, i);
            if (BoundingBox._compVect1.x < f) {
                f = BoundingBox._compVect1.x;
            } else if (BoundingBox._compVect1.x > f4) {
                f4 = BoundingBox._compVect1.x;
            }
            if (BoundingBox._compVect1.y < f2) {
                f2 = BoundingBox._compVect1.y;
            } else if (BoundingBox._compVect1.y > f5) {
                f5 = BoundingBox._compVect1.y;
            }
            if (BoundingBox._compVect1.z < f3) {
                f3 = BoundingBox._compVect1.z;
                continue;
            }
            if (!(BoundingBox._compVect1.z > f6)) continue;
            f6 = BoundingBox._compVect1.z;
        }
        this.center.set(f + f4, f2 + f5, f3 + f6);
        this.center.multLocal(0.5f);
        this.xExtent = f4 - this.center.x;
        this.yExtent = f5 - this.center.y;
        this.zExtent = f6 - this.center.z;
    }

    public BoundingVolume transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2, BoundingVolume boundingVolume) {
        BoundingBox boundingBox = boundingVolume == null || boundingVolume.getType() != 1 ? new BoundingBox() : (BoundingBox)boundingVolume;
        this.center.mult(vector3f2, boundingBox.center);
        quaternion.mult(boundingBox.center, boundingBox.center);
        boundingBox.center.addLocal(vector3f);
        Matrix3f matrix3f = _compMat;
        matrix3f.set(quaternion);
        matrix3f.m00 = FastMath.abs(matrix3f.m00);
        matrix3f.m01 = FastMath.abs(matrix3f.m01);
        matrix3f.m02 = FastMath.abs(matrix3f.m02);
        matrix3f.m10 = FastMath.abs(matrix3f.m10);
        matrix3f.m11 = FastMath.abs(matrix3f.m11);
        matrix3f.m12 = FastMath.abs(matrix3f.m12);
        matrix3f.m20 = FastMath.abs(matrix3f.m20);
        matrix3f.m21 = FastMath.abs(matrix3f.m21);
        matrix3f.m22 = FastMath.abs(matrix3f.m22);
        _compVect1.set(this.xExtent * vector3f2.x, this.yExtent * vector3f2.y, this.zExtent * vector3f2.z);
        matrix3f.mult(_compVect1, _compVect2);
        boundingBox.xExtent = FastMath.abs(BoundingBox._compVect2.x);
        boundingBox.yExtent = FastMath.abs(BoundingBox._compVect2.y);
        boundingBox.zExtent = FastMath.abs(BoundingBox._compVect2.z);
        return boundingBox;
    }

    public int whichSide(Plane plane) {
        float f = FastMath.abs(this.xExtent * plane.normal.x) + FastMath.abs(this.yExtent * plane.normal.y) + FastMath.abs(this.zExtent * plane.normal.z);
        float f2 = plane.pseudoDistance(this.center);
        if (f2 < -f) {
            return 2;
        }
        if (f2 > f) {
            return 1;
        }
        return 0;
    }

    public BoundingVolume merge(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                return this.merge(boundingBox.center, boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent, new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            }
            case 0: {
                BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
                return this.merge(boundingSphere.center, boundingSphere.radius, boundingSphere.radius, boundingSphere.radius, new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            }
            case 3: {
                BoundingCapsule boundingCapsule = (BoundingCapsule)boundingVolume;
                float f = boundingCapsule.getRadius() + boundingCapsule.getLineSegment().getExtent();
                return this.merge(boundingCapsule.center, f, f, f, new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            }
            case 2: {
                OrientedBoundingBox orientedBoundingBox = (OrientedBoundingBox)boundingVolume;
                BoundingBox boundingBox = (BoundingBox)this.clone(null);
                return boundingBox.mergeOBB(orientedBoundingBox);
            }
        }
        return null;
    }

    public BoundingVolume mergeLocal(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                return this.merge(boundingBox.center, boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent, this);
            }
            case 0: {
                BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
                return this.merge(boundingSphere.center, boundingSphere.radius, boundingSphere.radius, boundingSphere.radius, this);
            }
            case 3: {
                BoundingCapsule boundingCapsule = (BoundingCapsule)boundingVolume;
                float f = boundingCapsule.getRadius() + boundingCapsule.getLineSegment().getExtent();
                return this.merge(boundingCapsule.center, f, f, f, this);
            }
            case 2: {
                return this.mergeOBB((OrientedBoundingBox)boundingVolume);
            }
        }
        return null;
    }

    private BoundingBox mergeOBB(OrientedBoundingBox orientedBoundingBox) {
        if (!orientedBoundingBox.correctCorners) {
            orientedBoundingBox.computeCorners();
        }
        Vector3f vector3f = _compVect1.set(this.center.x - this.xExtent, this.center.y - this.yExtent, this.center.z - this.zExtent);
        Vector3f vector3f2 = _compVect2.set(this.center.x + this.xExtent, this.center.y + this.yExtent, this.center.z + this.zExtent);
        for (int i = 1; i < orientedBoundingBox.vectorStore.length; ++i) {
            Vector3f vector3f3 = orientedBoundingBox.vectorStore[i];
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
                continue;
            }
            if (!(vector3f3.z > vector3f2.z)) continue;
            vector3f2.z = vector3f3.z;
        }
        this.center.set(vector3f.addLocal(vector3f2));
        this.center.multLocal(0.5f);
        this.xExtent = vector3f2.x - this.center.x;
        this.yExtent = vector3f2.y - this.center.y;
        this.zExtent = vector3f2.z - this.center.z;
        return this;
    }

    private BoundingBox merge(Vector3f vector3f, float f, float f2, float f3, BoundingBox boundingBox) {
        BoundingBox._compVect1.x = this.center.x - this.xExtent;
        if (BoundingBox._compVect1.x > vector3f.x - f) {
            BoundingBox._compVect1.x = vector3f.x - f;
        }
        BoundingBox._compVect1.y = this.center.y - this.yExtent;
        if (BoundingBox._compVect1.y > vector3f.y - f2) {
            BoundingBox._compVect1.y = vector3f.y - f2;
        }
        BoundingBox._compVect1.z = this.center.z - this.zExtent;
        if (BoundingBox._compVect1.z > vector3f.z - f3) {
            BoundingBox._compVect1.z = vector3f.z - f3;
        }
        BoundingBox._compVect2.x = this.center.x + this.xExtent;
        if (BoundingBox._compVect2.x < vector3f.x + f) {
            BoundingBox._compVect2.x = vector3f.x + f;
        }
        BoundingBox._compVect2.y = this.center.y + this.yExtent;
        if (BoundingBox._compVect2.y < vector3f.y + f2) {
            BoundingBox._compVect2.y = vector3f.y + f2;
        }
        BoundingBox._compVect2.z = this.center.z + this.zExtent;
        if (BoundingBox._compVect2.z < vector3f.z + f3) {
            BoundingBox._compVect2.z = vector3f.z + f3;
        }
        this.center.set(_compVect2).addLocal(_compVect1).multLocal(0.5f);
        this.xExtent = BoundingBox._compVect2.x - this.center.x;
        this.yExtent = BoundingBox._compVect2.y - this.center.y;
        this.zExtent = BoundingBox._compVect2.z - this.center.z;
        return boundingBox;
    }

    public BoundingVolume clone(BoundingVolume boundingVolume) {
        if (boundingVolume != null && boundingVolume.getType() == 1) {
            BoundingBox boundingBox = (BoundingBox)boundingVolume;
            boundingBox.center.set(this.center);
            boundingBox.xExtent = this.xExtent;
            boundingBox.yExtent = this.yExtent;
            boundingBox.zExtent = this.zExtent;
            boundingBox.checkPlane = this.checkPlane;
            return boundingBox;
        }
        BoundingBox boundingBox = new BoundingBox(this.center != null ? this.center.clone() : null, this.xExtent, this.yExtent, this.zExtent);
        return boundingBox;
    }

    public String toString() {
        return "com.jme.scene.BoundingBox [Center: " + this.center + "  xExtent: " + this.xExtent + "  yExtent: " + this.yExtent + "  zExtent: " + this.zExtent + "]";
    }

    public boolean intersects(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return false;
        }
        return boundingVolume.intersectsBoundingBox(this);
    }

    public boolean intersectsSphere(BoundingSphere boundingSphere) {
        return FastMath.abs(this.center.x - boundingSphere.getCenter().x) < boundingSphere.getRadius() + this.xExtent && FastMath.abs(this.center.y - boundingSphere.getCenter().y) < boundingSphere.getRadius() + this.yExtent && FastMath.abs(this.center.z - boundingSphere.getCenter().z) < boundingSphere.getRadius() + this.zExtent;
    }

    public boolean intersectsBoundingBox(BoundingBox boundingBox) {
        if (this.center.x + this.xExtent < boundingBox.center.x - boundingBox.xExtent || this.center.x - this.xExtent > boundingBox.center.x + boundingBox.xExtent) {
            return false;
        }
        if (this.center.y + this.yExtent < boundingBox.center.y - boundingBox.yExtent || this.center.y - this.yExtent > boundingBox.center.y + boundingBox.yExtent) {
            return false;
        }
        return !(this.center.z + this.zExtent < boundingBox.center.z - boundingBox.zExtent) && !(this.center.z - this.zExtent > boundingBox.center.z + boundingBox.zExtent);
    }

    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox orientedBoundingBox) {
        return orientedBoundingBox.intersectsBoundingBox(this);
    }

    public boolean intersectsCapsule(BoundingCapsule boundingCapsule) {
        return boundingCapsule.intersectsBoundingBox(this);
    }

    public boolean intersects(Ray ray) {
        Vector3f vector3f = ray.origin.subtract(this.getCenter(_compVect2), _compVect1);
        BoundingBox.fWdU[0] = ray.getDirection().dot(Vector3f.UNIT_X);
        BoundingBox.fAWdU[0] = FastMath.abs(fWdU[0]);
        BoundingBox.fDdU[0] = vector3f.dot(Vector3f.UNIT_X);
        BoundingBox.fADdU[0] = FastMath.abs(fDdU[0]);
        if (fADdU[0] > this.xExtent && (double)(fDdU[0] * fWdU[0]) >= 0.0) {
            return false;
        }
        BoundingBox.fWdU[1] = ray.getDirection().dot(Vector3f.UNIT_Y);
        BoundingBox.fAWdU[1] = FastMath.abs(fWdU[1]);
        BoundingBox.fDdU[1] = vector3f.dot(Vector3f.UNIT_Y);
        BoundingBox.fADdU[1] = FastMath.abs(fDdU[1]);
        if (fADdU[1] > this.yExtent && (double)(fDdU[1] * fWdU[1]) >= 0.0) {
            return false;
        }
        BoundingBox.fWdU[2] = ray.getDirection().dot(Vector3f.UNIT_Z);
        BoundingBox.fAWdU[2] = FastMath.abs(fWdU[2]);
        BoundingBox.fDdU[2] = vector3f.dot(Vector3f.UNIT_Z);
        BoundingBox.fADdU[2] = FastMath.abs(fDdU[2]);
        if (fADdU[2] > this.zExtent && (double)(fDdU[2] * fWdU[2]) >= 0.0) {
            return false;
        }
        Vector3f vector3f2 = ray.getDirection().cross(vector3f, _compVect2);
        BoundingBox.fAWxDdU[0] = FastMath.abs(vector3f2.dot(Vector3f.UNIT_X));
        float f = this.yExtent * fAWdU[2] + this.zExtent * fAWdU[1];
        if (fAWxDdU[0] > f) {
            return false;
        }
        BoundingBox.fAWxDdU[1] = FastMath.abs(vector3f2.dot(Vector3f.UNIT_Y));
        f = this.xExtent * fAWdU[2] + this.zExtent * fAWdU[0];
        if (fAWxDdU[1] > f) {
            return false;
        }
        BoundingBox.fAWxDdU[2] = FastMath.abs(vector3f2.dot(Vector3f.UNIT_Z));
        f = this.xExtent * fAWdU[1] + this.yExtent * fAWdU[0];
        return !(fAWxDdU[2] > f);
    }

    public IntersectionRecord intersectsWhere(Ray ray) {
        boolean bl;
        Vector3f vector3f = _compVect1.set(ray.origin).subtractLocal(this.center);
        Vector3f vector3f2 = _compVect2.set(ray.direction.x, ray.direction.y, ray.direction.z);
        float[] fArray = new float[]{0.0f, Float.POSITIVE_INFINITY};
        float f = fArray[0];
        float f2 = fArray[1];
        boolean bl2 = bl = this.clip(vector3f2.x, -vector3f.x - this.xExtent, fArray) && this.clip(-vector3f2.x, vector3f.x - this.xExtent, fArray) && this.clip(vector3f2.y, -vector3f.y - this.yExtent, fArray) && this.clip(-vector3f2.y, vector3f.y - this.yExtent, fArray) && this.clip(vector3f2.z, -vector3f.z - this.zExtent, fArray) && this.clip(-vector3f2.z, vector3f.z - this.zExtent, fArray);
        if (bl && (fArray[0] != f || fArray[1] != f2)) {
            if (fArray[1] > fArray[0]) {
                float[] fArray2 = fArray;
                Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray2[0]).addLocal(ray.origin), new Vector3f(ray.direction).multLocal(fArray2[1]).addLocal(ray.origin)};
                IntersectionRecord intersectionRecord = new IntersectionRecord(fArray2, vector3fArray);
                return intersectionRecord;
            }
            float[] fArray3 = new float[]{fArray[0]};
            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray3[0]).addLocal(ray.origin)};
            IntersectionRecord intersectionRecord = new IntersectionRecord(fArray3, vector3fArray);
            return intersectionRecord;
        }
        return new IntersectionRecord();
    }

    public boolean contains(Vector3f vector3f) {
        return FastMath.abs(this.center.x - vector3f.x) < this.xExtent && FastMath.abs(this.center.y - vector3f.y) < this.yExtent && FastMath.abs(this.center.z - vector3f.z) < this.zExtent;
    }

    public float distanceToEdge(Vector3f vector3f) {
        float f;
        Vector3f vector3f2 = vector3f.subtract(this.center);
        float f2 = 0.0f;
        if (vector3f2.x < -this.xExtent) {
            f = vector3f2.x + this.xExtent;
            f2 += f * f;
            vector3f2.x = -this.xExtent;
        } else if (vector3f2.x > this.xExtent) {
            f = vector3f2.x - this.xExtent;
            f2 += f * f;
            vector3f2.x = this.xExtent;
        }
        if (vector3f2.y < -this.yExtent) {
            f = vector3f2.y + this.yExtent;
            f2 += f * f;
            vector3f2.y = -this.yExtent;
        } else if (vector3f2.y > this.yExtent) {
            f = vector3f2.y - this.yExtent;
            f2 += f * f;
            vector3f2.y = this.yExtent;
        }
        if (vector3f2.z < -this.zExtent) {
            f = vector3f2.z + this.zExtent;
            f2 += f * f;
            vector3f2.z = -this.zExtent;
        } else if (vector3f2.z > this.zExtent) {
            f = vector3f2.z - this.zExtent;
            f2 += f * f;
            vector3f2.z = this.zExtent;
        }
        return FastMath.sqrt(f2);
    }

    private boolean clip(float f, float f2, float[] fArray) {
        if (f > 0.0f) {
            if (f2 > f * fArray[1]) {
                return false;
            }
            if (f2 > f * fArray[0]) {
                fArray[0] = f2 / f;
            }
            return true;
        }
        if (f < 0.0f) {
            if (f2 > f * fArray[0]) {
                return false;
            }
            if (f2 > f * fArray[1]) {
                fArray[1] = f2 / f;
            }
            return true;
        }
        return (double)f2 <= 0.0;
    }

    public Vector3f getExtent(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.xExtent, this.yExtent, this.zExtent);
        return vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.xExtent, "xExtent", 0.0f);
        outputCapsule.write(this.yExtent, "yExtent", 0.0f);
        outputCapsule.write(this.zExtent, "zExtent", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.xExtent = inputCapsule.readFloat("xExtent", 0.0f);
        this.yExtent = inputCapsule.readFloat("yExtent", 0.0f);
        this.zExtent = inputCapsule.readFloat("zExtent", 0.0f);
    }

    public float getVolume() {
        return 8.0f * this.xExtent * this.yExtent * this.zExtent;
    }
}

