/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;

public class BitmapHeader {
    public int bitcount;
    private int size;
    private int bisize;
    private int width;
    private int height;
    private int planes;
    private int compression;
    private int sizeimage;
    private int xpm;
    private int ypm;
    private int clrused;
    private int clrimp;

    public Image readMap32(byte[] byArray) {
        int n;
        int n2 = this.sizeimage / this.height;
        int[] nArray = new int[this.height * this.width];
        byte[] byArray2 = new byte[this.width * 4 * this.height];
        for (n = 0; n < this.width * 4 * this.height && n + 54 < byArray.length; ++n) {
            byArray2[n] = byArray[n + 54];
        }
        n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                nArray[this.width * (this.height - i - 1) + j] = this.constructInt3(byArray2, n);
                n += 4;
            }
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
        return image;
    }

    public Image readMap24(byte[] byArray) throws IOException {
        int n;
        int n2 = this.sizeimage / this.height - this.width * 3;
        int[] nArray = new int[this.height * this.width];
        byte[] byArray2 = new byte[(this.width + n2) * 3 * this.height];
        for (n = 0; n < byArray2.length && n + 54 < byArray.length; ++n) {
            byArray2[n] = byArray[n + 54];
        }
        n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                nArray[this.width * (this.height - i - 1) + j] = this.constructInt3(byArray2, n);
                n += 3;
            }
            n += n2;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray, 0, this.width));
        return image;
    }

    public Image readMap8(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        n4 = this.clrused > 0 ? this.clrused : 1 << this.bitcount;
        if (this.sizeimage == 0) {
            this.sizeimage = (this.width * this.bitcount + 31 & 0xFFFFFFE0) >> 3;
            this.sizeimage *= this.height;
        }
        int[] nArray = new int[n4];
        byte[] byArray2 = new byte[n4 * 4];
        for (n3 = 0; n3 < n4 * 4; ++n3) {
            byArray2[n3] = byArray[n3 + 54];
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.constructInt3(byArray2, n3);
            n3 += 4;
        }
        n2 = this.sizeimage / this.height - this.width;
        int[] nArray2 = new int[this.width * this.height];
        byte[] byArray3 = new byte[(this.width + n2) * this.height];
        for (n = 0; n < byArray3.length; ++n) {
            byArray3[n] = byArray[n + byArray2.length + 54];
        }
        n3 = 0;
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                nArray2[this.width * (this.height - n - 1) + i] = nArray[byArray3[n3] & 0xFF];
                ++n3;
            }
            n3 += n2;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, nArray2, 0, this.width));
        return image;
    }

    private int constructInt(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    private int constructInt3(byte[] byArray, int n) {
        int n2 = 255;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    private long constructLong(byte[] byArray, int n) {
        long l = (long)byArray[n + 7] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 6] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 5] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 4] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 3] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 2] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 1] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 0] & 0xFFL;
        return l;
    }

    private double constructDouble(byte[] byArray, int n) {
        long l = this.constructLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    private short constructShort(byte[] byArray, int n) {
        short s = (short)(byArray[n + 1] & 0xFF);
        s = (short)(s << 8 | (short)(byArray[n + 0] & 0xFF));
        return s;
    }

    public final void read(byte[] byArray) {
        byte[] byArray2 = new byte[14];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[i];
        }
        byte[] byArray3 = new byte[40];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = byArray[i + 14];
        }
        this.size = this.constructInt(byArray2, 2);
        this.bisize = this.constructInt(byArray3, 2);
        this.width = this.constructInt(byArray3, 4);
        this.height = this.constructInt(byArray3, 8);
        this.planes = this.constructShort(byArray3, 12);
        this.bitcount = this.constructShort(byArray3, 14);
        this.compression = this.constructInt(byArray3, 16);
        this.sizeimage = this.constructInt(byArray3, 20) == 0 ? this.size - this.constructInt(byArray2, 10) : this.constructInt(byArray3, 20);
        this.xpm = this.constructInt(byArray3, 24);
        this.ypm = this.constructInt(byArray3, 28);
        this.clrused = this.constructInt(byArray3, 32);
        this.clrimp = this.constructInt(byArray3, 36);
    }
}

