/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.controller;

import com.jme.input.controls.GameControl;
import com.jme.input.controls.controller.Axis;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;

public class ThrottleController
extends Controller {
    private static final long serialVersionUID = 1L;
    private Spatial spatial;
    private GameControl forward;
    private float maxForwardThrottle;
    private GameControl reverse;
    private float maxReverseThrottle;
    private float deadZone;
    private float multiplier;
    private float degradation;
    private boolean alwaysDegrade;
    private Axis axis;
    private long zeroEncountered;
    private float currentThrottle;

    public ThrottleController(Spatial spatial, GameControl gameControl, float f, GameControl gameControl2, float f2, float f3, float f4, float f5, boolean bl, Axis axis) {
        this.spatial = spatial;
        this.forward = gameControl;
        this.maxForwardThrottle = f;
        this.reverse = gameControl2;
        this.maxReverseThrottle = f2;
        this.deadZone = f3;
        this.multiplier = f4;
        this.degradation = f5;
        this.alwaysDegrade = bl;
        this.axis = axis;
    }

    public GameControl getForward() {
        return this.forward;
    }

    public GameControl getReverse() {
        return this.reverse;
    }

    public float getCurrentThrottle() {
        return this.currentThrottle;
    }

    public float getThrust() {
        return this.forward.getValue() - this.reverse.getValue();
    }

    public void update(float f) {
        if (System.currentTimeMillis() < this.zeroEncountered + 50L) {
            return;
        }
        float f2 = this.getThrust();
        if (f2 < this.deadZone && f2 > -this.deadZone) {
            f2 = 0.0f;
        }
        float f3 = f * this.multiplier;
        float f4 = this.maxForwardThrottle;
        float f5 = this.maxReverseThrottle;
        if (f2 > 0.0f) {
            f4 = this.maxForwardThrottle * f2;
        } else if (f2 < 0.0f) {
            f5 = this.maxReverseThrottle * -f2;
        } else if (this.currentThrottle > 0.0f) {
            f5 = 0.0f;
        } else {
            f4 = 0.0f;
        }
        if (f2 < 0.0f) {
            f3 = -f3;
        } else if (f2 == 0.0f) {
            if (this.currentThrottle > 0.0f) {
                f3 = this.forward.hasTrueAxis() || this.alwaysDegrade ? -f3 * this.degradation : 0.0f;
            } else if (this.currentThrottle < 0.0f) {
                f3 = this.reverse.hasTrueAxis() || this.alwaysDegrade ? (f3 *= this.degradation) : 0.0f;
            }
        }
        if (this.currentThrottle > 0.0f && this.currentThrottle + f3 < 0.0f) {
            this.currentThrottle = 0.0f;
            this.zeroEncountered = System.currentTimeMillis();
        } else if (this.currentThrottle < 0.0f && this.currentThrottle + f3 > 0.0f) {
            this.currentThrottle = 0.0f;
            this.zeroEncountered = System.currentTimeMillis();
        } else {
            this.currentThrottle += f3;
        }
        if (this.currentThrottle > f4) {
            this.currentThrottle = f4;
        } else if (this.currentThrottle < f5) {
            this.currentThrottle = f5;
        }
        if (this.currentThrottle != 0.0f) {
            if (this.axis == Axis.X) {
                this.spatial.getLocalTranslation().addLocal(this.spatial.getLocalRotation().getRotationColumn(0).mult(this.currentThrottle * f));
            } else if (this.axis == Axis.Y) {
                this.spatial.getLocalTranslation().addLocal(this.spatial.getLocalRotation().getRotationColumn(1).mult(this.currentThrottle * f));
            } else if (this.axis == Axis.Z) {
                this.spatial.getLocalTranslation().addLocal(this.spatial.getLocalRotation().getRotationColumn(2).mult(this.currentThrottle * f));
            } else {
                throw new RuntimeException("Unknown axis: " + (Object)((Object)this.axis));
            }
        }
    }
}

