/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.IntBuffer;

public class PQTorus
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private float p;
    private float q;
    private float radius;
    private float width;
    private int steps;
    private int radialSamples;

    public PQTorus() {
    }

    public PQTorus(String string, float f, float f2, float f3, float f4, int n, int n2) {
        super(string);
        this.p = f;
        this.q = f2;
        this.radius = f3;
        this.width = f4;
        this.steps = n;
        this.radialSamples = n2;
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        float f = (float)Math.PI * 2 / (float)this.steps;
        float f2 = (float)Math.PI * 2 / (float)this.radialSamples;
        Vector3f[] vector3fArray = new Vector3f[this.steps];
        triangleBatch.setVertexCount(this.radialSamples * this.steps);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = 0;
        for (int i = 0; i < this.steps; ++i) {
            float f5 = (float)i / (float)this.steps;
            float f6 = 0.5f * (2.0f + FastMath.sin(this.q * (f3 += f))) * this.radius;
            float f7 = f6 * FastMath.cos(this.p * f3) * this.radius;
            float f8 = f6 * FastMath.sin(this.p * f3) * this.radius;
            float f9 = f6 * FastMath.cos(this.q * f3) * this.radius;
            vector3fArray[i] = new Vector3f(f7, f8, f9);
            f6 = 0.5f * (2.0f + FastMath.sin(this.q * (f3 + 0.01f))) * this.radius;
            f7 = f6 * FastMath.cos(this.p * (f3 + 0.01f)) * this.radius;
            f8 = f6 * FastMath.sin(this.p * (f3 + 0.01f)) * this.radius;
            f9 = f6 * FastMath.cos(this.q * (f3 + 0.01f)) * this.radius;
            vector3f = new Vector3f(f7, f8, f9);
            vector3f2 = vector3f.subtract(vector3fArray[i]);
            vector3f3 = vector3fArray[i].add(vector3f);
            vector3f4 = vector3f2.cross(vector3f3);
            vector3f3 = vector3f4.cross(vector3f2);
            vector3f3 = vector3f3.normalize();
            vector3f4 = vector3f4.normalize();
            f4 = 0.0f;
            for (int j = 0; j < this.radialSamples; ++j) {
                float f10 = FastMath.cos(f4 += f2) * this.width;
                float f11 = FastMath.sin(f4) * this.width;
                float f12 = (float)j / (float)this.radialSamples;
                vector3f5.x = f10 * vector3f3.x + f11 * vector3f4.x;
                vector3f5.y = f10 * vector3f3.y + f11 * vector3f4.y;
                vector3f5.z = f10 * vector3f3.z + f11 * vector3f4.z;
                triangleBatch.getNormalBuffer().put(vector3f5.x).put(vector3f5.y).put(vector3f5.z);
                vector3f5.addLocal(vector3fArray[i]);
                triangleBatch.getVertexBuffer().put(vector3f5.x).put(vector3f5.y).put(vector3f5.z);
                triangleBatch.getTextureBuffers().get(0).put(f12).put(f5);
                ++n;
            }
        }
    }

    private void setIndexData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(6 * triangleBatch.getVertexCount());
        for (n = 0; n < triangleBatch.getVertexCount(); ++n) {
            intBuffer.put(n);
            intBuffer.put(n - this.radialSamples);
            intBuffer.put(n + 1);
            intBuffer.put(n + 1);
            intBuffer.put(n - this.radialSamples);
            intBuffer.put(n - this.radialSamples + 1);
        }
        int n2 = intBuffer.capacity();
        for (n = 0; n < n2; ++n) {
            int n3 = intBuffer.get(n);
            if (n3 < 0) {
                intBuffer.put(n, n3 += triangleBatch.getVertexCount());
            }
            if (n3 < triangleBatch.getVertexCount()) continue;
            intBuffer.put(n, n3 -= triangleBatch.getVertexCount());
        }
        intBuffer.rewind();
        triangleBatch.setIndexBuffer(intBuffer);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.p, "p", 0.0f);
        outputCapsule.write(this.q, "q", 0.0f);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.width, "width", 0.0f);
        outputCapsule.write(this.steps, "steps", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.p = inputCapsule.readFloat("p", 0.0f);
        this.q = inputCapsule.readFloat("q", 0.0f);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.width = inputCapsule.readFloat("width", 0.0f);
        this.steps = inputCapsule.readInt("steps", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
    }
}

