/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class RoundedBox
extends TriMesh
implements Savable {
    private static final long serialVersionUID = 1L;
    private Vector3f extent = new Vector3f(0.5f, 0.5f, 0.5f);
    private Vector3f border = new Vector3f(0.05f, 0.05f, 0.05f);
    private Vector3f slope = new Vector3f(0.02f, 0.02f, 0.02f);

    public RoundedBox(String string) {
        super(string);
        this.setData();
    }

    public RoundedBox(String string, Vector3f vector3f) {
        super(string);
        this.extent = vector3f.subtract(this.slope);
        this.setData();
    }

    public RoundedBox(String string, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        super(string);
        this.extent = vector3f.subtract(vector3f3);
        this.border = vector3f2;
        this.slope = vector3f3;
        this.setData();
    }

    public RoundedBox() {
    }

    private void setData() {
        this.setVertexAndNormalData();
        this.setTextureData();
        this.setIndexData();
    }

    private void put(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, Vector3f vector3f) {
        floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
        Vector3f vector3f2 = vector3f.normalize();
        floatBuffer2.put(vector3f2.x).put(vector3f2.y).put(vector3f2.z);
    }

    private void setVertexAndNormalData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), 48));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(48));
        triangleBatch.setVertexCount(48);
        Vector3f[] vector3fArray = this.computeVertices();
        FloatBuffer floatBuffer = triangleBatch.getVertexBuffer();
        FloatBuffer floatBuffer2 = triangleBatch.getNormalBuffer();
        this.put(floatBuffer, floatBuffer2, vector3fArray[0]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[1]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[2]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[3]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[8]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[9]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[10]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[11]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[1]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[0]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[5]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[4]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[13]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[12]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[15]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[14]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[3]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[1]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[7]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[5]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[17]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[16]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[19]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[18]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[2]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[3]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[6]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[7]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[20]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[21]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[22]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[23]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[0]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[2]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[4]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[6]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[24]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[25]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[26]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[27]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[5]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[4]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[7]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[6]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[29]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[28]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[31]);
        this.put(floatBuffer, floatBuffer2, vector3fArray[30]);
    }

    private void setTextureData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getTextureBuffers().get(0) == null) {
            triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(48));
            FloatBuffer floatBuffer = triangleBatch.getTextureBuffers().get(0);
            float[][] fArrayArray = new float[][]{{0.5f * this.border.x / (this.extent.x + this.slope.x), 0.5f * this.border.z / (this.extent.z + this.slope.z)}, {0.5f * this.border.x / (this.extent.x + this.slope.x), 0.5f * this.border.y / (this.extent.y + this.slope.y)}, {0.5f * this.border.z / (this.extent.z + this.slope.z), 0.5f * this.border.y / (this.extent.y + this.slope.y)}, {0.5f * this.border.x / (this.extent.x + this.slope.x), 0.5f * this.border.y / (this.extent.y + this.slope.y)}, {0.5f * this.border.z / (this.extent.z + this.slope.z), 0.5f * this.border.y / (this.extent.y + this.slope.y)}, {0.5f * this.border.x / (this.extent.x + this.slope.x), 0.5f * this.border.z / (this.extent.z + this.slope.z)}};
            for (int i = 0; i < 6; ++i) {
                floatBuffer.put(1.0f).put(0.0f);
                floatBuffer.put(0.0f).put(0.0f);
                floatBuffer.put(1.0f).put(1.0f);
                floatBuffer.put(0.0f).put(1.0f);
                floatBuffer.put(1.0f - fArrayArray[i][0]).put(0.0f + fArrayArray[i][1]);
                floatBuffer.put(0.0f + fArrayArray[i][0]).put(0.0f + fArrayArray[i][1]);
                floatBuffer.put(1.0f - fArrayArray[i][0]).put(1.0f - fArrayArray[i][1]);
                floatBuffer.put(0.0f + fArrayArray[i][0]).put(1.0f - fArrayArray[i][1]);
            }
        }
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        if (triangleBatch.getIndexBuffer() == null) {
            int[] nArray = new int[180];
            int[] nArray2 = new int[]{0, 4, 1, 1, 4, 5, 1, 5, 3, 3, 5, 7, 3, 7, 2, 2, 7, 6, 2, 6, 0, 0, 6, 4, 4, 6, 5, 5, 6, 7};
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 30; ++j) {
                    nArray[30 * i + j] = 8 * i + nArray2[j];
                }
            }
            triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(nArray));
        }
    }

    public Vector3f[] computeVertices() {
        return new Vector3f[]{new Vector3f(-this.extent.x, -this.extent.y, this.extent.z), new Vector3f(this.extent.x, -this.extent.y, this.extent.z), new Vector3f(-this.extent.x, -this.extent.y, -this.extent.z), new Vector3f(this.extent.x, -this.extent.y, -this.extent.z), new Vector3f(-this.extent.x, this.extent.y, this.extent.z), new Vector3f(this.extent.x, this.extent.y, this.extent.z), new Vector3f(-this.extent.x, this.extent.y, -this.extent.z), new Vector3f(this.extent.x, this.extent.y, -this.extent.z), new Vector3f(-this.extent.x + this.border.x, -this.extent.y - this.slope.y, this.extent.z - this.border.z), new Vector3f(this.extent.x - this.border.x, -this.extent.y - this.slope.y, this.extent.z - this.border.z), new Vector3f(-this.extent.x + this.border.x, -this.extent.y - this.slope.y, -this.extent.z + this.border.z), new Vector3f(this.extent.x - this.border.x, -this.extent.y - this.slope.y, -this.extent.z + this.border.z), new Vector3f(-this.extent.x + this.border.x, -this.extent.y + this.border.y, this.extent.z + this.slope.z), new Vector3f(this.extent.x - this.border.x, -this.extent.y + this.border.y, this.extent.z + this.slope.z), new Vector3f(-this.extent.x + this.border.x, this.extent.y - this.border.y, this.extent.z + this.slope.z), new Vector3f(this.extent.x - this.border.x, this.extent.y - this.border.y, this.extent.z + this.slope.z), new Vector3f(this.extent.x + this.slope.x, -this.extent.y + this.border.y, this.extent.z - this.border.z), new Vector3f(this.extent.x + this.slope.x, -this.extent.y + this.border.y, -this.extent.z + this.border.z), new Vector3f(this.extent.x + this.slope.x, this.extent.y - this.border.y, this.extent.z - this.border.z), new Vector3f(this.extent.x + this.slope.x, this.extent.y - this.border.y, -this.extent.z + this.border.z), new Vector3f(-this.extent.x + this.border.x, -this.extent.y + this.border.y, -this.extent.z - this.slope.z), new Vector3f(this.extent.x - this.border.x, -this.extent.y + this.border.y, -this.extent.z - this.slope.z), new Vector3f(-this.extent.x + this.border.x, this.extent.y - this.border.y, -this.extent.z - this.slope.z), new Vector3f(this.extent.x - this.border.x, this.extent.y - this.border.y, -this.extent.z - this.slope.z), new Vector3f(-this.extent.x - this.slope.x, -this.extent.y + this.border.y, this.extent.z - this.border.z), new Vector3f(-this.extent.x - this.slope.x, -this.extent.y + this.border.y, -this.extent.z + this.border.z), new Vector3f(-this.extent.x - this.slope.x, this.extent.y - this.border.y, this.extent.z - this.border.z), new Vector3f(-this.extent.x - this.slope.x, this.extent.y - this.border.y, -this.extent.z + this.border.z), new Vector3f(-this.extent.x + this.border.x, this.extent.y + this.slope.y, this.extent.z - this.border.z), new Vector3f(this.extent.x - this.border.x, this.extent.y + this.slope.y, this.extent.z - this.border.z), new Vector3f(-this.extent.x + this.border.x, this.extent.y + this.slope.y, -this.extent.z + this.border.z), new Vector3f(this.extent.x - this.border.x, this.extent.y + this.slope.y, -this.extent.z + this.border.z)};
    }

    public Object clone() {
        return new RoundedBox(this.getName() + "_clone", this.extent.clone(), this.border.clone(), this.slope.clone());
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.extent, "extent", Vector3f.ZERO);
        outputCapsule.write(this.border, "border", Vector3f.ZERO);
        outputCapsule.write(this.slope, "slope", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.extent.set((Vector3f)inputCapsule.readSavable("extent", Vector3f.ZERO.clone()));
        this.border.set((Vector3f)inputCapsule.readSavable("border", Vector3f.ZERO.clone()));
        this.slope.set((Vector3f)inputCapsule.readSavable("slope", Vector3f.ZERO.clone()));
    }
}

