/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityCache<K, V> {
    private Entry<K, V>[] entries;
    private int size;
    private int threshold = 16;
    private static final float LOAD = 0.75f;
    private final ReferenceQueue<K> refqueue = new ReferenceQueue();

    public WeakIdentityCache() {
        this.entries = new Entry[this.threshold];
    }

    private int hash(K k) {
        int n = System.identityHashCode(k);
        return n - (n << 7);
    }

    private int index(int n, int n2) {
        return n & n2 - 1;
    }

    private void resize(int n) {
        this.expunge();
        int n2 = this.entries.length;
        if (this.size < this.threshold || n2 > n) {
            return;
        }
        Entry[] entryArray = new Entry[n];
        this.transfer(this.entries, entryArray);
        this.entries = entryArray;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * 0.75f);
        } else {
            this.expunge();
            this.transfer(entryArray, this.entries);
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.nextEntry;
                if (entry.get() == null) {
                    entry.nextEntry = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n = this.index(entry.hash, entryArray2.length);
                    entry.nextEntry = (Entry)entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    public V get(K k) {
        this.expunge();
        int n = this.hash(k);
        int n2 = this.index(n, this.entries.length);
        Entry entry = this.entries[n2];
        while (entry != null) {
            if (entry.hash == n && k == entry.get()) {
                return (V)entry.value;
            }
            entry = entry.nextEntry;
        }
        return null;
    }

    public V put(K k, V v) {
        this.expunge();
        int n = this.hash(k);
        int n2 = this.index(n, this.entries.length);
        Entry entry = this.entries[n2];
        while (entry != null) {
            if (n == entry.hash && k == entry.get()) {
                Object object = entry.value;
                if (v != object) {
                    entry.value = v;
                }
                return (V)object;
            }
            entry = entry.nextEntry;
        }
        this.entries[n2] = new Entry<K, V>(k, v, this.refqueue, n, this.entries[n2]);
        if (++this.size >= this.threshold) {
            this.resize(this.entries.length * 2);
        }
        return null;
    }

    public V remove(K k) {
        Entry entry;
        this.expunge();
        int n = this.hash(k);
        int n2 = this.index(n, this.entries.length);
        Entry entry2 = entry = this.entries[n2];
        while (entry != null) {
            Entry entry3 = entry.nextEntry;
            if (n == entry.hash && k == entry.get()) {
                --this.size;
                if (entry2 == entry) {
                    this.entries[n2] = entry3;
                } else {
                    entry2.nextEntry = entry3;
                }
                return (V)entry.value;
            }
            entry2 = entry;
            entry = entry3;
        }
        return null;
    }

    public void clear() {
        while (this.refqueue.poll() != null) {
        }
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.size = 0;
        while (this.refqueue.poll() != null) {
        }
    }

    public void expunge() {
        Entry entry;
        block0: while ((entry = (Entry)this.refqueue.poll()) != null) {
            Entry entry2;
            int n = this.index(entry.hash, this.entries.length);
            Entry entry3 = entry2 = this.entries[n];
            while (entry2 != null) {
                Entry entry4 = entry2.nextEntry;
                if (entry2 == entry) {
                    if (entry3 == entry) {
                        this.entries[n] = entry4;
                    } else {
                        entry3.nextEntry = entry4;
                    }
                    entry.nextEntry = null;
                    entry.value = null;
                    --this.size;
                    continue block0;
                }
                entry3 = entry2;
                entry2 = entry4;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends WeakReference<K> {
        private Entry<K, V> nextEntry;
        private V value;
        private final int hash;

        Entry(K k, V v, ReferenceQueue<K> referenceQueue, int n, Entry<K, V> entry) {
            super(k, referenceQueue);
            this.value = v;
            this.hash = n;
            this.nextEntry = entry;
        }
    }
}

