/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteUtils {
    public static byte[] getByteContent(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray = new byte[1024];
        int n = -1;
        byte[] byArray2 = null;
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static void writeShort(OutputStream outputStream, short s) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(s);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static short readShort(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        short s = ByteUtils.convertShortFromBytes(byArray);
        return s;
    }

    public static short convertShortFromBytes(byte[] byArray) {
        return ByteUtils.convertShortFromBytes(byArray, 0);
    }

    public static short convertShortFromBytes(byte[] byArray, int n) {
        short s = (short)((byArray[n + 1] & 0xFF) + ((byArray[n + 0] & 0xFF) << 8));
        return s;
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(n);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n = ByteUtils.convertIntFromBytes(byArray);
        return n;
    }

    public static int convertIntFromBytes(byte[] byArray) {
        return ByteUtils.convertIntFromBytes(byArray, 0);
    }

    public static int convertIntFromBytes(byte[] byArray, int n) {
        int n2 = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        return n2;
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(l);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(long l) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >>>= 8);
        byArray[5] = (byte)(l >>>= 8);
        byArray[4] = (byte)(l >>>= 8);
        byArray[3] = (byte)(l >>>= 8);
        byArray[2] = (byte)(l >>>= 8);
        byArray[1] = (byte)(l >>>= 8);
        byArray[0] = (byte)(l >>>= 8);
        return byArray;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        inputStream.read(byArray);
        long l = ByteUtils.convertLongFromBytes(byArray);
        return l;
    }

    public static long convertLongFromBytes(byte[] byArray) {
        return ByteUtils.convertLongFromBytes(byArray, 0);
    }

    public static long convertLongFromBytes(byte[] byArray, int n) {
        return ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 0] & 0xFFL) << 56);
    }

    public static void writeDouble(OutputStream outputStream, double d) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(d);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(double d) {
        long l = Double.doubleToLongBits(d);
        return ByteUtils.convertToBytes(l);
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        inputStream.read(byArray);
        double d = ByteUtils.convertDoubleFromBytes(byArray);
        return d;
    }

    public static double convertDoubleFromBytes(byte[] byArray) {
        return ByteUtils.convertDoubleFromBytes(byArray, 0);
    }

    public static double convertDoubleFromBytes(byte[] byArray, int n) {
        long l = ByteUtils.convertLongFromBytes(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static void writeFloat(OutputStream outputStream, float f) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(f);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(float f) {
        int n = Float.floatToIntBits(f);
        return ByteUtils.convertToBytes(n);
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        float f = ByteUtils.convertFloatFromBytes(byArray);
        return f;
    }

    public static float convertFloatFromBytes(byte[] byArray) {
        return ByteUtils.convertFloatFromBytes(byArray, 0);
    }

    public static float convertFloatFromBytes(byte[] byArray, int n) {
        int n2 = ByteUtils.convertIntFromBytes(byArray, n);
        return Float.intBitsToFloat(n2);
    }

    public static void writeBoolean(OutputStream outputStream, boolean bl) throws IOException {
        byte[] byArray = ByteUtils.convertToBytes(bl);
        outputStream.write(byArray);
    }

    public static byte[] convertToBytes(boolean bl) {
        byte[] byArray = new byte[]{bl ? (byte)1 : 0};
        return byArray;
    }

    public static boolean readBoolean(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1];
        inputStream.read(byArray);
        return ByteUtils.convertBooleanFromBytes(byArray);
    }

    public static boolean convertBooleanFromBytes(byte[] byArray) {
        return ByteUtils.convertBooleanFromBytes(byArray, 0);
    }

    public static boolean convertBooleanFromBytes(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static byte[] readData(byte[] byArray, int n, InputStream inputStream) throws IOException {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)inputStream.read();
        }
        return byArray;
    }

    public static byte[] rightAlignBytes(byte[] byArray, int n) {
        if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            for (int i = n - byArray.length; i < n; ++i) {
                byArray2[i] = byArray[i - (n - byArray.length)];
            }
            return byArray2;
        }
        return byArray;
    }
}

