/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    private static final Vector2f _tempVec2 = new Vector2f();
    private static final Vector3f _tempVec3 = new Vector3f();
    private static final ColorRGBA _tempColor = new ColorRGBA();
    public static long total = 0L;

    public static FloatBuffer createFloatBuffer(ColorRGBA ... colorRGBAArray) {
        if (colorRGBAArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4 * colorRGBAArray.length);
        for (int i = 0; i < colorRGBAArray.length; ++i) {
            if (colorRGBAArray[i] != null) {
                floatBuffer.put(colorRGBAArray[i].r).put(colorRGBAArray[i].g).put(colorRGBAArray[i].b).put(colorRGBAArray[i].a);
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createColorBuffer(int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4 * n);
        return floatBuffer;
    }

    public static void setInBuffer(ColorRGBA colorRGBA, FloatBuffer floatBuffer, int n) {
        floatBuffer.position(n * 4);
        floatBuffer.put(colorRGBA.r);
        floatBuffer.put(colorRGBA.g);
        floatBuffer.put(colorRGBA.b);
        floatBuffer.put(colorRGBA.a);
    }

    public static void populateFromBuffer(ColorRGBA colorRGBA, FloatBuffer floatBuffer, int n) {
        colorRGBA.r = floatBuffer.get(n * 4);
        colorRGBA.g = floatBuffer.get(n * 4 + 1);
        colorRGBA.b = floatBuffer.get(n * 4 + 2);
        colorRGBA.a = floatBuffer.get(n * 4 + 3);
    }

    public static ColorRGBA[] getColorArray(FloatBuffer floatBuffer) {
        floatBuffer.rewind();
        ColorRGBA[] colorRGBAArray = new ColorRGBA[floatBuffer.limit() >> 2];
        for (int i = 0; i < colorRGBAArray.length; ++i) {
            ColorRGBA colorRGBA;
            colorRGBAArray[i] = colorRGBA = new ColorRGBA(floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
        }
        return colorRGBAArray;
    }

    public static void copyInternalColor(FloatBuffer floatBuffer, int n, int n2) {
        BufferUtils.copyInternal(floatBuffer, n * 4, n2 * 4, 4);
    }

    public static boolean equals(ColorRGBA colorRGBA, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempColor, floatBuffer, n);
        return _tempColor.equals(colorRGBA);
    }

    public static FloatBuffer createFloatBuffer(Vector3f ... vector3fArray) {
        if (vector3fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(3 * vector3fArray.length);
        for (int i = 0; i < vector3fArray.length; ++i) {
            if (vector3fArray[i] != null) {
                floatBuffer.put(vector3fArray[i].x).put(vector3fArray[i].y).put(vector3fArray[i].z);
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createFloatBuffer(float ... fArray) {
        if (fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(fArray.length);
        floatBuffer.clear();
        floatBuffer.put(fArray);
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createVector3Buffer(int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(3 * n);
        return floatBuffer;
    }

    public static FloatBuffer createVector3Buffer(FloatBuffer floatBuffer, int n) {
        if (floatBuffer != null && floatBuffer.limit() == 3 * n) {
            floatBuffer.rewind();
            return floatBuffer;
        }
        return BufferUtils.createFloatBuffer(3 * n);
    }

    public static void setInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null) {
            return;
        }
        if (vector3f == null) {
            floatBuffer.put(n * 3, 0.0f);
            floatBuffer.put(n * 3 + 1, 0.0f);
            floatBuffer.put(n * 3 + 2, 0.0f);
        } else {
            floatBuffer.put(n * 3, vector3f.x);
            floatBuffer.put(n * 3 + 1, vector3f.y);
            floatBuffer.put(n * 3 + 2, vector3f.z);
        }
    }

    public static void populateFromBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        vector3f.x = floatBuffer.get(n * 3);
        vector3f.y = floatBuffer.get(n * 3 + 1);
        vector3f.z = floatBuffer.get(n * 3 + 2);
    }

    public static Vector3f[] getVector3Array(FloatBuffer floatBuffer) {
        floatBuffer.clear();
        Vector3f[] vector3fArray = new Vector3f[floatBuffer.limit() / 3];
        for (int i = 0; i < vector3fArray.length; ++i) {
            Vector3f vector3f;
            vector3fArray[i] = vector3f = new Vector3f(floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
        }
        return vector3fArray;
    }

    public static void copyInternalVector3(FloatBuffer floatBuffer, int n, int n2) {
        BufferUtils.copyInternal(floatBuffer, n * 3, n2 * 3, 3);
    }

    public static void normalizeVector3(FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec3, floatBuffer, n);
        _tempVec3.normalizeLocal();
        BufferUtils.setInBuffer(_tempVec3, floatBuffer, n);
    }

    public static void addInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec3, floatBuffer, n);
        _tempVec3.addLocal(vector3f);
        BufferUtils.setInBuffer(_tempVec3, floatBuffer, n);
    }

    public static void multInBuffer(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec3, floatBuffer, n);
        _tempVec3.multLocal(vector3f);
        BufferUtils.setInBuffer(_tempVec3, floatBuffer, n);
    }

    public static boolean equals(Vector3f vector3f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec3, floatBuffer, n);
        return _tempVec3.equals(vector3f);
    }

    public static FloatBuffer createFloatBuffer(Vector2f ... vector2fArray) {
        if (vector2fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(2 * vector2fArray.length);
        for (int i = 0; i < vector2fArray.length; ++i) {
            if (vector2fArray[i] != null) {
                floatBuffer.put(vector2fArray[i].x).put(vector2fArray[i].y);
                continue;
            }
            floatBuffer.put(0.0f).put(0.0f);
        }
        floatBuffer.flip();
        return floatBuffer;
    }

    public static FloatBuffer createVector2Buffer(int n) {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(2 * n);
        return floatBuffer;
    }

    public static FloatBuffer createVector2Buffer(FloatBuffer floatBuffer, int n) {
        if (floatBuffer != null && floatBuffer.limit() == 2 * n) {
            floatBuffer.rewind();
            return floatBuffer;
        }
        return BufferUtils.createFloatBuffer(2 * n);
    }

    public static void setInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        floatBuffer.put(n * 2, vector2f.x);
        floatBuffer.put(n * 2 + 1, vector2f.y);
    }

    public static void populateFromBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        vector2f.x = floatBuffer.get(n * 2);
        vector2f.y = floatBuffer.get(n * 2 + 1);
    }

    public static Vector2f[] getVector2Array(FloatBuffer floatBuffer) {
        floatBuffer.clear();
        Vector2f[] vector2fArray = new Vector2f[floatBuffer.limit() / 2];
        for (int i = 0; i < vector2fArray.length; ++i) {
            Vector2f vector2f;
            vector2fArray[i] = vector2f = new Vector2f(floatBuffer.get(), floatBuffer.get());
        }
        return vector2fArray;
    }

    public static void copyInternalVector2(FloatBuffer floatBuffer, int n, int n2) {
        BufferUtils.copyInternal(floatBuffer, n * 2, n2 * 2, 2);
    }

    public static void normalizeVector2(FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec2, floatBuffer, n);
        _tempVec2.normalizeLocal();
        BufferUtils.setInBuffer(_tempVec2, floatBuffer, n);
    }

    public static void addInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec2, floatBuffer, n);
        _tempVec2.addLocal(vector2f);
        BufferUtils.setInBuffer(_tempVec2, floatBuffer, n);
    }

    public static void multInBuffer(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec2, floatBuffer, n);
        _tempVec2.multLocal(vector2f);
        BufferUtils.setInBuffer(_tempVec2, floatBuffer, n);
    }

    public static boolean equals(Vector2f vector2f, FloatBuffer floatBuffer, int n) {
        BufferUtils.populateFromBuffer(_tempVec2, floatBuffer, n);
        return _tempVec2.equals(vector2f);
    }

    public static IntBuffer createIntBuffer(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer(nArray.length);
        intBuffer.clear();
        intBuffer.put(nArray);
        intBuffer.flip();
        return intBuffer;
    }

    public static int[] getIntArray(IntBuffer intBuffer) {
        intBuffer.clear();
        int[] nArray = new int[intBuffer.limit()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = intBuffer.get();
        }
        return nArray;
    }

    public static DoubleBuffer createDoubleBuffer(int n) {
        DoubleBuffer doubleBuffer = ByteBuffer.allocateDirect(8 * n).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        doubleBuffer.clear();
        return doubleBuffer;
    }

    public static DoubleBuffer createDoubleBuffer(DoubleBuffer doubleBuffer, int n) {
        if (doubleBuffer != null && doubleBuffer.limit() == n) {
            doubleBuffer.rewind();
            return doubleBuffer;
        }
        doubleBuffer = BufferUtils.createDoubleBuffer(n);
        return doubleBuffer;
    }

    public static DoubleBuffer clone(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            return null;
        }
        doubleBuffer.rewind();
        DoubleBuffer doubleBuffer2 = BufferUtils.createDoubleBuffer(doubleBuffer.limit());
        doubleBuffer2.put(doubleBuffer);
        return doubleBuffer2;
    }

    public static FloatBuffer createFloatBuffer(int n) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.clear();
        return floatBuffer;
    }

    public static void copyInternal(FloatBuffer floatBuffer, int n, int n2, int n3) {
        float[] fArray = new float[n3];
        floatBuffer.position(n);
        floatBuffer.get(fArray);
        floatBuffer.position(n2);
        floatBuffer.put(fArray);
    }

    public static FloatBuffer clone(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return null;
        }
        floatBuffer.rewind();
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(floatBuffer.limit());
        floatBuffer2.put(floatBuffer);
        return floatBuffer2;
    }

    public static IntBuffer createIntBuffer(int n) {
        IntBuffer intBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asIntBuffer();
        intBuffer.clear();
        return intBuffer;
    }

    public static IntBuffer createIntBuffer(IntBuffer intBuffer, int n) {
        if (intBuffer != null && intBuffer.limit() == n) {
            intBuffer.rewind();
            return intBuffer;
        }
        intBuffer = BufferUtils.createIntBuffer(n);
        return intBuffer;
    }

    public static IntBuffer clone(IntBuffer intBuffer) {
        if (intBuffer == null) {
            return null;
        }
        intBuffer.rewind();
        IntBuffer intBuffer2 = BufferUtils.createIntBuffer(intBuffer.limit());
        intBuffer2.put(intBuffer);
        return intBuffer2;
    }

    public static ByteBuffer createByteBuffer(int n) {
        total += (long)n;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        byteBuffer.clear();
        return byteBuffer;
    }

    public static ByteBuffer createByteBuffer(ByteBuffer byteBuffer, int n) {
        if (byteBuffer != null && byteBuffer.limit() == n) {
            byteBuffer.rewind();
            return byteBuffer;
        }
        byteBuffer = BufferUtils.createByteBuffer(n);
        return byteBuffer;
    }

    public static ByteBuffer clone(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(byteBuffer.limit());
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public static ShortBuffer createShortBuffer(int n) {
        ShortBuffer shortBuffer = ByteBuffer.allocateDirect(2 * n).order(ByteOrder.nativeOrder()).asShortBuffer();
        shortBuffer.clear();
        return shortBuffer;
    }

    public static ShortBuffer createShortBuffer(ShortBuffer shortBuffer, int n) {
        if (shortBuffer != null && shortBuffer.limit() == n) {
            shortBuffer.rewind();
            return shortBuffer;
        }
        shortBuffer = BufferUtils.createShortBuffer(n);
        return shortBuffer;
    }

    public static ShortBuffer clone(ShortBuffer shortBuffer) {
        if (shortBuffer == null) {
            return null;
        }
        shortBuffer.rewind();
        ShortBuffer shortBuffer2 = BufferUtils.createShortBuffer(shortBuffer.limit());
        shortBuffer2.put(shortBuffer);
        return shortBuffer2;
    }

    public static FloatBuffer ensureLargeEnough(FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null || floatBuffer.remaining() < n) {
            int n2 = floatBuffer != null ? floatBuffer.position() : 0;
            FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(n2 + n);
            if (floatBuffer != null) {
                floatBuffer.rewind();
                floatBuffer2.put(floatBuffer);
                floatBuffer2.position(n2);
            }
            floatBuffer = floatBuffer2;
        }
        return floatBuffer;
    }
}

