/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.SharedBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import com.jme.util.geom.VertKey;
import com.jme.util.geom.VertMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class GeometryTool {
    private static final Logger logger = Logger.getLogger(GeometryTool.class.getName());
    public static final int MV_SAME_NORMALS = 1;
    public static final int MV_SAME_TEXS = 2;
    public static final int MV_SAME_COLORS = 4;

    public static VertMap[] minimizeVerts(TriMesh triMesh, int n) {
        VertMap[] vertMapArray = new VertMap[triMesh.getBatchCount()];
        int n2 = triMesh.getBatchCount();
        while (--n2 >= 0) {
            vertMapArray[n2] = GeometryTool.minimizeVerts(triMesh.getBatch(n2), n);
        }
        return vertMapArray;
    }

    public static VertMap minimizeVerts(TriangleBatch triangleBatch, int n) {
        if (triangleBatch instanceof SharedBatch) {
            triangleBatch = ((SharedBatch)triangleBatch).getTarget();
        }
        int n2 = -1;
        int n3 = triangleBatch.getVertexCount();
        int n4 = 0;
        VertMap vertMap = new VertMap(triangleBatch);
        while (n2 != n4) {
            int n5;
            int n6;
            Object object;
            n2 = triangleBatch.getVertexCount();
            Vector3f[] vector3fArray = BufferUtils.getVector3Array(triangleBatch.getVertexBuffer());
            Vector3f[] vector3fArray2 = null;
            if (triangleBatch.getNormalBuffer() != null) {
                vector3fArray2 = BufferUtils.getVector3Array(triangleBatch.getNormalBuffer());
            }
            ColorRGBA[] colorRGBAArray = null;
            if (triangleBatch.getColorBuffer() != null) {
                colorRGBAArray = BufferUtils.getColorArray(triangleBatch.getColorBuffer());
            }
            Vector2f[][] vector2fArray = new Vector2f[triangleBatch.getNumberOfUnits()][];
            for (int i = 0; i < vector2fArray.length; ++i) {
                if (triangleBatch.getTextureBuffer(i) == null) continue;
                vector2fArray[i] = BufferUtils.getVector2Array(triangleBatch.getTextureBuffer(i));
            }
            int[] nArray = BufferUtils.getIntArray(triangleBatch.getIndexBuffer());
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            int n7 = 0;
            int n8 = vector3fArray.length;
            for (int i = 0; i < n8; ++i) {
                object = new VertKey(vector3fArray[i], vector3fArray2 != null ? vector3fArray2[i] : null, colorRGBAArray != null ? colorRGBAArray[i] : null, GeometryTool.getTexs(vector2fArray, i), n);
                if (hashMap.containsKey(object)) {
                    int n9 = (Integer)hashMap.get(object);
                    vertMap.replaceIndex(i, n9);
                    GeometryTool.findReplace(i, n9, nArray);
                    vector3fArray[i] = null;
                    if (vector3fArray2 != null) {
                        vector3fArray2[n9].addLocal(vector3fArray2[i].normalizeLocal());
                    }
                    if (colorRGBAArray == null) continue;
                    colorRGBAArray[i] = null;
                    continue;
                }
                hashMap.put(object, i);
                ++n7;
            }
            ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>(n7);
            ArrayList<Vector3f> arrayList2 = new ArrayList<Vector3f>(n7);
            object = new ArrayList(n7);
            ArrayList[] arrayListArray = new ArrayList[triangleBatch.getNumberOfUnits()];
            for (n6 = 0; n6 < arrayListArray.length; ++n6) {
                if (triangleBatch.getTextureBuffer(n6) == null) continue;
                arrayListArray[n6] = new ArrayList(n7);
            }
            n6 = 0;
            int n10 = vector3fArray.length;
            for (n5 = 0; n5 < n10; ++n5) {
                if (vector3fArray[n5] == null) {
                    GeometryTool.decrementIndices(n5 - n6, nArray);
                    vertMap.decrementIndices(n5 - n6);
                    ++n6;
                    continue;
                }
                arrayList.add(vector3fArray[n5]);
                if (vector3fArray2 != null) {
                    arrayList2.add(vector3fArray2[n5].normalizeLocal());
                }
                if (colorRGBAArray != null) {
                    ((ArrayList)object).add(colorRGBAArray[n5]);
                }
                for (int i = 0; i < arrayListArray.length; ++i) {
                    if (triangleBatch.getTextureBuffer(i) == null) continue;
                    arrayListArray[i].add(vector2fArray[i][n5]);
                }
            }
            triangleBatch.setVertexBuffer(BufferUtils.createFloatBuffer(arrayList.toArray(new Vector3f[0])));
            if (vector3fArray2 != null) {
                triangleBatch.setNormalBuffer(BufferUtils.createFloatBuffer(arrayList2.toArray(new Vector3f[0])));
            }
            if (colorRGBAArray != null) {
                triangleBatch.setColorBuffer(BufferUtils.createFloatBuffer(((ArrayList)object).toArray(new ColorRGBA[0])));
            }
            for (n5 = 0; n5 < arrayListArray.length; ++n5) {
                if (triangleBatch.getTextureBuffer(n5) == null) continue;
                triangleBatch.setTextureBuffer(BufferUtils.createFloatBuffer(arrayListArray[n5].toArray(new Vector2f[0])), n5);
            }
            triangleBatch.getIndexBuffer().clear();
            triangleBatch.getIndexBuffer().put(nArray);
            n4 = triangleBatch.getVertexCount();
        }
        logger.info("batch: " + triangleBatch + " old: " + n3 + " new: " + n4);
        return vertMap;
    }

    private static Vector2f[] getTexs(Vector2f[][] vector2fArray, int n) {
        Vector2f[] vector2fArray2 = new Vector2f[vector2fArray.length];
        for (int i = 0; i < vector2fArray.length; ++i) {
            if (vector2fArray[i] == null) continue;
            vector2fArray2[i] = vector2fArray[i][n];
        }
        return vector2fArray2;
    }

    private static void findReplace(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        while (--n3 >= 0) {
            if (nArray[n3] != n) continue;
            nArray[n3] = n2;
        }
    }

    private static void decrementIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] < n) continue;
            int n3 = n2;
            nArray[n3] = nArray[n3] - 1;
        }
    }
}

