/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;

public class VertKey {
    private Vector3f vert;
    private Vector3f norm;
    private ColorRGBA color;
    private Vector2f[] texs;
    private int options;

    public VertKey(Vector3f vector3f, Vector3f vector3f2, ColorRGBA colorRGBA, Vector2f[] vector2fArray, int n) {
        this.vert = vector3f;
        if ((n & 1) != 0) {
            this.norm = vector3f2;
        }
        if ((n & 4) != 0) {
            this.color = colorRGBA;
        }
        if ((n & 2) != 0) {
            this.texs = vector2fArray;
        }
        this.options = n;
    }

    public int hashCode() {
        int n = this.vert.hashCode();
        if ((this.options & 1) != 0 && this.norm != null) {
            n += 37 * n + Float.floatToIntBits(this.norm.x);
            n += 37 * n + Float.floatToIntBits(this.norm.y);
            n += 37 * n + Float.floatToIntBits(this.norm.z);
        }
        if ((this.options & 4) != 0 && this.color != null) {
            n += 37 * n + Float.floatToIntBits(this.color.r);
            n += 37 * n + Float.floatToIntBits(this.color.g);
            n += 37 * n + Float.floatToIntBits(this.color.b);
            n += 37 * n + Float.floatToIntBits(this.color.a);
        }
        if ((this.options & 2) != 0 && this.texs != null) {
            for (int i = 0; i < this.texs.length; ++i) {
                if (this.texs[i] == null) continue;
                n += 37 * n + Float.floatToIntBits(this.texs[i].x);
                n += 37 * n + Float.floatToIntBits(this.texs[i].y);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VertKey)) {
            return false;
        }
        VertKey vertKey = (VertKey)object;
        if (vertKey.options != this.options) {
            return false;
        }
        if (!vertKey.vert.equals(this.vert)) {
            return false;
        }
        if ((this.options & 1) != 0 && (this.norm != null ? !this.norm.equals(vertKey.norm) : vertKey.norm != null)) {
            return false;
        }
        if ((this.options & 4) != 0 && (this.color != null ? !this.color.equals(vertKey.color) : vertKey.color != null)) {
            return false;
        }
        if ((this.options & 2) != 0) {
            if (this.texs != null) {
                if (vertKey.texs == null || vertKey.texs.length != this.texs.length) {
                    return false;
                }
                for (int i = 0; i < this.texs.length; ++i) {
                    if (!(this.texs[i] != null ? !this.texs[i].equals(vertKey.texs[i]) : vertKey.texs[i] != null)) continue;
                    return false;
                }
            } else if (vertKey.texs != null) {
                return false;
            }
        }
        return true;
    }
}

