/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.motiontools.utils;

import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;

public class MotionToolsUtils {
    public static void setEmissiveState(Spatial spatial, int n, int n2, int n3) {
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setEmissive(new ColorRGBA((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f));
        spatial.setRenderState((RenderState)materialState);
    }

    public static Light createLight(Vector3f vector3f) {
        PointLight pointLight = new PointLight();
        pointLight.setLocation(vector3f);
        pointLight.setDiffuse(ColorRGBA.white);
        pointLight.setEnabled(true);
        return pointLight;
    }

    public static Quaternion getRotate(float f, float f2, float f3) {
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles((float)Math.PI / 180 * f, (float)Math.PI / 180 * f2, (float)Math.PI / 180 * f3);
        return quaternion;
    }

    public static Quaternion getRotateY(float f) {
        f = MotionToolsUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 1.0f, 0.0f));
        return quaternion;
    }

    public static Quaternion getRotateX(float f) {
        f = MotionToolsUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(1.0f, 0.0f, 0.0f));
        return quaternion;
    }

    public static Quaternion getRotateZ(float f) {
        f = MotionToolsUtils.toValidValue(f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(0.0f, 0.0f, 1.0f));
        return quaternion;
    }

    private static float toValidValue(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static void setDiffuseState(Spatial spatial, int n, int n2, int n3) {
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setDiffuse(new ColorRGBA((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f));
        spatial.setRenderState((RenderState)materialState);
    }
}

