/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.effect;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.effect.VideoEffect;

public class FillImageEffect
extends VideoEffect {
    protected BufferedImage image;
    protected double fullPaintTime = 0.1;

    public FillImageEffect() {
    }

    @Override
    public String toString() {
        String out = "FillImageEffect:image=" + this.image + " " + super.toString();
        return out;
    }

    public FillImageEffect(BufferedImage image) {
        this.image = image;
    }

    public float getFrameTransparent(double t, double maxtime) {
        double time = Math.abs(t);
        if (time < this.fullPaintTime) {
            return 0.97f;
        }
        return 1.0f - (float)(time / maxtime);
    }

    @Override
    public void effectAfter(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        if (this.image == null) {
            log.warn((Object)"img is null");
            return;
        }
        log.warn((Object)("after:" + frame));
        g2.setComposite(AlphaComposite.getInstance(3, this.getFrameTransparent(time, this.getAfterTime())));
        g2.drawImage(this.image, 0, 0, baseImage.getWidth(), baseImage.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
    }

    @Override
    public void effectAll(DougaPreference preference, BufferedImage baseImage, int frame) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        if (this.image == null) {
            log.warn((Object)"img is null");
            return;
        }
        g2.drawImage(this.image, 0, 0, baseImage.getWidth(), baseImage.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
    }

    @Override
    public void effectBefore(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        if (this.image == null) {
            log.warn((Object)"img is null");
            return;
        }
        g2.setComposite(AlphaComposite.getInstance(3, this.getFrameTransparent(time, this.getBeforeTime())));
        log.warn((Object)("before:" + frame));
        g2.drawImage(this.image, 0, 0, baseImage.getWidth(), baseImage.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
    }

    public double getFullPaintTime() {
        return this.fullPaintTime;
    }

    public void setFullPaintTime(double fullPaintTime) {
        this.fullPaintTime = fullPaintTime;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public void effectKeyFrame(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        if (this.image == null) {
            log.warn((Object)"img is null");
            return;
        }
        g2.drawImage(this.image, 0, 0, baseImage.getWidth(), baseImage.getHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
    }
}

