/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColorItem
extends AbstractItem {
    public static Log log = LogFactory.getLog(ColorItem.class);
    protected int color;

    public ColorItem(int color, float transparent) {
        this.color = color;
        this.transparent = transparent;
    }

    @Override
    public String toString() {
        return "ColorItem:" + super.toString() + " color=" + this.color;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean written = false;
        if (this.duration == -1.0) {
            written = true;
        }
        double frameTime = this.getFrameTime(frame, preference.getFps());
        if (!written) {
            written = this.isInFrame(preference, frame);
        }
        if (written) {
            Rectangle drawRect = this.getDrawRect(preference);
            BufferedImage img = new BufferedImage(preference.getWidth(), preference.getHeight(), 1);
            Graphics2D bg2 = (Graphics2D)img.getGraphics();
            bg2.setColor(new Color(this.color));
            bg2.fillRect(0, 0, preference.getWidth(), preference.getHeight());
            log.info((Object)(String.valueOf(img.getWidth()) + "x" + img.getHeight()));
            Graphics2D g2 = (Graphics2D)baseImage.getImage().getGraphics();
            float tp = this.getFrameTransparent(preference, frameTime);
            g2.setComposite(AlphaComposite.getInstance(3, tp));
            int mx = this.getMovedX(preference, frameTime);
            int my = this.getMovedY(preference, frameTime);
            g2.drawImage(img, drawRect.x + mx, drawRect.y + my, drawRect.x + drawRect.width + mx, drawRect.y + drawRect.height + my, 0, 0, img.getWidth(), img.getHeight(), null);
        }
        return written;
    }

    public Rectangle getDrawRect(DougaPreference preference) {
        return new Rectangle(0, 0, preference.getWidth(), preference.getHeight());
    }
}

