/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DrawingItem
extends AbstractItem {
    public static Log log = LogFactory.getLog(DrawingItem.class);
    protected int color = 0xFF0000;
    protected boolean fill = false;
    public static final int TYPE_RECT = 0;
    public static final int TYPE_OVAL = 1;
    public static final int TYPE_LINE = 2;
    protected int drawType = 0;
    protected int lineSize = 1;
    protected boolean antialiase = true;

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public int getDrawType() {
        return this.drawType;
    }

    public void setDrawType(int drawType) {
        this.drawType = drawType;
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
    }

    @Override
    public String toString() {
        return "DrawingItem:" + super.toString() + " color=" + this.color;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean written = false;
        if (this.duration == -1.0) {
            written = true;
        }
        double frameTime = this.getFrameTime(frame, preference.getFps());
        if (!written) {
            written = this.isInFrame(preference, frame);
        }
        if (written && this.getWidth() > 0 && this.getHeight() > 0) {
            Rectangle drawRect = this.getDrawRect(preference);
            Graphics2D g2 = (Graphics2D)baseImage.getImage().getGraphics();
            float tp = this.getFrameTransparent(preference, frameTime);
            g2.setComposite(AlphaComposite.getInstance(3, tp));
            int mx = this.getMovedX(preference, frameTime);
            int my = this.getMovedY(preference, frameTime);
            int drawW = drawRect.width + this.getMovedWidth(preference, frameTime);
            int drawH = drawRect.height + this.getMovedHeight(preference, frameTime);
            g2.setStroke(new BasicStroke(this.lineSize));
            g2.setColor(new Color(this.color));
            if (this.antialiase) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            if (drawW > 0 && drawH > 0) {
                if (this.fill) {
                    if (this.drawType == 0) {
                        g2.fillRect(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                    } else if (this.drawType == 2) {
                        g2.drawLine(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                    } else {
                        g2.fillOval(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                    }
                } else if (this.drawType == 0) {
                    g2.drawRect(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                } else if (this.drawType == 2) {
                    g2.drawLine(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                } else {
                    g2.drawOval(drawRect.x + mx, drawRect.y + my, drawW, drawH);
                }
            }
        }
        return written;
    }

    public Rectangle getDrawRect(DougaPreference preference) {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public boolean isAntialiase() {
        return this.antialiase;
    }

    public void setAntialiase(boolean antialiase) {
        this.antialiase = antialiase;
    }
}

