/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.wizards.importimg;

import java.io.File;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageInputPage
extends WizardPage {
    private CCombo size;
    private CCombo fps;
    private FileDirChoicer inputVideo;
    private CCombo duration;
    private CCombo wait;
    private CCombo fadein;
    private CCombo fadeout;
    private CCombo align;
    private CCombo valign;
    private CCombo loop;
    private Text timeLabelText;

    protected ImageInputPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("importimg.input_title"));
        this.setDescription(Messages.getString("importimg.input_description"));
        this.setPageComplete(false);
    }

    public String getSize() {
        return this.size.getText();
    }

    public String getFps() {
        return this.fps.getText();
    }

    public String getPath() {
        return this.inputVideo.getAbsoluteFilePath();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.setControl((Control)base);
        this.inputVideo = new FileDirChoicer(base, 0, 0, Messages.getString("importimg.input"));
        this.inputVideo.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputVideo.setFilterExtensions(ParserUtils.toMixFilterExtensions(ParserUtils.videos));
        this.inputVideo.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                ImageInputPage.this.setPageComplete(false);
                String ffmpeg = FFMpegUI.getFFmpegOrPureFFMpeg();
                if (ffmpeg != null) {
                    FLVInfomation info = new FFMpegFLVParser(ffmpeg).parseFile(new File(event.getFilePath()));
                    String value = String.valueOf(info.getVideoWidth()) + "x" + info.getVideoHeight();
                    ImageInputPage.this.size.setText(value);
                    ImageInputPage.this.addSizeValue(value);
                    ImageInputPage.this.fps.setText("" + info.getVideoRate());
                }
                ImageInputPage.this.setPageComplete(true);
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                ImageInputPage.this.size.setText("");
                ImageInputPage.this.fps.setText("");
            }
        });
        Composite labels = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        Label label = new Label(labels, 0);
        label.setText(Messages.getString("importimg.timelabel"));
        this.timeLabelText = new Text(labels, 8);
        this.timeLabelText.setText("53");
        this.timeLabelText.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        Composite fields = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        this.duration = this.createCCombo(fields, Messages.getString("importimg.duration"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10", "30", "0.0334"}, 0);
        this.wait = this.createCCombo(fields, Messages.getString("importimg.wait"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.fadein = this.createCCombo(fields, Messages.getString("importimg.fadein"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.fadeout = this.createCCombo(fields, Messages.getString("importimg.fadeout"), new String[]{"", "0.1", "0.3", "1", "3", "5", "10"}, 0);
        this.size = this.createCCombo(fields, Messages.getString("exportimg.size"), new String[]{"", "160x120", "320x240", "640x480", "720x480"}, 0);
        this.fps = this.createCCombo(fields, Messages.getString("exportimg.fps"), new String[]{"", "1", "5", "10", "12", "14.895", "15", "24", "25", "29.97", "30"}, 0);
        this.align = this.createCCombo(fields, Messages.getString("importimg.align"), new String[]{"", "left", "center", "right"}, 8);
        this.valign = this.createCCombo(fields, Messages.getString("importimg.valign"), new String[]{"", "top", "middle", "bottom"}, 8);
        this.loop = this.createCCombo(fields, Messages.getString("importimg.loop"), new String[]{"", "1", "3", "5", "10", "99"}, 0);
    }

    private CCombo createCCombo(Composite parent, String label, String[] values, int style) {
        Composite p2 = WidgetBuilder.createTwoGridLayoutComposite((Composite)parent, (int)0);
        WidgetBuilder.createLabel((Composite)p2, (String)label);
        CCombo combo = new CCombo(p2, style);
        combo.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
        return combo;
    }

    private void addSizeValue(String value) {
        String[] item = this.size.getItems();
        boolean match = false;
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(value)) {
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            this.size.add(value);
        }
    }
}

