/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaBoolean
implements SchemaTypeNumber {
    protected boolean value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaBoolean() {
        this.setEmpty();
    }

    public SchemaBoolean(SchemaBoolean schemaBoolean) {
        this.value = schemaBoolean.value;
        this.isempty = schemaBoolean.isempty;
        this.isnull = schemaBoolean.isnull;
    }

    public SchemaBoolean(boolean bl) {
        this.setValue(bl);
    }

    public SchemaBoolean(String string) {
        this.parse(string);
    }

    public SchemaBoolean(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaBoolean(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean bl) {
        this.isnull = false;
        this.isempty = false;
        this.value = bl;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            this.setValue(new SchemaString(string2).booleanValue());
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else {
            this.parse(((Object)schemaType).toString());
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = false;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = false;
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaBoolean)) {
            return false;
        }
        return this.value == ((SchemaBoolean)object).value;
    }

    public Object clone() {
        return new SchemaBoolean(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return this.value ? "true" : "false";
    }

    public int length() {
        return 1;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaBoolean)object);
    }

    public int compareTo(SchemaBoolean schemaBoolean) {
        if (this.value == schemaBoolean.value) {
            return 0;
        }
        if (!this.value) {
            return -1;
        }
        return 1;
    }

    public int numericType() {
        return 1;
    }

    public void setValue(int n) {
        this.isnull = false;
        this.isempty = false;
        this.value = n != 0;
    }

    public void setValue(long l) {
        this.isnull = false;
        this.isempty = false;
        this.value = l != 0L;
    }

    public void setValue(BigInteger bigInteger) {
        this.isnull = false;
        this.isempty = false;
        this.value = bigInteger.compareTo(BigInteger.valueOf(0L)) != 0;
    }

    public void setValue(float f) {
        this.isnull = false;
        this.isempty = false;
        this.value = f != 0.0f;
    }

    public void setValue(double d) {
        this.isnull = false;
        this.isempty = false;
        this.value = d != 0.0;
    }

    public void setValue(BigDecimal bigDecimal) {
        this.isnull = false;
        this.isempty = false;
        this.value = bigDecimal.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    public int intValue() {
        if (this.value) {
            return 1;
        }
        return 0;
    }

    public long longValue() {
        if (this.value) {
            return 1L;
        }
        return 0L;
    }

    public BigInteger bigIntegerValue() {
        if (this.value) {
            return BigInteger.valueOf(1L);
        }
        return BigInteger.valueOf(0L);
    }

    public float floatValue() {
        if (this.value) {
            return 1.0f;
        }
        return 0.0f;
    }

    public double doubleValue() {
        if (this.value) {
            return 1.0;
        }
        return 0.0;
    }

    public BigDecimal bigDecimalValue() {
        if (this.value) {
            return BigDecimal.valueOf(1L);
        }
        return BigDecimal.valueOf(0L);
    }
}

