/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaBoolean;
import com.jmex.xml.types.SchemaByte;
import com.jmex.xml.types.SchemaDate;
import com.jmex.xml.types.SchemaDateTime;
import com.jmex.xml.types.SchemaDecimal;
import com.jmex.xml.types.SchemaDuration;
import com.jmex.xml.types.SchemaInt;
import com.jmex.xml.types.SchemaInteger;
import com.jmex.xml.types.SchemaString;
import com.jmex.xml.types.SchemaTime;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.StringParseException;
import java.math.BigDecimal;

public class SchemaTypeFactory {
    public static SchemaType createInstanceByString(String string) {
        if (string == null) {
            SchemaString schemaString = new SchemaString();
            schemaString.setNull();
            return schemaString;
        }
        if (string.length() == 0) {
            return new SchemaString();
        }
        if (string.compareToIgnoreCase("false") == 0) {
            return new SchemaBoolean(false);
        }
        if (string.compareToIgnoreCase("true") == 0) {
            return new SchemaBoolean(true);
        }
        try {
            SchemaDateTime schemaDateTime = new SchemaDateTime(string);
            return schemaDateTime;
        }
        catch (StringParseException stringParseException) {
            try {
                SchemaDuration schemaDuration = new SchemaDuration(string);
                return schemaDuration;
            }
            catch (StringParseException stringParseException2) {
                try {
                    SchemaDate schemaDate = new SchemaDate(string);
                    return schemaDate;
                }
                catch (StringParseException stringParseException3) {
                    try {
                        SchemaTime schemaTime = new SchemaTime(string);
                        return schemaTime;
                    }
                    catch (StringParseException stringParseException4) {
                        try {
                            BigDecimal bigDecimal = new BigDecimal(string);
                            if (bigDecimal.scale() <= 0) {
                                if (bigDecimal.compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 && bigDecimal.compareTo(new BigDecimal(Integer.MIN_VALUE)) >= 0) {
                                    return new SchemaInt(bigDecimal.intValue());
                                }
                                return new SchemaInteger(bigDecimal.toBigInteger());
                            }
                            return new SchemaDecimal(bigDecimal);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return new SchemaString(string);
                        }
                    }
                }
            }
        }
    }

    public static SchemaType createInstanceByObject(Object object) {
        if (object instanceof Boolean) {
            return new SchemaBoolean((Boolean)object);
        }
        if (object instanceof Byte) {
            return new SchemaByte(((Byte)object).byteValue());
        }
        return new SchemaString(object.toString());
    }
}

