/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.GenericParametersEditorDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersTableViewer;
import jp.sourceforge.akjrcp.ui.Messages;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class GenericParametersEditor
extends FieldEditor {
    public static Log log = LogFactory.getLog(GenericParametersEditor.class);
    private Button upButton;
    private Button downButton;
    private Button topButton;
    private Button bottomButton;
    private Button newButton;
    private Button editButton;
    private Button deleteButton;
    private Button copyButton;
    private Button exportButton;
    private Button exportAllButton;
    private Button importButton;
    private Button deleteAll;
    private GenericParametersTableViewer table;
    private Label label;
    private Composite menus;

    public GenericParametersEditor(String key, String description, Composite parent) {
        super(key, description, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        log.info((Object)("adjust:" + numColumns));
    }

    private Table getTable(Composite parent) {
        if (this.table == null) {
            this.table = new GenericParametersTableViewer(parent);
        }
        return this.table.getTable();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabel(parent);
        GridData ld = new GridData();
        ld.horizontalSpan = numColumns;
        label.setLayoutData((Object)ld);
        Composite fill = new Composite(parent, 0);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = numColumns;
        fill.setLayoutData((Object)gd1);
        fill.setLayout((Layout)new GridLayout(2, false));
        FixComposite composite = new FixComposite(fill, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData(gd);
        this.getTable(composite);
        Composite menus = this.getMenus(fill);
        menus.setLayoutData((Object)new GridData());
    }

    private Label getLabel(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 0);
            this.label.setText(this.getLabelText());
        }
        return this.label;
    }

    private Composite getMenus(Composite parent) {
        if (this.menus == null) {
            this.menus = new Composite(parent, 0);
            this.menus.setLayout((Layout)new GridLayout());
            this.newButton = this.createButton(this.menus, Messages.getString("genericparameters.new"));
            this.editButton = this.createButton(this.menus, Messages.getString("genericparameters.edit"));
            this.copyButton = this.createButton(this.menus, Messages.getString("genericparameters.copy"));
            this.deleteButton = this.createButton(this.menus, Messages.getString("genericparameters.delete"));
            this.topButton = this.createButton(this.menus, Messages.getString("genericparameters.top"));
            this.upButton = this.createButton(this.menus, Messages.getString("genericparameters.up"));
            this.downButton = this.createButton(this.menus, Messages.getString("genericparameters.down"));
            this.bottomButton = this.createButton(this.menus, Messages.getString("genericparameters.bottom"));
            this.importButton = this.createButton(this.menus, Messages.getString("genericparameters.import"));
            this.exportButton = this.createButton(this.menus, Messages.getString("genericparameters.export"));
            this.exportAllButton = this.createButton(this.menus, Messages.getString("genericparameters.export_all"));
            this.deleteAll = this.createButton(this.menus, Messages.getString("genericparameters.delete_all"));
        }
        return this.menus;
    }

    public Button createButton(Composite p, String label) {
        Button bt = new Button(p, 0);
        bt.setText(label);
        bt.addSelectionListener((SelectionListener)new ButtonSelect());
        bt.setLayoutData((Object)new GridData());
        return bt;
    }

    protected void doLoad() {
        GenericParameters[] settings = GenericParametersTableViewer.toGenericParameters(this.getPreferenceStore().getString(this.getPreferenceName()));
        int i = 0;
        while (i < settings.length) {
            this.table.getGenericParameters().add(settings[i]);
            ++i;
        }
        this.table.refresh();
    }

    protected void doLoadDefault() {
        this.table.getGenericParameters().removeAll(this.table.getGenericParameters());
        this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        GenericParameters[] settings = GenericParametersTableViewer.toGenericParameters(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
        int i = 0;
        while (i < settings.length) {
            this.table.getGenericParameters().add(settings[i]);
            ++i;
        }
        this.table.refresh();
    }

    private void saveStore() {
        System.out.println("save store");
        this.setPresentsDefaultValue(false);
        GenericParameters[] infos = this.table.getGenericParameters().toArray(new GenericParameters[0]);
        String oldValue = this.getPreferenceStore().getString(this.getPreferenceName());
        String newValue = GenericParametersEditor.toStoreString(infos);
        if (!oldValue.equals(newValue)) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
        }
    }

    public static String toStoreString(GenericParameters[] settings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < settings.length) {
            buffer.append(String.valueOf(GenericParametersTableViewer.toStoreString(settings[i])) + "\n");
            ++i;
        }
        return buffer.toString();
    }

    protected void doStore() {
        this.saveStore();
    }

    public int getNumberOfControls() {
        return 2;
    }

    public class FixComposite
    extends Composite {
        public FixComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(480, 300);
        }
    }

    public class ButtonSelect
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            int index = GenericParametersEditor.this.table.getTable().getSelectionIndex();
            if (e.widget == GenericParametersEditor.this.topButton) {
                GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                GenericParametersEditor.this.table.getGenericParameters().remove(setting);
                GenericParametersEditor.this.table.getGenericParameters().add(0, setting);
                GenericParametersEditor.this.table.refresh();
            } else if (e.widget == GenericParametersEditor.this.upButton) {
                GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                GenericParametersEditor.this.table.getGenericParameters().remove(setting);
                GenericParametersEditor.this.table.getGenericParameters().add(Math.max(0, index - 1), setting);
                GenericParametersEditor.this.table.refresh();
            } else if (e.widget == GenericParametersEditor.this.downButton) {
                GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                GenericParametersEditor.this.table.getGenericParameters().remove(setting);
                GenericParametersEditor.this.table.getGenericParameters().add(Math.min(GenericParametersEditor.this.table.getGenericParameters().size(), index + 1), setting);
                GenericParametersEditor.this.table.refresh();
            } else if (e.widget == GenericParametersEditor.this.bottomButton) {
                GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                GenericParametersEditor.this.table.getGenericParameters().remove(setting);
                GenericParametersEditor.this.table.getGenericParameters().add(GenericParametersEditor.this.table.getGenericParameters().size(), setting);
                GenericParametersEditor.this.table.refresh();
            } else if (e.widget == GenericParametersEditor.this.newButton) {
                GenericParametersEditorDialog dialog = new GenericParametersEditorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                int result = dialog.open();
                if (result == 0) {
                    GenericParametersEditor.this.table.refresh();
                    GenericParameters newed = GenericParameters.csvToParameters(dialog.getCommand());
                    newed.setName(dialog.getName());
                    newed.setComment(dialog.getComment());
                    GenericParametersEditor.this.table.getGenericParameters().add(GenericParametersEditor.this.table.getGenericParameters().size(), newed);
                    GenericParametersEditor.this.table.refresh();
                } else {
                    log.info((Object)result);
                }
            } else if (e.widget == GenericParametersEditor.this.editButton) {
                if (index >= 0) {
                    GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                    String command = GenericParameters.removeSystemParam(GenericParameters.parametersToCsv(setting));
                    log.info((Object)("command:" + command));
                    GenericParametersEditorDialog dialog = new GenericParametersEditorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.setName(setting.getName());
                    dialog.setComment(setting.getComment());
                    dialog.setCommand(command);
                    int result = dialog.open();
                    if (result == 0) {
                        GenericParametersEditor.this.table.refresh();
                        setting.setName(dialog.getName());
                        setting.setComment(dialog.getComment());
                        GenericParameters edited = GenericParameters.csvToParameters(dialog.getCommand());
                        setting.setParameters(edited.getParameters());
                        GenericParametersEditor.this.table.refresh();
                    } else {
                        log.info((Object)result);
                    }
                }
            } else if (e.widget == GenericParametersEditor.this.copyButton) {
                if (index >= 0) {
                    GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                    GenericParameters copied = GenericParameters.csvToParameters(GenericParameters.parametersToCsv(setting));
                    GenericParametersEditor.this.table.getGenericParameters().add(GenericParametersEditor.this.table.getGenericParameters().size(), copied);
                    GenericParametersEditor.this.table.refresh();
                }
            } else if (e.widget == GenericParametersEditor.this.deleteButton) {
                if (index >= 0) {
                    GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                    GenericParametersEditor.this.table.getGenericParameters().remove(setting);
                    GenericParametersEditor.this.table.refresh();
                }
            } else if (e.widget == GenericParametersEditor.this.importButton) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.csv"});
                String path = dialog.open();
                if (path != null) {
                    try {
                        String text = FileUtils.readFileToString((File)new File(path));
                        GenericParameters[] settings = GenericParametersTableViewer.toGenericParameters(text);
                        int i = 0;
                        while (i < settings.length) {
                            GenericParametersEditor.this.table.getGenericParameters().add(settings[i]);
                            ++i;
                        }
                        GenericParametersEditor.this.table.refresh();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (e.widget == GenericParametersEditor.this.exportButton) {
                if (index >= 0) {
                    GenericParameters setting = (GenericParameters)GenericParametersEditor.this.table.getGenericParameters().get(index);
                    FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                    dialog.setFilterExtensions(new String[]{"*.csv"});
                    String path = dialog.open();
                    if (path != null) {
                        String text = GenericParametersEditor.toStoreString(new GenericParameters[]{setting});
                        text = StringUtils.replace((String)text, (String)"\n", (String)"\r\n");
                        try {
                            FileUtils.writeStringToFile((File)new File(path), (String)text);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } else if (e.widget == GenericParametersEditor.this.exportAllButton) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.csv"});
                String path = dialog.open();
                if (path != null) {
                    GenericParameters[] infos = GenericParametersEditor.this.table.getGenericParameters().toArray(new GenericParameters[0]);
                    String text = GenericParametersEditor.toStoreString(infos);
                    text = StringUtils.replace((String)text, (String)"\n", (String)"\r\n");
                    try {
                        FileUtils.writeStringToFile((File)new File(path), (String)text);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (e.widget == GenericParametersEditor.this.deleteAll) {
                GenericParametersEditor.this.table.getGenericParameters().removeAll(GenericParametersEditor.this.table.getGenericParameters());
                GenericParametersEditor.this.table.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

