/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ProgressMonitorUtils {
    public static IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow.getStatusLineManager().getProgressMonitor();
    }

    public static void progressMonitorBegin(IProgressMonitor monitor, String text, int step, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorBegin(monitor, text, step));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorBegin(monitor, text, step));
        }
    }

    public static void progressMonitorDone(IProgressMonitor monitor, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorDone(monitor));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorDone(monitor));
        }
    }

    public static void progressMonitorWorked(IProgressMonitor monitor, int step, boolean sync) {
        if (sync) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ProgressMonitorWorked(monitor, step));
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ProgressMonitorWorked(monitor, step));
        }
    }

    public static class ProgressMonitorDone
    implements Runnable {
        IProgressMonitor monitor;

        public ProgressMonitorDone(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    public static class ProgressMonitorBegin
    implements Runnable {
        IProgressMonitor monitor;
        String text;
        int step;

        public ProgressMonitorBegin(IProgressMonitor monitor, String text, int step) {
            this.monitor = monitor;
            this.text = text;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.text, this.step);
        }
    }

    public static class ProgressMonitorWorked
    implements Runnable {
        IProgressMonitor monitor;
        int step;

        public ProgressMonitorWorked(IProgressMonitor monitor, int step) {
            this.monitor = monitor;
            this.step = step;
        }

        public void run() {
            this.monitor.worked(this.step);
        }
    }
}

