/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class DialogMarkerFilter
extends TrayDialog {
    static final int SELECT_ALL_FILTERS_ID = 1028;
    static final int DESELECT_ALL_FILTERS_ID = 1029;
    static final int RESET_ID = 1024;
    static final int SELECT_WORKING_SET_ID = 1025;
    static final int SELECT_ALL_ID = 1026;
    static final int DESELECT_ALL_ID = 1027;
    private MarkerFilter[] filters;
    private CheckboxTreeViewer typesViewer;
    private Button anyResourceButton;
    private Button anyResourceInSameProjectButton;
    private Button selectedResourceButton;
    private Button selectedResourceAndChildrenButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private WorkingSetGroup workingSetGroup;
    private boolean dirty = false;
    private CheckboxTableViewer filtersList;
    private MarkerFilter[] selectedFilters;
    private HashMap nodeToTypeMapping = new HashMap();
    private ITreeContentProvider typesContentProvider;

    DialogMarkerFilter(Shell parentShell, MarkerFilter[] filtersList) {
        super(parentShell);
        this.setFilters(filtersList);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void setFilters(MarkerFilter[] initialFilters) {
        MarkerFilter[] newMarkers = new MarkerFilter[initialFilters.length];
        int i = 0;
        while (i < initialFilters.length) {
            MarkerFilter newFilter;
            try {
                newFilter = initialFilters[i].makeClone();
            }
            catch (CloneNotSupportedException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)MarkerMessages.MarkerFilterDialog_errorTitle, (String)MarkerMessages.MarkerFilterDialog_failedFilterMessage, (IStatus)Util.errorStatus(exception));
                return;
            }
            newMarkers[i] = newFilter;
            ++i;
        }
        this.filters = newMarkers;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.resetPressed();
                this.markDirty();
                break;
            }
            case 1025: {
                this.workingSetGroup.selectPressed();
                break;
            }
            case 1026: {
                this.typesViewer.setAllChecked(true);
                break;
            }
            case 1027: {
                this.typesViewer.setAllChecked(false);
                break;
            }
            case 1028: {
                this.filtersList.setAllChecked(true);
                break;
            }
            case 1029: {
                this.filtersList.setAllChecked(false);
                break;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MarkerMessages.filtersDialog_title);
    }

    protected void createResetArea(Composite parent) {
        Button reset = new Button(parent, 8);
        reset.setText(MarkerMessages.restoreDefaults_text);
        reset.setData((Object)new Integer(1024));
        reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogMarkerFilter.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        GridData data = new GridData(128);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = reset.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        data.horizontalSpan = 2;
        reset.setLayoutData((Object)data);
    }

    protected Button createCheckbox(Composite parent, String text, boolean grabRow) {
        Button button = new Button(parent, 32);
        if (grabRow) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        button.setFont(parent.getFont());
        return button;
    }

    protected Combo createCombo(Composite parent, String[] items, int selectionIndex) {
        Combo combo = new Combo(parent, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(parent.getFont());
        combo.setItems(items);
        combo.select(selectionIndex);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        return combo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout(2, false));
        this.createFiltersArea(dialogArea);
        Composite selectedComposite = this.createSelectedFilterArea(dialogArea);
        selectedComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.updateUIFromFilter();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)this.filters[0]));
        this.createResetArea(dialogArea);
        this.createSeparatorLine(dialogArea);
        DialogMarkerFilter.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    void createFiltersArea(Composite dialogArea) {
        Composite listArea = new Composite(dialogArea, 0);
        listArea.setLayoutData((Object)new GridData(4, 4, true, true));
        listArea.setLayout((Layout)new GridLayout());
        this.createUserFiltersArea(listArea);
        this.createFilterSelectButtons(listArea);
    }

    void createUserFiltersArea(Composite listArea) {
        Composite userComposite = new Composite(listArea, 0);
        userComposite.setLayout((Layout)new GridLayout(2, false));
        userComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(userComposite, 0);
        title.setText(MarkerMessages.MarkerFilter_filtersTitle);
        GridData titleData = new GridData();
        titleData.horizontalSpan = 2;
        title.setLayoutData((Object)titleData);
        this.filtersList = CheckboxTableViewer.newCheckList((Composite)userComposite, (int)2048);
        this.filtersList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return DialogMarkerFilter.this.filters;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.filtersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MarkerFilter)element).getName();
            }
        });
        this.selectedFilters = new MarkerFilter[]{this.filters[0]};
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object[])this.selectedFilters));
        this.filtersList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DialogMarkerFilter.this.updateFilterFromUI();
                DialogMarkerFilter.this.setSelectedFilter(event);
            }
        });
        this.filtersList.setInput((Object)this);
        int i = 0;
        while (i < this.filters.length) {
            this.filtersList.setChecked((Object)this.filters[i], this.filters[i].isEnabled());
            ++i;
        }
        GridData listData = new GridData(4, 4, true, true);
        listData.widthHint = this.convertHorizontalDLUsToPixels(100);
        this.filtersList.getControl().setLayoutData((Object)listData);
        Composite buttons = new Composite(userComposite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 1;
        buttons.setLayoutData((Object)buttonsData);
        Button addNew = new Button(buttons, 8);
        addNew.setText(MarkerMessages.MarkerFilter_addFilterName);
        addNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog newDialog = new InputDialog(DialogMarkerFilter.this.getShell(), MarkerMessages.MarkerFilterDialog_title, MarkerMessages.MarkerFilterDialog_message, MarkerMessages.MarkerFilter_newFilterName, new IInputValidator(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return MarkerMessages.MarkerFilterDialog_emptyMessage;
                        }
                        int i = 0;
                        while (i < DialogMarkerFilter.access$6(7.access$0(this.this$1)).length) {
                            if (DialogMarkerFilter.access$6(7.access$0(this.this$1))[i].getName().equals(newText)) {
                                return NLS.bind((String)MarkerMessages.filtersDialog_conflictingName, (Object)newText);
                            }
                            ++i;
                        }
                        return null;
                    }
                });
                newDialog.open();
                String newName = newDialog.getValue();
                if (newName != null) {
                    DialogMarkerFilter.this.createNewFilter(newName);
                }
            }

            static /* synthetic */ DialogMarkerFilter access$0(7 var0) {
                return var0.DialogMarkerFilter.this;
            }
        });
        this.setButtonLayoutData(addNew);
        Button remove = new Button(buttons, 8);
        remove.setText(MarkerMessages.MarkerFilter_deleteSelectedName);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogMarkerFilter.this.removeFilters(DialogMarkerFilter.this.filtersList.getSelection());
            }
        });
        this.setButtonLayoutData(remove);
    }

    protected void setSelectedFilter(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            MarkerFilter[] selected = new MarkerFilter[list.size()];
            list.toArray(selected);
            this.selectedFilters = selected;
        } else {
            this.selectedFilters = new MarkerFilter[0];
        }
        this.updateUIFromFilter();
    }

    protected void removeFilters(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            List toRemove = ((IStructuredSelection)selection).toList();
            MarkerFilter[] newFilters = new MarkerFilter[this.filters.length - toRemove.size()];
            int index = 0;
            int i = 0;
            while (i < this.filters.length) {
                if (!toRemove.contains(this.filters[i])) {
                    newFilters[index] = this.filters[i];
                    ++index;
                }
                ++i;
            }
            this.filters = newFilters;
            this.filtersList.refresh();
            this.updateUIFromFilter();
        }
    }

    private void createNewFilter(String newName) {
        MarkerFilter filter;
        MarkerFilter[] newFilters = new MarkerFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, newFilters, 0, this.filters.length);
        newFilters[this.filters.length] = filter = this.newFilter(newName);
        this.filters = newFilters;
        this.filtersList.refresh();
        this.filtersList.setSelection((ISelection)new StructuredSelection((Object)filter), true);
        this.filtersList.getControl().setFocus();
    }

    protected abstract MarkerFilter newFilter(String var1);

    Composite createSelectedFilterArea(Composite composite) {
        Composite selectedComposite = new Composite(composite, 0);
        selectedComposite.setLayout((Layout)new GridLayout(2, false));
        Composite leftComposite = new Composite(selectedComposite, 0);
        leftComposite.setLayout((Layout)new GridLayout());
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createResourceArea(leftComposite);
        this.createAttributesArea(leftComposite);
        Composite rightComposite = new Composite(selectedComposite, 0);
        this.createTypesArea(rightComposite);
        rightComposite.setLayout((Layout)new GridLayout());
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return selectedComposite;
    }

    protected void createSeparatorLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setFont(parent.getFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogMarkerFilter.this.updateForSelection();
            }
        });
        return button;
    }

    protected void createResourceArea(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        group.setFont(parent.getFont());
        this.anyResourceButton = this.createRadioButton(group, MarkerMessages.filtersDialog_anyResource);
        this.anyResourceInSameProjectButton = this.createRadioButton(group, MarkerMessages.filtersDialog_anyResourceInSameProject);
        this.selectedResourceButton = this.createRadioButton(group, MarkerMessages.filtersDialog_selectedResource);
        this.selectedResourceAndChildrenButton = this.createRadioButton(group, MarkerMessages.filtersDialog_selectedAndChildren);
        this.workingSetGroup = new WorkingSetGroup(group);
    }

    protected void createTypesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.filtersDialog_showItemsOfType);
        Tree tree = new Tree(composite, 68386);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(false);
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        new TreeColumn(tree, 0, 0);
        this.typesViewer = new CheckboxTreeViewer(tree);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertVerticalDLUsToPixels(100);
        gridData.heightHint = this.convertVerticalDLUsToPixels(125);
        this.typesContentProvider = this.getTypesContentProvider();
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)this.typesContentProvider);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.typesViewer.setComparator(this.getComparator());
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DialogMarkerFilter.this.markDirty();
                Object element = event.getElement();
                boolean checked = event.getChecked();
                DialogMarkerFilter.this.setChildrenChecked(element, checked);
                DialogMarkerFilter.this.setParentCheckState(element, checked);
            }
        });
        this.typesViewer.setInput((Object)this.getSelectedFilter().getRootTypes().toArray());
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.selectAllButton = this.createButton(buttonComposite, 1026, MarkerMessages.filtersDialog_selectAllTypes, false);
        this.deselectAllButton = this.createButton(buttonComposite, 1027, MarkerMessages.filtersDialog_deselectAllTypes, false);
    }

    protected MarkerFilter getSelectedFilter() {
        if (this.selectedFilters.length == 1) {
            return this.selectedFilters[0];
        }
        return null;
    }

    private ITreeContentProvider getTypesContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                MarkerFilter selected = DialogMarkerFilter.this.getSelectedFilter();
                if (selected == null) {
                    return new Object[0];
                }
                return DialogMarkerFilter.this.getRootEntries(selected);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return ((AbstractNode)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((AbstractNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((AbstractNode)element).hasChildren();
            }
        };
    }

    abstract void createAttributesArea(Composite var1);

    private ILabelProvider getLabelProvider() {
        return new TypesLabelProvider();
    }

    protected List getSelectedTypes() {
        Object[] checkElements = this.typesViewer.getCheckedElements();
        ArrayList<Object> selected = new ArrayList<Object>();
        int i = 0;
        while (i < checkElements.length) {
            AbstractNode node = (AbstractNode)checkElements[i];
            if (!node.isCategory()) {
                selected.add(((MarkerTypeNode)node).getMarkerType());
            }
            ++i;
        }
        return selected;
    }

    protected ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return this.getComparator().compare(((AbstractNode)e1).getName(), ((AbstractNode)e2).getName());
            }
        };
    }

    protected void okPressed() {
        this.updateFilterFromUI();
        int i = 0;
        while (i < this.filters.length) {
            this.filters[i].setEnabled(this.filtersList.getChecked((Object)this.filters[i]));
            ++i;
        }
        super.okPressed();
    }

    protected void resetPressed() {
        this.typesViewer.setAllChecked(true);
        int onResource = 0;
        this.anyResourceButton.setSelection(onResource == 0);
        this.anyResourceInSameProjectButton.setSelection(onResource == 3);
        this.selectedResourceButton.setSelection(onResource == 1);
        this.selectedResourceAndChildrenButton.setSelection(onResource == 2);
        this.workingSetGroup.setSelection(onResource == 4);
        this.updateEnabledState(true);
    }

    void setSelectedTypes(List markerTypes) {
        this.typesViewer.setCheckedElements(new Object[0]);
        int i = 0;
        while (i < markerTypes.size()) {
            Object mapping;
            Object obj = markerTypes.get(i);
            if (obj instanceof MarkerType && (mapping = this.nodeToTypeMapping.get(((MarkerType)obj).getId())) != null) {
                this.typesViewer.setChecked(mapping, true);
                this.setParentCheckState(mapping, true);
            }
            ++i;
        }
    }

    protected void updateEnabledState(boolean enabled) {
        this.typesViewer.getTree().setEnabled(enabled);
        this.selectAllButton.setEnabled(enabled && this.typesViewer.getTree().getItemCount() > 0);
        this.deselectAllButton.setEnabled(enabled && this.typesViewer.getTree().getItemCount() > 0);
        this.anyResourceButton.setEnabled(enabled);
        this.anyResourceInSameProjectButton.setEnabled(enabled);
        this.selectedResourceButton.setEnabled(enabled);
        this.selectedResourceAndChildrenButton.setEnabled(enabled);
        this.workingSetGroup.setEnabled(enabled);
    }

    protected final void updateFilterFromUI() {
        MarkerFilter filter = this.getSelectedFilter();
        if (filter == null) {
            this.updateEnabledState(false);
            return;
        }
        this.updateFilterFromUI(filter);
    }

    protected void updateFilterFromUI(MarkerFilter filter) {
        filter.setSelectedTypes(this.getSelectedTypes());
        if (this.selectedResourceButton.getSelection()) {
            filter.setOnResource(1);
        } else if (this.selectedResourceAndChildrenButton.getSelection()) {
            filter.setOnResource(2);
        } else if (this.anyResourceInSameProjectButton.getSelection()) {
            filter.setOnResource(3);
        } else if (this.workingSetGroup.getSelection()) {
            filter.setOnResource(4);
        } else {
            filter.setOnResource(0);
        }
        filter.setWorkingSet(this.workingSetGroup.getWorkingSet());
    }

    protected final void updateUIFromFilter() {
        MarkerFilter filter = this.getSelectedFilter();
        if (filter == null) {
            this.updateEnabledState(false);
            return;
        }
        this.updateUIWithFilter(filter);
    }

    protected void updateUIWithFilter(MarkerFilter filter) {
        this.setSelectedTypes(filter.getSelectedTypes());
        int on = filter.getOnResource();
        this.anyResourceButton.setSelection(on == 0);
        this.anyResourceInSameProjectButton.setSelection(on == 3);
        this.selectedResourceButton.setSelection(on == 1);
        this.selectedResourceAndChildrenButton.setSelection(on == 2);
        this.workingSetGroup.setSelection(on == 4);
        this.workingSetGroup.setWorkingSet(filter.getWorkingSet());
        this.updateEnabledState(true);
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markDirty() {
        this.dirty = true;
    }

    public void setFilter(MarkerFilter newFilter) {
        this.setFilters(new MarkerFilter[]{newFilter});
        this.updateUIFromFilter();
    }

    public MarkerFilter[] getFilters() {
        return this.filters;
    }

    protected void updateForSelection() {
        this.updateEnabledState(true);
        this.markDirty();
    }

    Object[] getRootEntries(MarkerFilter selected) {
        List roots = selected.getRootTypes();
        ArrayList markerNodes = new ArrayList();
        HashMap categories = new HashMap();
        int i = 0;
        while (i < roots.size()) {
            Object obj = roots.get(i);
            this.buildTypeTree(markerNodes, obj, categories);
            ++i;
        }
        return markerNodes.toArray();
    }

    private void buildTypeTree(List elements, Object obj, HashMap categories) {
        if (obj instanceof MarkerType) {
            MarkerType markerType = (MarkerType)obj;
            String categoryName = MarkerSupportRegistry.getInstance().getCategory(markerType.getId());
            if (categoryName == null) {
                elements.add(new MarkerTypeNode(markerType));
            } else {
                MarkerCategory category;
                if (categories.containsKey(categoryName)) {
                    category = (MarkerCategory)categories.get(categoryName);
                } else {
                    category = new MarkerCategory(categoryName);
                    categories.put(categoryName, category);
                    elements.add(category);
                }
                MarkerTypeNode node = new MarkerTypeNode(markerType);
                category.add(node);
            }
            MarkerType[] subTypes = ((MarkerType)obj).getSubtypes();
            int j = 0;
            while (j < subTypes.length) {
                this.buildTypeTree(elements, subTypes[j], categories);
                ++j;
            }
        }
    }

    private void setParentCheckState(Object element, boolean checked) {
        Object parent = this.typesContentProvider.getParent(element);
        if (parent == null) {
            return;
        }
        Object[] children = this.typesContentProvider.getChildren(parent);
        if (children.length == 0) {
            return;
        }
        if (checked) {
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                if (!this.typesViewer.getChecked(object)) {
                    this.typesViewer.setGrayChecked(parent, true);
                    return;
                }
                ++i;
            }
            this.typesViewer.setChecked(parent, true);
        } else {
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                if (this.typesViewer.getChecked(object)) {
                    this.typesViewer.setGrayChecked(parent, true);
                    return;
                }
                ++i;
            }
            this.typesViewer.setChecked(parent, false);
        }
    }

    private void setChildrenChecked(Object element, boolean checked) {
        Object[] children = this.typesContentProvider.getChildren(element);
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                this.typesViewer.setChecked(children[i], checked);
                ++i;
            }
        }
    }

    protected void createFilterSelectButtons(Composite listArea) {
        Composite buttons = new Composite(listArea, 0);
        GridLayout buttonLayout = new GridLayout(2, false);
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        this.createButton(buttons, 1028, MarkerMessages.filtersDialog_selectAll, false);
        this.createButton(buttons, 1029, MarkerMessages.filtersDialog_deselectAll, false);
    }

    private abstract class AbstractNode {
        private AbstractNode() {
        }

        public abstract Object getParent();

        public abstract String getName();

        public abstract boolean hasChildren();

        public abstract Object[] getChildren();

        public abstract boolean isCategory();
    }

    private class MarkerCategory
    extends AbstractNode {
        String name;
        Collection types = new ArrayList();

        public MarkerCategory(String categoryName) {
            this.name = categoryName;
        }

        public String getName() {
            return this.name;
        }

        public void add(MarkerTypeNode markerType) {
            this.types.add(markerType);
            markerType.setCategory(this);
        }

        public Object[] getMarkerTypes() {
            return this.types.toArray();
        }

        public Object[] getChildren() {
            return this.getMarkerTypes();
        }

        public Object getParent() {
            return null;
        }

        public boolean hasChildren() {
            return true;
        }

        public boolean isCategory() {
            return true;
        }
    }

    private class MarkerTypeNode
    extends AbstractNode {
        MarkerType type;
        MarkerCategory category;

        public MarkerTypeNode(MarkerType markerType) {
            this.type = markerType;
            DialogMarkerFilter.this.nodeToTypeMapping.put(markerType.getId(), this);
        }

        public void setCategory(MarkerCategory category) {
            this.category = category;
        }

        public MarkerCategory getCategory() {
            return this.category;
        }

        public Object[] getChildren() {
            return new Object[0];
        }

        public Object getParent() {
            return this.category;
        }

        public boolean hasChildren() {
            return false;
        }

        public String getName() {
            return this.type.getLabel();
        }

        public boolean isCategory() {
            return false;
        }

        public Object getMarkerType() {
            return this.type;
        }
    }

    private class TypesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TypesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((AbstractNode)element).getName();
        }
    }

    private class WorkingSetGroup {
        private Button button;
        private Button selectButton;

        WorkingSetGroup(Composite parent) {
            this.button = DialogMarkerFilter.this.createRadioButton(parent, MarkerMessages.filtersDialog_noWorkingSet);
            GridData data = new GridData(768);
            this.button.setLayoutData((Object)data);
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            Button radio = new Button(parent, 16);
            layout.marginWidth = radio.computeSize((int)-1, (int)-1).x;
            layout.marginHeight = 0;
            radio.dispose();
            composite.setLayout((Layout)layout);
            this.selectButton = DialogMarkerFilter.this.createButton(composite, 1025, MarkerMessages.filtersDialog_workingSetSelect, false);
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean selected) {
            this.button.setSelection(selected);
            if (selected) {
                DialogMarkerFilter.this.anyResourceButton.setSelection(false);
                DialogMarkerFilter.this.anyResourceInSameProjectButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceButton.setSelection(false);
                DialogMarkerFilter.this.selectedResourceAndChildrenButton.setSelection(false);
            }
        }

        void selectPressed() {
            IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(DialogMarkerFilter.this.getShell(), false);
            IWorkingSet workingSet = this.getWorkingSet();
            if (workingSet != null) {
                dialog.setSelection(new IWorkingSet[]{workingSet});
            }
            if (dialog.open() == 0) {
                DialogMarkerFilter.this.markDirty();
                IWorkingSet[] result = dialog.getSelection();
                if (result != null && result.length > 0) {
                    this.setWorkingSet(result[0]);
                } else {
                    this.setWorkingSet(null);
                }
                if (!this.getSelection()) {
                    this.setSelection(true);
                }
            }
        }

        void setWorkingSet(IWorkingSet workingSet) {
            this.button.setData((Object)workingSet);
            if (workingSet != null) {
                this.button.setText(NLS.bind((String)MarkerMessages.filtersDialog_workingSet, (Object)workingSet.getLabel()));
            } else {
                this.button.setText(MarkerMessages.filtersDialog_noWorkingSet);
            }
        }

        void setEnabled(boolean enabled) {
            this.button.setEnabled(enabled);
            this.selectButton.setEnabled(enabled);
        }
    }
}

