/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle.sub2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.sub2.CommentObject;
import jp.sourceforge.akjrcp.subtitle.sub2.SUBObject;

public class SUBParser {
    public static final double NTSC = 29.97;
    public static final double PAL = 25.0;

    public List parseSub(Reader re) {
        Vector<Object> list = new Vector<Object>();
        BufferedReader reader = new BufferedReader(re);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int frame2_end;
                int frame1_end;
                if (line.startsWith(";")) {
                    CommentObject comment = new CommentObject();
                    comment.setComment(line.substring(1));
                    list.add(comment);
                    continue;
                }
                if (!line.startsWith("{") || (frame1_end = line.indexOf("}{", 1)) == -1 || (frame2_end = line.indexOf("}", frame1_end + 2)) == -1) continue;
                SUBObject sub = new SUBObject();
                sub.setStartFrame(Integer.parseInt(line.substring(1, frame1_end)));
                sub.setEndFrame(Integer.parseInt(line.substring(frame1_end + 2, frame2_end)));
                sub.setText(line.substring(frame2_end + 1));
                list.add(sub);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public List getSubDataList(List subList) {
        return this.getSubDataList(subList, 29.97);
    }

    public List getSubDataList(List subList, double frameRate) {
        Vector<StandardSubObject> list = new Vector<StandardSubObject>();
        int i = 0;
        while (i < subList.size()) {
            if (subList.get(i) instanceof SUBObject) {
                SUBObject sub = (SUBObject)subList.get(i);
                StandardSubObject standard = new StandardSubObject();
                standard.setStartTime((int)(frameRate * (double)sub.getStartFrame()));
                standard.setEndTime((int)(frameRate * (double)sub.getEndFrame()));
                if (this.isImageFile(sub.getText())) {
                    standard.setImagePath(sub.getText());
                } else {
                    standard.setText(sub.getPrintString());
                }
                list.add(standard);
            }
            ++i;
        }
        return list;
    }

    private boolean isImageFile(String text) {
        String[] extensions = new String[]{".png", ".gif", ".bmp", ".jpg"};
        int i = 0;
        while (i < extensions.length) {
            if (text.toLowerCase().endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

