/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.SiteWithTimestamp;

public class ExtendedSite
extends SiteWithTimestamp {
    private boolean digestExist;
    private String[] availableLocals;
    private String digestURL;
    private LiteFeature[] liteFeatures;
    private LiteFeature[] allLiteFeatures;
    private IURLEntry[] associateSites;
    private boolean pack200 = false;
    private IURLEntry selectedMirror;

    public String getDigestURL() {
        return this.digestURL;
    }

    public void setDigestURL(String digestURL) {
        this.digestURL = digestURL;
    }

    public String[] getAvailableLocals() {
        return this.availableLocals;
    }

    public void setAvailableLocals(String[] availableLocals) {
        this.availableLocals = availableLocals;
    }

    public boolean isDigestExist() {
        return this.digestExist;
    }

    public void setDigestExist(boolean digestExist) {
        this.digestExist = digestExist;
    }

    public LiteFeature[] getLiteFeatures() {
        if (this.getCurrentConfiguredSite() != null) {
            return this.filterFeatures(this.getNonFilteredLiteFeatures());
        }
        return this.getNonFilteredLiteFeatures();
    }

    public void setLiteFeatures(LiteFeature[] liteFeatures) {
        if (liteFeatures == null || liteFeatures.length == 0) {
            return;
        }
        this.allLiteFeatures = liteFeatures;
        ArrayList<LiteFeature> temp = new ArrayList<LiteFeature>();
        int i = 0;
        while (i < this.allLiteFeatures.length) {
            if (this.getFeatureReference(this.allLiteFeatures[i]) != null) {
                temp.add(this.allLiteFeatures[i]);
            }
            ++i;
        }
        if (!temp.isEmpty()) {
            this.liteFeatures = temp.toArray(new LiteFeature[temp.size()]);
        }
    }

    public LiteFeature getLiteFeature(VersionedIdentifier vid) {
        if (this.allLiteFeatures == null) {
            return null;
        }
        int i = 0;
        while (i < this.allLiteFeatures.length) {
            if (vid.equals(this.allLiteFeatures[i].getVersionedIdentifier())) {
                return this.allLiteFeatures[i];
            }
            ++i;
        }
        return null;
    }

    public LiteFeature[] getNonFilteredLiteFeatures() {
        return this.liteFeatures;
    }

    public void setNonFilteredLiteFeatures(LiteFeature[] liteFeatures) {
        this.liteFeatures = liteFeatures;
    }

    public boolean supportsPack200() {
        return this.pack200;
    }

    public void setSupportsPack200(boolean pack) {
        this.pack200 = pack;
    }

    private LiteFeature[] filterFeatures(LiteFeature[] allIncluded) {
        ArrayList<LiteFeature> list = new ArrayList<LiteFeature>();
        if (allIncluded != null) {
            int i = 0;
            while (i < allIncluded.length) {
                LiteFeature included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + included);
                }
                ++i;
            }
        }
        LiteFeature[] result = new LiteFeature[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public IURLEntry[] getAssociateSites() {
        return this.associateSites;
    }

    public void setAssociateSites(IURLEntry[] associateSites) {
        this.associateSites = associateSites;
    }

    public IURLEntry getSelectedMirror() {
        return this.selectedMirror;
    }

    public void setSelectedMirror(IURLEntry selectedMirror) {
        this.selectedMirror = selectedMirror;
    }
}

