/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;

public class Polygon
extends Polyline {
    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        boolean isOdd = false;
        int[] pointsxy = this.getPoints().toIntArray();
        int n = pointsxy.length;
        if (n > 3) {
            int x0 = pointsxy[n - 2];
            int y0 = pointsxy[n - 1];
            int i = 0;
            while (i < n) {
                int x1 = pointsxy[i++];
                int y1 = pointsxy[i++];
                if (y0 <= y && y < y1 && this.crossProduct(x1, y1, x0, y0, x, y) > 0) {
                    boolean bl = isOdd = !isOdd;
                }
                if (y1 <= y && y < y0 && this.crossProduct(x0, y0, x1, y1, x, y) > 0) {
                    isOdd = !isOdd;
                }
                x0 = x1;
                y0 = y1;
            }
            if (isOdd) {
                return true;
            }
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int crossProduct(int ax, int ay, int bx, int by, int cx, int cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }

    protected void fillShape(Graphics g) {
        g.fillPolygon(this.getPoints());
    }

    protected void outlineShape(Graphics g) {
        g.drawPolygon(this.getPoints());
    }
}

