/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import jp.sourceforge.akjrcp.text_douga.item.TextItem;
import jp.sourceforge.akjrcp.text_douga.rcp.TextDougaView;

public class MultiStyledText
extends AbstractItem {
    List<TextItem> textItems = new ArrayList<TextItem>();
    private boolean debug = false;

    public void addTextItem(TextItem item) {
        this.textItems.add(item);
    }

    public MultiStyledText(TextItem item) {
        super(item);
    }

    public Dimension getDimension(DougaPreference preference, BufferedImage baseImage, int frame) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        ImageObject obj = new ImageObject(img);
        Point lastPosition = null;
        int dx = 0;
        int dy = 0;
        int my = 0;
        int mx = 0;
        int i = 0;
        while (i < this.textItems.size()) {
            TextItem item = this.textItems.get(i);
            if (i == 0) {
                item.setX(dx);
                item.setY(dy);
            } else if (lastPosition != null) {
                item.setX(dx);
                item.setY(lastPosition.y);
                item.setFirstOffset(lastPosition.x);
                item.setLastLineY(my);
            } else {
                item.setX(dx);
                item.setY(dy);
            }
            try {
                item.writeFrame(preference, obj, frame);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.trace((Object)(String.valueOf(item.getText()) + ":y=" + item.getY()));
            if (item.getLastDrawPosition() != null) {
                lastPosition = item.getLastDrawPosition();
                if (item.getMaxDrawedX() > mx) {
                    mx = item.getMaxDrawedX();
                }
                if (lastPosition.y + item.getLineHeight() > my) {
                    my = lastPosition.y + item.getLineHeight();
                }
            } else {
                log.warn((Object)"dimension:null");
            }
            TextDougaView.TextDougaExecute.log.trace((Object)(String.valueOf(item.getText()) + ":lastPosition=" + lastPosition));
            item.resetMultiStyledSupport();
            ++i;
        }
        g2.dispose();
        Dimension dimension = new Dimension(mx, my);
        return dimension;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean writed = false;
        Point lastPosition = null;
        int dx = this.x;
        int dy = this.y;
        int my = 0;
        boolean written = false;
        if (this.duration == -1.0) {
            written = true;
        }
        preference.getFps();
        if (!written) {
            written = this.isInFrame(preference, frame);
        }
        if (!written) {
            return false;
        }
        Dimension d = this.getDimension(preference, baseImage.getImage(), frame);
        Rectangle drawRect = this.getDrawRect(preference, d);
        dx = drawRect.x;
        dy = 0;
        if (this.debug) {
            log.warn((Object)("debug-mode:dimension:" + dx + "," + dy + "," + d));
            log.warn((Object)("debug-mode:rect:" + drawRect));
            baseImage.getImage().getGraphics().drawRect(dx, drawRect.y, d.width, d.height);
        }
        int i = 0;
        while (i < this.textItems.size()) {
            TextItem item = this.textItems.get(i);
            if (item.getText() == null || item.getText().length() == 0) {
                log.warn((Object)"wrong text setted,maybe make problem");
            }
            if (i == 0) {
                item.setX(dx);
                item.setY(drawRect.y);
            } else if (lastPosition != null) {
                item.setX(dx);
                item.setY(lastPosition.y);
                item.setFirstOffset(lastPosition.x - dx);
                item.setLastLineY(my - dy);
            } else {
                log.info((Object)("time is not inside or:lastPosition=null:" + item.getText()));
                item.setX(dx);
                item.setY(drawRect.y);
            }
            log.trace((Object)(String.valueOf(item.getText()) + ":y=" + item.getY()));
            boolean w = item.writeFrame(preference, baseImage, frame);
            if (w) {
                writed = true;
            }
            if ((lastPosition = item.getLastDrawPosition()) != null) {
                if (lastPosition.y + item.getLineHeight() > my) {
                    my = lastPosition.y + item.getLineHeight();
                }
            } else {
                log.warn((Object)"lastPosition:null");
            }
            TextDougaView.TextDougaExecute.log.trace((Object)(String.valueOf(item.getText()) + ":lastPosition=" + lastPosition));
            item.resetMultiStyledSupport();
            ++i;
        }
        return writed;
    }

    public Rectangle getDrawRect(DougaPreference preference, Dimension dimension) {
        int drawwidth = Math.max(dimension.width, this.width);
        int drawheight = Math.max(dimension.height, this.height);
        log.trace((Object)("text:" + drawwidth + "," + drawheight));
        int dw = drawwidth;
        int dh = drawheight;
        int dx = 0;
        if (this.align == 0) {
            dx = this.x;
            dw = drawwidth;
        } else if (this.align == 1) {
            dx = this.x == 0 && this.width == 0 ? this.marginLeft : this.x;
            dw = drawwidth;
        } else if (this.align == 3) {
            dx = this.x == 0 && this.width == 0 ? preference.getWidth() - dimension.width - this.marginRight : this.x + (drawwidth - dimension.width);
            dw = drawwidth;
        } else if (this.align == 2) {
            dx = this.width == 0 ? this.marginRight + (preference.getWidth() - this.marginLeft - this.marginRight - dw) / 2 : this.x + (drawwidth - dimension.width) / 2;
            dw = drawwidth;
        } else {
            log.warn((Object)("invalid align:" + this.align));
        }
        int dy = 0;
        if (this.valign == 0) {
            dy = this.y;
            dh = drawheight;
        } else if (this.valign == 1) {
            dy = this.y == 0 && this.height == 0 ? this.y + this.marginTop : this.y;
            dh = drawheight;
        } else if (this.valign == 3) {
            dy = this.y == 0 && this.height == 0 ? preference.getHeight() - dimension.height - this.marginBottom : this.y + (drawheight - dimension.height);
            dh = drawheight;
        } else if (this.valign == 2) {
            dy = this.height == 0 ? (preference.getHeight() - dimension.height - this.marginBottom) / 2 : this.y + (drawheight - dimension.height) / 2;
            dh = drawheight;
        } else {
            log.warn((Object)("invalid valign:" + this.valign));
        }
        return new Rectangle(dx, dy, dw, dh);
    }
}

