/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.utils;

import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.imageio.plugins.gif.GIFImageReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import jp.sourceforge.akjrcp.text_douga.item.ColorItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GifAnimeUtils {
    public static Log log = LogFactory.getLog(ColorItem.class);

    public static GIFImageReader getGifReader(File file) {
        GIFImageReader reader = (GIFImageReader)ImageIO.getImageReadersByFormatName("GIF").next();
        if (reader == null) {
            log.warn((Object)"gif reader not found");
            return null;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(new FileInputStream(file));
            reader.setInput(iis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static int findAnimationFrame(GIFImageReader reader, double animationTime) {
        double mod = animationTime % GifAnimeUtils.getGifDuration(reader);
        int delayed = new BigDecimal("" + mod).multiply(new BigDecimal(100)).intValue();
        try {
            int num = reader.getNumImages(true);
            int total = 0;
            int i = 0;
            while (i < num) {
                GIFImageMetadata md = (GIFImageMetadata)reader.getImageMetadata(i);
                if (delayed < (total += Math.max(1, md.delayTime))) {
                    return i;
                }
                ++i;
            }
        }
        catch (IIOException e) {
            e.printStackTrace();
        }
        log.warn((Object)("invalid fnumber:" + delayed));
        return 0;
    }

    public static int countFrames(GIFImageReader reader) {
        try {
            return reader.getNumImages(true);
        }
        catch (IIOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static double getGifDuration(GIFImageReader reader) {
        double duration = 0.0;
        try {
            int num = reader.getNumImages(true);
            int deleys = 0;
            int i = 0;
            while (i < num) {
                GIFImageMetadata md = (GIFImageMetadata)reader.getImageMetadata(i);
                deleys += Math.max(1, md.delayTime);
                ++i;
            }
            if (deleys > 0) {
                duration = new BigDecimal("" + deleys).divide(new BigDecimal(100)).doubleValue();
            }
        }
        catch (IIOException e) {
            e.printStackTrace();
        }
        return duration;
    }
}

