/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game.state;

import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.Debugger;
import com.jmex.game.state.StatisticsGameState;
import java.util.logging.Logger;

public class DebugGameState
extends StatisticsGameState {
    private static final Logger logger = Logger.getLogger(DebugGameState.class.getName());
    protected InputHandler input;
    protected WireframeState wireState;
    protected LightState lightState;
    protected boolean pause;
    protected boolean showBounds = false;
    protected boolean showDepth = false;
    protected boolean showNormals = false;

    public DebugGameState() {
        this(true);
    }

    public DebugGameState(boolean bl) {
        this.init(bl);
    }

    private void init(boolean bl) {
        this.rootNode = new Node("RootNode");
        this.wireState = DisplaySystem.getDisplaySystem().getRenderer().createWireframeState();
        this.wireState.setEnabled(false);
        this.rootNode.setRenderState((RenderState)this.wireState);
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.rootNode.setRenderState((RenderState)zBufferState);
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(0.75f, 0.75f, 0.75f, 0.75f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(100.0f, 100.0f, 100.0f));
        pointLight.setEnabled(true);
        this.lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        this.lightState.setEnabled(true);
        this.lightState.attach((Light)pointLight);
        this.rootNode.setRenderState((RenderState)this.lightState);
        if (bl) {
            this.input = new FirstPersonHandler(DisplaySystem.getDisplaySystem().getRenderer().getCamera(), 15.0f, 0.5f);
            this.initKeyBindings();
        }
        DisplaySystem.getDisplaySystem().getRenderer().enableStatistics(true);
        this.rootNode.updateRenderState();
        this.rootNode.updateWorldBound();
        this.rootNode.updateGeometricState(0.0f, true);
    }

    public LightState getLightState() {
        return this.lightState;
    }

    private void initKeyBindings() {
        KeyBindingManager.getKeyBindingManager().set("toggle_pause", 25);
        KeyBindingManager.getKeyBindingManager().set("toggle_wire", 20);
        KeyBindingManager.getKeyBindingManager().set("toggle_lights", 38);
        KeyBindingManager.getKeyBindingManager().set("toggle_bounds", 48);
        KeyBindingManager.getKeyBindingManager().set("toggle_normals", 49);
        KeyBindingManager.getKeyBindingManager().set("camera_out", 46);
        KeyBindingManager.getKeyBindingManager().set("screen_shot", 59);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
        KeyBindingManager.getKeyBindingManager().set("parallel_projection", 60);
        KeyBindingManager.getKeyBindingManager().set("toggle_depth", 61);
        KeyBindingManager.getKeyBindingManager().set("mem_report", 19);
        KeyBindingManager.getKeyBindingManager().set("toggle_mouse", 50);
    }

    public void update(float f) {
        super.update(f);
        if (this.input != null) {
            this.input.update(f);
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_pause", false)) {
                boolean bl = this.pause = !this.pause;
            }
            if (this.pause) {
                return;
            }
        }
        this.rootNode.updateGeometricState(f, true);
        if (this.input != null) {
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_wire", false)) {
                this.wireState.setEnabled(!this.wireState.isEnabled());
                this.rootNode.updateRenderState();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_lights", false)) {
                this.lightState.setEnabled(!this.lightState.isEnabled());
                this.rootNode.updateRenderState();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_bounds", false)) {
                boolean bl = this.showBounds = !this.showBounds;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_depth", false)) {
                boolean bl = this.showDepth = !this.showDepth;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_normals", false)) {
                boolean bl = this.showNormals = !this.showNormals;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("camera_out", false)) {
                logger.info("Camera at: " + DisplaySystem.getDisplaySystem().getRenderer().getCamera().getLocation());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("screen_shot", false)) {
                DisplaySystem.getDisplaySystem().getRenderer().takeScreenShot("SimpleGameScreenShot");
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("parallel_projection", false)) {
                if (DisplaySystem.getDisplaySystem().getRenderer().getCamera().isParallelProjection()) {
                    this.cameraPerspective();
                } else {
                    this.cameraParallel();
                }
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("mem_report", false)) {
                long l = Runtime.getRuntime().totalMemory();
                long l2 = Runtime.getRuntime().freeMemory();
                long l3 = Runtime.getRuntime().maxMemory();
                logger.info("|*|*|  Memory Stats  |*|*|");
                logger.info("Total memory: " + (l >> 10) + " kb");
                logger.info("Free memory: " + (l2 >> 10) + " kb");
                logger.info("Max memory: " + (l3 >> 10) + " kb");
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_mouse", false)) {
                MouseInput.get().setCursorVisible(!MouseInput.get().isCursorVisible());
                logger.info("Cursor Visibility set to " + MouseInput.get().isCursorVisible());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
                System.exit(0);
            }
        }
    }

    protected void cameraPerspective() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        Camera camera = displaySystem.getRenderer().getCamera();
        camera.setFrustumPerspective(45.0f, (float)displaySystem.getWidth() / (float)displaySystem.getHeight(), 1.0f, 1000.0f);
        camera.setParallelProjection(false);
        camera.update();
    }

    protected void cameraParallel() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        Camera camera = displaySystem.getRenderer().getCamera();
        camera.setParallelProjection(true);
        float f = (float)displaySystem.getWidth() / (float)displaySystem.getHeight();
        camera.setFrustum(-100.0f, 1000.0f, -50.0f * f, 50.0f * f, -50.0f, 50.0f);
        camera.update();
    }

    public void render(float f) {
        super.render(f);
        DisplaySystem.getDisplaySystem().getRenderer().draw((Spatial)this.rootNode);
        if (this.showBounds) {
            Debugger.drawBounds((SceneElement)this.rootNode, (Renderer)DisplaySystem.getDisplaySystem().getRenderer(), (boolean)true);
        }
        if (this.showNormals) {
            Debugger.drawNormals((SceneElement)this.rootNode, (Renderer)DisplaySystem.getDisplaySystem().getRenderer());
        }
        if (this.showDepth) {
            DisplaySystem.getDisplaySystem().getRenderer().renderQueue();
            Debugger.drawBuffer((int)2, (int)1, (Renderer)DisplaySystem.getDisplaySystem().getRenderer());
        }
    }

    public void cleanup() {
    }
}

