/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game.state;

import com.jmex.game.state.GameState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameStateNode<G extends GameState>
extends GameState {
    protected ArrayList<G> children;

    public GameStateNode(String string) {
        this.name = string;
        this.children = new ArrayList();
    }

    @Override
    public void update(float f) {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = (GameState)this.children.get(i);
            if (!gameState.isActive()) continue;
            gameState.update(f);
        }
    }

    @Override
    public void render(float f) {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = (GameState)this.children.get(i);
            if (!gameState.isActive()) continue;
            gameState.render(f);
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = (GameState)this.children.get(i);
            gameState.cleanup();
        }
        this.detachAllChildren();
    }

    public void attachChild(G g) {
        ((GameState)g).setParent(this);
        this.children.add(g);
    }

    public void detachChild(GameState gameState) {
        this.children.remove(gameState);
    }

    public void detachChild(String string) {
        this.detachChild(this.getChild(string));
    }

    public void detachChild(int n) {
        this.detachChild((GameState)this.getChild(n));
    }

    public void detachAllChildren() {
        this.children.clear();
    }

    public ArrayList<G> getChildren() {
        return this.children;
    }

    public GameState getChild(String string) {
        for (GameState gameState : this.children) {
            if (!string.equals(gameState.getName())) continue;
            return gameState;
        }
        return null;
    }

    public G getChild(int n) {
        return (G)((GameState)this.children.get(n));
    }

    public int getQuantity() {
        return this.children.size();
    }

    public boolean hasChild(G g) {
        return this.children.contains(g);
    }

    public void activateAllChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = (GameState)this.children.get(i);
            gameState.setActive(true);
        }
    }

    public void deactivateAllChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            GameState gameState = (GameState)this.children.get(i);
            gameState.setActive(false);
        }
    }

    public void activateChildNamed(String string) {
        this.getChild(string).setActive(true);
    }

    public void deactivateChildNamed(String string) {
        this.getChild(string).setActive(false);
    }
}

