/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.system.JmeException;
import com.jmex.terrain.util.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Logger;

public class FaultFractalHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(FaultFractalHeightMap.class.getName());
    private int iterations;
    private int minDelta;
    private int maxDelta;
    private Random randomizer;

    public FaultFractalHeightMap(int n, int n2, int n3, int n4, float f) {
        this(n, n2, n3, n4, f, System.currentTimeMillis());
    }

    public FaultFractalHeightMap(int n, int n2, int n3, int n4, float f, long l) {
        if (n <= 0 || n2 <= 0 || n3 > n4 || f < 0.0f || f >= 1.0f) {
            throw new JmeException("Either size is not greater than zero, iterations is not greater than zero, minDelta is more than maxDelta and/or filter is not between 0 and 1.");
        }
        this.size = n;
        this.iterations = n2;
        this.minDelta = n3;
        this.maxDelta = n4;
        this.filter = f;
        this.randomizer = new Random(l);
        this.load();
    }

    public boolean load() {
        int n;
        int n2;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        float[][] fArray = new float[this.size][this.size];
        for (n2 = 0; n2 < this.iterations; ++n2) {
            int n3;
            int n4;
            float f = this.maxDelta - (this.maxDelta - this.minDelta) * n2 / this.iterations;
            int n5 = (int)(this.random() * (double)this.size);
            int n6 = (int)(this.random() * (double)this.size);
            do {
                n4 = (int)(this.random() * (double)this.size);
                n3 = (int)(this.random() * (double)this.size);
            } while (n5 == n4 && n6 == n3);
            int n7 = n4 - n5;
            int n8 = n3 - n6;
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n - n5;
                    int n10 = i - n6;
                    if (n9 * n8 - n7 * n10 <= 0) continue;
                    float[] fArray2 = fArray[n];
                    int n11 = i;
                    fArray2[n11] = fArray2[n11] + f;
                }
            }
        }
        this.erodeTerrain(fArray);
        this.normalizeTerrain(fArray);
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.setHeightAtPoint((int)fArray[n2][n], n, n2);
            }
        }
        logger.info("Created Heightmap using Fault Fractal");
        return true;
    }

    private double random() {
        return this.randomizer.nextDouble();
    }

    public void setIterations(int n) {
        if (n <= 0) {
            throw new JmeException("iterations must be greater than zero");
        }
        this.iterations = n;
    }

    public void setMinDelta(int n) {
        if (n > this.maxDelta) {
            throw new JmeException("minDelta must be greater than the current maxDelta");
        }
        this.minDelta = n;
    }

    public void setMaxDelta(int n) {
        if (n < this.minDelta) {
            throw new JmeException("maxDelta must be greater than current minDelta");
        }
        this.maxDelta = n;
    }
}

