/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui.dnd;

import com.jmex.awt.swingui.dnd.JMEDragAndDrop;
import com.jmex.awt.swingui.dnd.JMEDragGestureEvent;
import com.jmex.awt.swingui.dnd.JMEDragGestureListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class JMEMouseDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent firstEvent = null;
    private int motionThreshold = 5;
    private JMEDragGestureListener dragGestureListener;
    private Component component;
    private JMEDragAndDrop dnd;

    public JMEMouseDragGestureRecognizer(JMEDragAndDrop jMEDragAndDrop, Component component, int n, JMEDragGestureListener jMEDragGestureListener) {
        this.dragGestureListener = jMEDragGestureListener;
        this.component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.dnd = jMEDragAndDrop;
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        return 2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.firstEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dnd.isDragging()) {
            this.dnd.doDrop(mouseEvent);
        }
        this.firstEvent = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.firstEvent != null) {
            mouseEvent.consume();
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            int n2 = Math.abs(mouseEvent.getX() - this.firstEvent.getX());
            int n3 = Math.abs(mouseEvent.getY() - this.firstEvent.getY());
            if (n2 > this.getMotionThreshold() || n3 > this.getMotionThreshold()) {
                SwingUtilities.convertMouseEvent(this.firstEvent.getComponent(), this.firstEvent, this.component);
                JMEDragGestureEvent jMEDragGestureEvent = new JMEDragGestureEvent(this, n, this.firstEvent.getPoint(), this.firstEvent);
                this.dispatchDragGestureEvent(jMEDragGestureEvent);
                this.firstEvent = null;
            }
        } else if (this.dnd.isDragging()) {
            this.dnd.doDrag(mouseEvent);
            mouseEvent.consume();
        }
    }

    protected void dispatchDragGestureEvent(final JMEDragGestureEvent jMEDragGestureEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JMEMouseDragGestureRecognizer.this.dragGestureListener.dragGestureRecognized(jMEDragGestureEvent);
            }
        });
    }

    public int getMotionThreshold() {
        return this.motionThreshold;
    }

    public void setMotionThreshold(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("motion threshold must be at least 1");
        }
        this.motionThreshold = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.firstEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.dnd.isDragging()) {
            this.dnd.mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.dnd.isDragging()) {
            this.dnd.mouseExited(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

