/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLtoBinary {
    private DataOutputStream myOut;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Correct way to use is: <FormatFile> <jmeoutputfile>");
            System.err.println("For example: runner.xml runner.jme");
            return;
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        if (!inFile.canRead()) {
            System.err.println("Cannot read input file " + inFile);
            return;
        }
        try {
            System.out.println("Converting file " + inFile + " to " + outFile);
            new XMLtoBinary().sendXMLtoBinary(new FileInputStream(inFile), new FileOutputStream(outFile));
        }
        catch (IOException e) {
            System.err.println("Unable to convert:" + e);
            return;
        }
        System.out.println("Conversion complete!");
    }

    public void sendXMLtoBinary(InputStream XmlStream, OutputStream binFile) {
        this.myOut = new DataOutputStream(binFile);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(XmlStream, (DefaultHandler)new SAXConverter());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to do IO correctly:" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Serious parser configuration error:" + e.getMessage());
        }
        catch (SAXParseException e) {
            throw new RuntimeException(e.toString() + '\n' + "Line: " + e.getLineNumber() + '\n' + "Column: " + e.getColumnNumber());
        }
        catch (SAXException e) {
            throw new RuntimeException("Unknown sax error: " + e.getMessage());
        }
    }

    private class SAXConverter
    extends DefaultHandler {
        private static final boolean DEBUG = false;

        private SAXConverter() {
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeLong(1234567L);
            }
            catch (IOException e) {
                throw new SAXException("Unable to write header:" + e);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(2);
                XMLtoBinary.this.myOut.close();
            }
            catch (IOException e) {
                throw new SAXException("Unable to close binFile outStream:" + e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(0);
                XMLtoBinary.this.myOut.writeUTF(qName);
                XMLtoBinary.this.myOut.writeByte(atts.getLength());
                for (int i = 0; i < atts.getLength(); ++i) {
                    String currentAtt = atts.getQName(i);
                    XMLtoBinary.this.myOut.writeUTF(currentAtt);
                    this.processWrite(qName, currentAtt, atts.getValue(i));
                }
            }
            catch (IOException e) {
                throw new SAXException("Unable to write start element: " + qName + " " + e);
            }
        }

        private void processWrite(String qName, String att, String value) throws IOException {
            if ("data".equals(att)) {
                if ("vertex".equals(qName) || "normal".equals(qName) || "origvertex".equals(qName) || "orignormal".equals(qName)) {
                    this.writeVector3fArray(value);
                } else if ("color".equals(qName)) {
                    this.writeColorArray(value);
                } else if ("texturecoords".equals(qName)) {
                    this.writeVector2fArray(value);
                } else if ("index".equals(qName) || "jointindex".equals(qName)) {
                    this.writeIntArray(value);
                } else if ("defcolor".equals(qName)) {
                    this.writeColor(value);
                } else {
                    this.writeString(value);
                }
            } else if ("boundsphere".equals(qName)) {
                if ("radius".equals(att)) {
                    this.writeFloat(value);
                } else if ("center".equals(att)) {
                    this.writeVec3f(value);
                }
            } else if ("clodrecords".equals(qName)) {
                if ("numrec".equals(att)) {
                    this.writeInt(value);
                }
            } else if ("obb".equals(qName)) {
                if ("xaxis".equals(att) || "yaxis".equals(att) || "zaxis".equals(att) || "extent".equals(att)) {
                    this.writeVec3f(value);
                } else if ("center".equals(att)) {
                    this.writeVec3f(value);
                }
            } else if ("crecord".equals(qName)) {
                if ("indexary".equals(att)) {
                    this.writeIntArray(value);
                } else if ("numi".equals(att) || "numt".equals(att) || "numv".equals(att) || "vkeep".equals(att) || "vthrow".equals(att) || "index".equals(att)) {
                    this.writeInt(value);
                }
            } else if ("terrainblock".equals(qName) || "terrainpage".equals(qName)) {
                if ("tbsize".equals(att) || "totsize".equals(att) || "size".equals(att) || "offamnt".equals(att)) {
                    this.writeInt(value);
                } else if ("step".equals(att) || "stepscale".equals(att) || "translation".equals(att)) {
                    this.writeVec3f(value);
                } else if ("isclod".equals(att)) {
                    this.writeBoolean(value);
                } else if ("offset".equals(att)) {
                    this.writeVec2f(value);
                } else if ("hmap".equals(att)) {
                    this.writeIntArray(value);
                }
                if ("disttol".equals(att) || "trisppix".equals(att)) {
                    this.writeFloat(value);
                } else if ("name".equals(att)) {
                    this.writeString(value);
                }
            } else if ("areaclod".equals(qName)) {
                if ("disttol".equals(att) || "trisppix".equals(att)) {
                    this.writeFloat(value);
                } else if ("name".equals(att)) {
                    this.writeString(value);
                }
            } else if ("alphastate".equals(qName)) {
                if ("srcfunc".equals(att) || "dstfunc".equals(att) || "testfunc".equals(att)) {
                    this.writeInt(value);
                } else if ("reference".equals(att)) {
                    this.writeFloat(value);
                } else if ("blend".equals(att) || "test".equals(att) || "enabled".equals(att)) {
                    this.writeBoolean(value);
                }
            } else if ("index".equals(att)) {
                if ("sptscale".equals(qName) || "sptrot".equals(qName) || "spttrans".equals(qName)) {
                    this.writeIntArray(value);
                } else if ("joint".equals(qName)) {
                    this.writeInt(value);
                } else {
                    this.writeString(value);
                }
            } else if ("loc".equals(att) || "dir".equals(att) || "scale".equals(att) || "translation".equals(att) || "trans".equals(att) || "localvec".equals(att) || "origcent".equals(att) || "origext".equals(att) || "nowcent".equals(att) || "nowext".equals(att)) {
                this.writeVec3f(value);
            } else if ("rotation".equals(att) || "rot".equals(att)) {
                this.writeQuat(value);
            } else if ("localrot".equals(att)) {
                this.writeMatrix3(value);
            } else if ("alpha".equals(att) || "shiny".equals(att) || "time".equals(att) || "width".equals(att)) {
                this.writeFloat(value);
            } else if ("fps".equals(att) || "speed".equals(att) || "fconstant".equals(att) || "flinear".equals(att) || "fquadratic".equals(att) || "fangle".equals(att) || "fexponent".equals(att)) {
                this.writeFloat(value);
            } else if ("ambient".equals(att) || "diffuse".equals(att) || "emissive".equals(att) || "specular".equals(att)) {
                this.writeColor(value);
            } else if ("URL".equals(att)) {
                this.writeURL(value);
            } else if ("isattenuate".equals(att)) {
                this.writeBoolean(value);
            } else if ("rptype".equals(att) || "numJoints".equals(att) || "parentindex".equals(att)) {
                this.writeInt(value);
            } else if ("v3farray".equals(att) || "scalevalues".equals(att) || "transvalues".equals(att)) {
                this.writeVector3fArray(value);
            } else if ("quatarray".equals(att) || "rotvalues".equals(att)) {
                this.writeQuatArray(value);
            } else if ("q3norm".equals(att)) {
                this.writeShortArray(value);
            } else if ("q3vert".equals(att)) {
                this.writeByteArray(value);
            } else if ("texnum".equals(att) || "wrap".equals(att) || "parnum".equals(att) || "obnum".equals(att) || "facetype".equals(att) || "numobjects".equals(att)) {
                this.writeInt(value);
            } else {
                this.writeString(value);
            }
        }

        private void writeShortArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(14);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(information.length);
            for (int i = 0; i < information.length; ++i) {
                XMLtoBinary.this.myOut.writeShort(Short.parseShort(information[i]));
            }
        }

        private void writeByteArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(13);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(information.length);
            for (int i = 0; i < information.length; ++i) {
                XMLtoBinary.this.myOut.writeShort(Byte.parseByte(information[i]));
            }
        }

        private void writeQuatArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(12);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (information.length % 4 != 0) {
                throw new IOException("Quat length not modulus of 4: " + information.length);
            }
            XMLtoBinary.this.myOut.writeInt(information.length / 4);
            for (int i = 0; i < information.length / 4; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 2]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 3]));
            }
        }

        private void writeBoolean(String value) throws IOException {
            boolean toWrite;
            if ("true".equals(value)) {
                toWrite = true;
            } else if ("false".equals(value)) {
                toWrite = false;
            } else {
                throw new IOException("Parameter must be true or false, not " + value);
            }
            XMLtoBinary.this.myOut.writeByte(11);
            XMLtoBinary.this.myOut.writeBoolean(toWrite);
        }

        private void writeInt(String value) throws IOException {
            XMLtoBinary.this.myOut.write(10);
            XMLtoBinary.this.myOut.writeInt(Integer.parseInt(value));
        }

        private void writeURL(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(9);
            XMLtoBinary.this.myOut.writeUTF(value);
        }

        private void writeColor(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(8);
            String[] split = value.trim().split(" ");
            if (split.length != 4) {
                throw new IOException("ilformated Color:" + value);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[2]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[3]));
        }

        private void writeFloat(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(7);
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(value));
        }

        private void writeMatrix3(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(16);
            String[] split = value.trim().split(" ");
            if (split.length != 9) {
                throw new IOException("ilformated Matrix3:" + value);
            }
            for (int i = 0; i < 9; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[i]));
            }
        }

        private void writeQuat(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(6);
            String[] split = value.trim().split(" ");
            if (split.length != 4) {
                throw new IOException("ilformated Quat:" + value);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[2]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[3]));
        }

        private void writeVec3f(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(5);
            String[] split = value.trim().split(" ");
            if (split.length != 3) {
                throw new IOException("ilformated Vector3f:" + value);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[2]));
        }

        private void writeVec2f(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(15);
            String[] split = value.trim().split(" ");
            if (split.length != 2) {
                throw new IOException("ilformated Vector2f:" + value);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(split[1]));
        }

        private void writeString(String value) throws IOException {
            XMLtoBinary.this.myOut.writeByte(3);
            XMLtoBinary.this.myOut.writeUTF(value);
        }

        private void writeIntArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(4);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(information.length);
            for (int i = 0; i < information.length; ++i) {
                XMLtoBinary.this.myOut.writeInt(Integer.parseInt(information[i]));
            }
        }

        private void writeVector2fArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(1);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (information.length % 2 != 0) {
                throw new IOException("Vector2f length not modulus of 2: " + information.length);
            }
            XMLtoBinary.this.myOut.writeInt(information.length / 2);
            for (int i = 0; i < information.length / 2; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 2 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 2 + 1]));
            }
        }

        public void writeColorArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(2);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (information.length % 4 != 0) {
                throw new IOException("Color length not modulus of 4: " + information.length);
            }
            XMLtoBinary.this.myOut.writeInt(information.length / 4);
            for (int i = 0; i < information.length / 4; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 2]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 4 + 3]));
            }
        }

        private void writeVector3fArray(String data) throws IOException {
            XMLtoBinary.this.myOut.writeByte(0);
            if (data == null || data.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] information = this.removeDoubleWhiteSpaces(data).trim().split(" ");
            if (information.length == 1 && "".equals(information[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (information.length % 3 != 0) {
                throw new IOException("Vector3f length not modulus of 3: " + information.length);
            }
            XMLtoBinary.this.myOut.writeInt(information.length / 3);
            for (int i = 0; i < information.length / 3; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 3 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 3 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(information[i * 3 + 2]));
            }
        }

        private String removeDoubleWhiteSpaces(String data) {
            StringBuffer toReturn = new StringBuffer();
            boolean whiteSpaceFlag = false;
            for (int i = 0; i < data.length(); ++i) {
                if (Character.isWhitespace(data.charAt(i))) {
                    if (!whiteSpaceFlag && toReturn.length() != 0) {
                        toReturn.append(' ');
                    }
                    whiteSpaceFlag = true;
                    continue;
                }
                toReturn.append(data.charAt(i));
                whiteSpaceFlag = false;
            }
            return toReturn.toString();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(1);
                XMLtoBinary.this.myOut.writeUTF(qName);
            }
            catch (IOException e) {
                throw new SAXException("Unable to write end element: " + qName + " " + e);
            }
        }
    }
}

