/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.xml;

import com.jmex.xml.xml.Document;
import com.jmex.xml.xml.XmlException;
import java.io.Serializable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class Node
implements Serializable {
    protected static final short Attribute = 0;
    protected static final short Element = 1;
    protected static final short Text = 2;
    protected static final short CData = 3;
    protected static final short Comment = 4;
    protected static final short ProcessingInstruction = 5;
    protected org.w3c.dom.Node domNode = null;

    public Node(Node node) {
        this.domNode = node.domNode;
    }

    public Node(org.w3c.dom.Node node) {
        this.domNode = node;
    }

    public Node(org.w3c.dom.Document document) {
        this.domNode = document.getDocumentElement();
    }

    public Node(Document document, String string, String string2, String string3) {
        this.domNode = document.createRootElement(string, string3);
        this.mapPrefix(string2, string);
        document.declareNamespaces(this);
    }

    public org.w3c.dom.Node getDomNode() {
        return this.domNode;
    }

    public void copyOf(Node node) {
        org.w3c.dom.Node node2 = this.domNode.getOwnerDocument().importNode(node.domNode, true);
        if (this.domNode.getParentNode() != null) {
            this.domNode.getParentNode().replaceChild(node2, this.domNode);
        }
        this.domNode = node2;
    }

    public static String getDomNodeValue(org.w3c.dom.Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getNodeValue();
        if (string != null) {
            return string;
        }
        return Node.getInnerText(node);
    }

    protected static String getInnerText(org.w3c.dom.Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                stringBuffer.append(node2.getNodeValue());
                continue;
            }
            if (node2.getNodeType() == 1) {
                stringBuffer.append(Node.getInnerText(node2));
                continue;
            }
            if (node2.getNodeType() != 4) continue;
            stringBuffer.append(node2.getNodeValue());
        }
        return stringBuffer.toString();
    }

    public static String getNodeTextValue(org.w3c.dom.Node node) {
        return Node.getDomNodeValue(node);
    }

    protected static void setDomNodeValue(org.w3c.dom.Node node, String string) {
        if (node == null) {
            return;
        }
        if (node.getNodeValue() != null) {
            node.setNodeValue(string);
            return;
        }
        org.w3c.dom.Node node2 = node.getFirstChild();
        if (node2 == null || node2.getNodeType() != 3) {
            node.appendChild(node.getOwnerDocument().createTextNode(string));
            return;
        }
    }

    public void mapPrefix(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        Element element = (Element)this.domNode;
        if (string == null || string.equals("")) {
            element.setAttribute("xmlns", string2);
        } else {
            element.setAttribute("xmlns:" + string, string2);
        }
    }

    public void assign(Node node) {
        Node.setDomNodeValue(this.domNode, Node.getDomNodeValue(node.domNode).toString());
    }

    protected void declareNamespace(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        Element element = this.domNode.getOwnerDocument().getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!attr.getValue().equals(string2) || !attr.getName().startsWith("xmlns")) continue;
                return;
            }
        }
        if (string.equals("xml") && string2.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        if (string == null || string.equals("")) {
            element.setAttribute("xmlns", string2);
        } else {
            element.setAttribute("xmlns:" + string, string2);
        }
    }

    protected org.w3c.dom.Node appendDomChild(int n, String string, String string2, String string3) {
        switch (n) {
            case 0: {
                Attr attr = this.domNode.getOwnerDocument().createAttributeNS(string, string2);
                attr.setNodeValue(string3);
                this.domNode.getAttributes().setNamedItemNS(attr);
                return attr;
            }
            case 1: {
                Element element = this.domNode.getOwnerDocument().createElementNS(string, string2);
                if (string3 != null && string3.length() != 0) {
                    element.appendChild(this.domNode.getOwnerDocument().createTextNode(string3));
                }
                this.domNode.appendChild(element);
                return element;
            }
            case 2: {
                Text text = this.domNode.getOwnerDocument().createTextNode(string3);
                this.domNode.appendChild(text);
                return text;
            }
            case 3: {
                CDATASection cDATASection = this.domNode.getOwnerDocument().createCDATASection(string3);
                this.domNode.appendChild(cDATASection);
                return cDATASection;
            }
            case 4: {
                Comment comment = this.domNode.getOwnerDocument().createComment(string3);
                this.domNode.appendChild(comment);
                return comment;
            }
            case 5: {
                ProcessingInstruction processingInstruction = this.domNode.getOwnerDocument().createProcessingInstruction(string2, string3);
                this.domNode.appendChild(processingInstruction);
                return processingInstruction;
            }
        }
        throw new XmlException("Unknown type");
    }

    public static boolean domNodeNameEquals(org.w3c.dom.Node node, String string, String string2) {
        String string3;
        if (node == null) {
            return false;
        }
        if (string2 == null) {
            return true;
        }
        String string4 = node.getNamespaceURI() == null ? "" : node.getNamespaceURI();
        String string5 = string3 = node.getLocalName() == null ? "" : node.getLocalName();
        if (string == null) {
            string = "";
        }
        return string4.equals(string) && string3.equals(string2);
    }

    protected int getDomChildCount(int n, String string, String string2) {
        switch (n) {
            case 0: {
                try {
                    return ((Element)this.domNode).hasAttributeNS(string, string2) ? 1 : 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n2 = nodeList.getLength();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!Node.domNodeNameEquals(node, string, string2)) continue;
                    ++n3;
                }
                return n3;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected boolean hasDomChild(int n, String string, String string2) {
        switch (n) {
            case 0: {
                return ((Element)this.domNode).hasAttributeNS(string, string2);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    if (!Node.domNodeNameEquals(nodeList.item(i), string, string2)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomChildAt(int n, String string, String string2, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                return this.domNode.getAttributes().getNamedItemNS(string, string2);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!Node.domNodeNameEquals(node, string, string2) || n3++ != n2) continue;
                    return node;
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomFirstChild(int n, String string, String string2) {
        boolean bl = false;
        switch (n) {
            case 0: {
                if (!((Element)this.domNode).hasAttributeNS(string, string2)) {
                    return null;
                }
                return this.domNode.getAttributes().getNamedItemNS(string, string2);
            }
            case 1: {
                if (!this.domNode.hasChildNodes()) {
                    return null;
                }
                for (org.w3c.dom.Node node = this.domNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !Node.domNodeNameEquals(node, string, string2)) continue;
                    org.w3c.dom.Node node2 = node;
                    node = null;
                    return node2;
                }
                return null;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomNextChild(int n, String string, String string2, org.w3c.dom.Node node) {
        boolean bl = false;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                org.w3c.dom.Node node2 = node;
                if (node2 != null) {
                    node2 = node2.getNextSibling();
                }
                while (node2 != null) {
                    if (Node.domNodeNameEquals(node2, string, string2)) {
                        return node2;
                    }
                    node2 = node2.getNextSibling();
                }
                return null;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomChild(int n, String string, String string2) {
        return this.getDomChildAt(n, string, string2, 0);
    }

    protected org.w3c.dom.Node insertDomChildAt(int n, String string, String string2, int n2, String string3) {
        if (n == 0) {
            return this.appendDomChild(n, string, string2, string3);
        }
        Element element = this.domNode.getOwnerDocument().createElementNS(string, string2);
        element.appendChild(this.domNode.getOwnerDocument().createTextNode(string3));
        return this.domNode.insertBefore(element, this.getDomChildAt(1, string, string2, n2));
    }

    protected org.w3c.dom.Node insertDomElementAt(String string, String string2, int n, Node node) {
        node.domNode = this.domNode.insertBefore(this.cloneDomElementAs(string, string2, node), this.getDomChildAt(1, string, string2, n));
        return node.domNode;
    }

    protected org.w3c.dom.Node replaceDomChildAt(int n, String string, String string2, int n2, String string3) {
        if (n == 0) {
            return this.appendDomChild(n, string, string2, string3);
        }
        Element element = this.domNode.getOwnerDocument().createElementNS(string, string2);
        element.appendChild(this.domNode.getOwnerDocument().createTextNode(string3));
        return this.domNode.replaceChild(element, this.getDomChildAt(1, string, string2, n2));
    }

    protected org.w3c.dom.Node replaceDomElementAt(String string, String string2, int n, Node node) {
        node.domNode = this.domNode.replaceChild(this.cloneDomElementAs(string, string2, node), this.getDomChildAt(1, string, string2, n));
        return node.domNode;
    }

    protected org.w3c.dom.Node setDomChildAt(int n, String string, String string2, String string3, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                Attr attr = ((Element)this.domNode).getAttributeNodeNS(string, string2);
                ((Element)this.domNode).setAttributeNS(string, string2, string3);
                return attr;
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!Node.domNodeNameEquals(node, string, string2) || n3++ != n2) continue;
                    return node.replaceChild(node.getOwnerDocument().createTextNode(string3), node.getFirstChild());
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node setDomChild(int n, String string, String string2, String string3) {
        if (n == 0 || this.getDomChildCount(n, string, string2) > 0) {
            return this.setDomChildAt(n, string, string2, string3, 0);
        }
        this.appendDomChild(n, string, string2, string3);
        return null;
    }

    protected org.w3c.dom.Node removeDomChildAt(int n, String string, String string2, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                return this.domNode.getAttributes().removeNamedItemNS(string, string2);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!Node.domNodeNameEquals(node, string, string2) || n3++ != n2) continue;
                    return this.domNode.removeChild(node);
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node appendDomElement(String string, String string2, Node node) {
        node.domNode = this.domNode.appendChild(this.cloneDomElementAs(string, string2, node));
        return node.domNode;
    }

    protected Element cloneDomElementAs(String string, String string2, Node node) {
        Element element = this.domNode.getOwnerDocument().createElementNS(string, string2);
        Element element2 = (Element)node.domNode;
        org.w3c.dom.Document document = element.getOwnerDocument();
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            element.appendChild(document.importNode(nodeList.item(i), true));
        }
        NamedNodeMap namedNodeMap = element2.getAttributes();
        NamedNodeMap namedNodeMap2 = element.getAttributes();
        n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            namedNodeMap2.setNamedItemNS((Attr)document.importNode(namedNodeMap.item(i), false));
        }
        return element;
    }

    protected void cloneInto(Element element) {
        Object object;
        while (this.domNode.getFirstChild() != null) {
            object = element.getOwnerDocument().importNode(this.domNode.getFirstChild(), true);
            element.appendChild((org.w3c.dom.Node)object);
            this.domNode.removeChild(this.domNode.getFirstChild());
        }
        object = ((Element)this.domNode).getAttributes();
        NamedNodeMap namedNodeMap = element.getAttributes();
        while (object.getLength() > 0) {
            org.w3c.dom.Node node = object.item(0);
            namedNodeMap.setNamedItem(element.getOwnerDocument().importNode(node, true));
            object.removeNamedItem(node.getNodeName());
        }
        this.domNode = element;
    }

    protected static String lookupPrefix(org.w3c.dom.Node node, String string) {
        if (node == null || string == null || string.equals("")) {
            return null;
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string2 = attr.getName();
                    String string3 = attr.getValue();
                    if (string3 == null || !string3.equals(string) || !string2.startsWith("xmlns:")) continue;
                    return string2.substring(6);
                }
            }
            return Node.lookupPrefix(node.getParentNode(), string);
        }
        if (node.getNodeType() == 2) {
            return Node.lookupPrefix(((Attr)node).getOwnerElement(), string);
        }
        return null;
    }

    protected static String lookupDefaultNamespace(org.w3c.dom.Node node) {
        Attr attr;
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNode("xmlns")) != null) {
            return attr.getValue();
        }
        return Node.lookupDefaultNamespace(node.getParentNode());
    }

    protected static void internalAdjustPrefix(org.w3c.dom.Node node, boolean bl) {
        Element element;
        if (node == null) {
            return;
        }
        if (bl) {
            String string = Node.lookupPrefix(node, node.getNamespaceURI());
            if (string != null) {
                node.setPrefix(string);
            }
        } else if (node.getNodeType() == 1 && Node.lookupDefaultNamespace(element = (Element)node) != null) {
            element.setAttribute("xmlns", "");
        }
    }

    public abstract void adjustPrefix();

    public static org.w3c.dom.Node dereference(org.w3c.dom.Node node) {
        if (node.getNodeType() != 1) {
            return node;
        }
        String string = ((Element)node).getAttribute("href");
        if (string == null || string.length() == 0) {
            return node;
        }
        string = string.substring(1);
        for (org.w3c.dom.Node node2 = node.getOwnerDocument().getDocumentElement().getFirstChild().getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !((Element)node2).getAttribute("id").equals(string)) continue;
            return node2;
        }
        return node;
    }
}

