/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.cloth;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPoint;
import com.jme.math.spring.SpringPointForce;

public final class ClothUtils {
    private ClothUtils() {
    }

    public static SpringPointForce createBasicWind(final float f, final Vector3f vector3f, final boolean bl) {
        return new SpringPointForce(){
            private final float strength;
            private final Vector3f windDirection;
            private final boolean random;
            {
                this.strength = f;
                this.windDirection = vector3f;
                this.random = bl;
            }

            public void apply(float f3, SpringPoint springPoint) {
                float f2 = this.random ? FastMath.nextRandomFloat() * this.strength : this.strength;
                springPoint.acceleration.addLocal(this.windDirection.x * f2, this.windDirection.y * f2, this.windDirection.z * f2);
            }
        };
    }

    public static SpringPointForce createBasicGravity() {
        return new SpringPointForce(){
            private Vector3f gravity = new Vector3f(0.0f, -32.14f, 0.0f);

            public void apply(float f, SpringPoint springPoint) {
                springPoint.acceleration.addLocal(this.gravity.x, this.gravity.y, this.gravity.z);
            }
        };
    }

    public static SpringPointForce createBasicDrag(final float f) {
        return new SpringPointForce(){
            private Vector3f velocity = new Vector3f();
            private float dragCoefficient = f;

            public void apply(float f2, SpringPoint springPoint) {
                this.velocity.set(springPoint.position);
                this.velocity.subtractLocal(springPoint.oldPos).divideLocal(f2);
                springPoint.acceleration.addLocal(this.velocity.multLocal(-this.dragCoefficient).multLocal(springPoint.invMass));
            }
        };
    }
}

