/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.scene.batch.TriangleBatch;
import com.jmex.effects.particles.ParticleController;
import com.jmex.effects.particles.ParticleLines;
import com.jmex.effects.particles.ParticleMesh;
import com.jmex.effects.particles.ParticlePoints;

public class ParticleFactory {
    public static ParticleMesh buildParticles(String string, int n) {
        return ParticleFactory.buildParticles(string, n, 0);
    }

    public static ParticleMesh buildParticles(String string, int n, int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("particleType should be either ParticleGeometry.PT_TRIANGLE or ParticleGeometry.PT_QUAD");
        }
        ParticleMesh particleMesh = new ParticleMesh(string, n, n2);
        ParticleController particleController = new ParticleController(particleMesh);
        particleMesh.addController(particleController);
        return particleMesh;
    }

    public static ParticleMesh buildBatchParticles(String string, TriangleBatch triangleBatch) {
        ParticleMesh particleMesh = new ParticleMesh(string, triangleBatch);
        ParticleController particleController = new ParticleController(particleMesh);
        particleMesh.addController(particleController);
        return particleMesh;
    }

    public static ParticlePoints buildPointParticles(String string, int n) {
        ParticlePoints particlePoints = new ParticlePoints(string, n);
        ParticleController particleController = new ParticleController(particlePoints);
        particlePoints.addController(particleController);
        return particlePoints;
    }

    public static ParticleLines buildLineParticles(String string, int n) {
        ParticleLines particleLines = new ParticleLines(string, n);
        ParticleController particleController = new ParticleController(particleLines);
        particleLines.addController(particleController);
        return particleLines;
    }
}

