/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.transients;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;

public class Fader
extends Quad {
    private static final long serialVersionUID = 49342555401922808L;
    public static final int DISABLED = 0;
    public static final int FADE_IN = 1;
    public static final int FADE_OUT = 2;
    private float fadeTimeInSeconds;
    private ColorRGBA color;
    private AlphaState alphaState;
    private Controller fadeController;
    private boolean ignoreUntilStable;
    private int mode;
    private float alpha;

    public Fader(String string, float f, float f2, ColorRGBA colorRGBA, float f3) {
        super(string, f <= 0.0f ? (float)DisplaySystem.getDisplaySystem().getWidth() : f, f2 <= 0.0f ? (float)DisplaySystem.getDisplaySystem().getHeight() : f2);
        this.color = colorRGBA;
        this.fadeTimeInSeconds = f3;
        this.initQuad();
        this.initAlphaState();
        this.initController();
    }

    private void initQuad() {
        this.getLocalRotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        this.getLocalTranslation().set((float)(DisplaySystem.getDisplaySystem().getWidth() / 2), (float)(DisplaySystem.getDisplaySystem().getHeight() / 2), 0.0f);
        this.getLocalScale().set(1.0f, 1.0f, 1.0f);
        this.setRenderQueueMode(4);
        this.setLightCombineMode(0);
        this.setColorBuffer(0, null);
        if (this.color == null) {
            this.color = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.setDefaultColor(this.color);
    }

    private void initAlphaState() {
        this.alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        this.alphaState.setBlendEnabled(true);
        this.alphaState.setSrcFunction(4);
        this.alphaState.setDstFunction(5);
        this.alphaState.setTestEnabled(true);
        this.alphaState.setTestFunction(4);
        this.alphaState.setEnabled(true);
        this.setRenderState((RenderState)this.alphaState);
    }

    private void initController() {
        this.fadeController = new Controller(){
            private static final long serialVersionUID = 1L;

            public void update(float f) {
                if (Fader.this.ignoreUntilStable) {
                    if (f < 0.1f) {
                        Fader.this.ignoreUntilStable = false;
                    }
                    return;
                }
                if (Fader.this.mode == 1 && Fader.this.alpha > 0.0f) {
                    Fader.this.alpha -= 1.0f / (Fader.this.fadeTimeInSeconds / f);
                    if (Fader.this.alpha < 0.0f) {
                        Fader.this.alpha = 0.0f;
                    }
                    ((Fader)Fader.this).color.a = Fader.this.alpha;
                } else if (Fader.this.mode == 2 && Fader.this.alpha < 1.0f) {
                    Fader.this.alpha += 1.0f / (Fader.this.fadeTimeInSeconds / f);
                    if (Fader.this.alpha > 1.0f) {
                        Fader.this.alpha = 1.0f;
                    }
                    ((Fader)Fader.this).color.a = Fader.this.alpha;
                } else if (Fader.this.mode == 0 && ((Fader)Fader.this).color.a != 0.0f) {
                    ((Fader)Fader.this).color.a = 0.0f;
                }
            }
        };
        this.addController(this.fadeController);
    }

    public void setMode(int n) {
        this.mode = n;
        this.ignoreUntilStable = true;
    }

    public int getMode() {
        return this.mode;
    }

    public void setAlpha(float f) {
        this.alpha = f;
        this.color.a = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getFadeTimeInSeconds() {
        return this.fadeTimeInSeconds;
    }

    public void setFadeTimeInSeconds(float f) {
        this.fadeTimeInSeconds = f;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setColor(ColorRGBA colorRGBA) {
        this.color = colorRGBA;
        if (colorRGBA == null) {
            colorRGBA = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.setDefaultColor(colorRGBA);
    }
}

