/*
 * Decompiled with CFR 0.152.
 */
package md5reader.defs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import md5reader.AbstractD3Reader;
import md5reader.defs.DefStore;

public class ModelDEFReader
extends AbstractD3Reader {
    private DefStore defStore;
    private static final Set USE = new HashSet<String>(Arrays.asList("model", "entitydef", "material", "skin"));
    private static final Set SKIP = new HashSet<String>(Arrays.asList("export", "mapDef", "table", "sound", "particle", "mapdef"));
    private static final Set TYPES = new HashSet();
    private String defaultType = "";

    public ModelDEFReader(DefStore store, InputStream in) throws IOException {
        super(in);
        this.defStore = store;
    }

    public ModelDEFReader(DefStore store, Reader reader) {
        super(reader);
        this.defStore = store;
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        super.setInputStream(in);
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType != null ? defaultType.toLowerCase() : null;
    }

    public void scan() throws IOException {
        String type;
        while ((type = this.readStringStartOfLine()) != null) {
            String name;
            if (TYPES.contains(type.toLowerCase())) {
                type = type.toLowerCase();
                name = this.readString();
            } else {
                name = type;
                type = this.defaultType;
            }
            this.skip(6);
            if (SKIP.contains(type)) {
                this.skipRestOfSection();
                continue;
            }
            if (type.equals("model")) {
                this.readModelDef(name);
                continue;
            }
            if (type.equals("entitydef")) {
                this.readEntityDef(name);
                continue;
            }
            if (type.equals("material")) {
                this.readMaterial(name);
                continue;
            }
            if (!type.equals("skin")) continue;
            this.readSkin(name);
        }
    }

    private void readEntityDef(String name) throws IOException {
        String text;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((text = this.readStringStartOfLine()) != null) {
            map.put(text, this.readString());
        }
        this.defStore.createEntityDef(name, map);
    }

    protected String readStringStartOfLine(boolean read) throws IOException {
        if (read) {
            return super.readStringStartOfLine();
        }
        return this.asString();
    }

    private void readModelDef(String name) throws IOException {
        String text;
        String model = null;
        String parent = null;
        HashMap<String, String> map = new HashMap<String, String>();
        boolean read = true;
        while ((text = this.readStringStartOfLine(read)) != null) {
            String anim;
            read = true;
            if (text.equals("inherit")) {
                parent = this.readString();
            }
            if (text.equals("mesh")) {
                model = this.readString();
                continue;
            }
            if (text.equals("channel")) {
                this.skip(3);
                this.skip(4);
                this.skipRestOfBlock();
                continue;
            }
            if (text.equals("offset")) {
                this.skip(4);
                this.skipRestOfBlock();
                continue;
            }
            if (text.equals("anim")) {
                anim = this.readString();
                String path = this.readString();
                while (path.endsWith(",")) {
                    path = path + this.readString();
                }
                map.put(anim, path);
                int next = this.read();
                if (next == 6) {
                    this.skipRestOfSection();
                    continue;
                }
                if (next == 7) break;
                if (next == 3) {
                    read = false;
                    continue;
                }
                throw new IOException("Expected OPENSEGMENT or TEXT");
            }
            if (!text.equals("remove")) continue;
            anim = this.readString();
            map.put(anim, null);
        }
        this.defStore.createModelDef(name, parent, model, map);
    }

    private void readMaterial(String name) throws IOException {
        this.skipRestOfSection();
    }

    private void readSkin(String name) throws IOException {
        String key;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((key = this.readStringStartOfLine()) != null) {
            map.put(key, this.readString());
        }
    }

    static {
        TYPES.addAll(USE);
        TYPES.addAll(SKIP);
    }
}

