/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import model.KeyFrame;
import model.Mesh;
import model.ModelInstance;
import model.Skin;
import util.file.FileUtils;

public class Model
implements Externalizable {
    private String name;
    private KeyFrame bindFrame;
    private Mesh[] meshes;
    private Map meshNames = new HashMap();
    private Skin defaultSkin;

    public Model(String name, int meshCount, Skin defaultSkin) {
        this.resetMeshCount(meshCount);
        this.name = name;
        this.defaultSkin = defaultSkin;
    }

    public void resetMeshCount(int meshCount) {
        if (meshCount != 1 && !this.isSkeletal()) {
            throw new IllegalArgumentException("Only one mesh allowed for non-skeletal models");
        }
        this.meshes = new Mesh[meshCount];
    }

    public Mesh[] getMeshes() {
        return this.meshes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mesh getMesh(String name) {
        return (Mesh)this.meshNames.get(name);
    }

    public void updateMeshNameMap() {
        this.meshNames.clear();
        for (int i = 0; i < this.meshes.length; ++i) {
            this.meshNames.put(this.meshes[i].getName(), this.meshes[i]);
        }
    }

    public Skin getDefaultSkin() {
        return this.defaultSkin;
    }

    public void setDefaultSkin(Skin defaultSkin) {
        this.defaultSkin = defaultSkin;
    }

    public KeyFrame getBind() {
        return this.bindFrame;
    }

    public KeyFrame getBindFrame() {
        return this.bindFrame;
    }

    public void setBindFrame(KeyFrame bindFrame) {
        this.bindFrame = bindFrame;
    }

    public ModelInstance createInstance() {
        return new ModelInstance(this);
    }

    public boolean isSkeletal() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.name = in.readUTF();
        this.meshes = (Mesh[])in.readObject();
        this.bindFrame = (KeyFrame)in.readObject();
        this.defaultSkin = (Skin)in.readObject();
        this.updateMeshNameMap();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeUTF(this.name);
        out.writeObject(this.meshes);
        out.writeObject(this.bindFrame);
        out.writeObject(this.defaultSkin);
    }
}

