/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import model.Model;
import model.animation.Animation;
import model.file.AnimationReader;
import util.file.FileUtils;

public class ModelInfo
implements Externalizable {
    private Map animations = new HashMap();
    private Model model;

    public ModelInfo(Model model) {
        this.model = model;
    }

    public void addAnimation(String name, Animation animation) {
        this.animations.put(name, animation);
    }

    public Animation getAnimation(String name) {
        return (Animation)this.animations.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Animation loadAnimation(String name, URL url, AnimationReader reader) throws IOException {
        InputStream in = url.openStream();
        try {
            Animation animation = reader.readAnimation(in);
            this.animations.put(name, animation);
            Animation animation2 = animation;
            return animation2;
        }
        finally {
            in.close();
        }
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FileUtils.checkVersionByte(in, 1, 1);
        this.model = (Model)in.readObject();
        this.animations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.model);
        out.writeObject(this.animations);
    }
}

