/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.jme.math.Matrix3f;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector3f;
import model.JointedMesh;
import model.SkeletalKeyFrame;
import model.Skeleton;

public class ModelUtils {
    public static boolean isIdentity(TransformMatrix matrix) {
        return false;
    }

    public static void convertToSkeletonSpace(Skeleton skeleton, JointedMesh mesh) {
        int joints = skeleton.getJointCount();
        int[] parents = skeleton.getParents();
        SkeletalKeyFrame bind = skeleton.getBindFrame();
        TransformMatrix[] jointTransform = new TransformMatrix[joints];
        TransformMatrix tempTransform = new TransformMatrix();
        Vector3f tempPosition = new Vector3f();
        for (int i = 0; i < jointTransform.length; ++i) {
            tempTransform.set(bind.rotations[i], bind.positions[i]);
            jointTransform[i] = parents[i] >= 0 ? new TransformMatrix(jointTransform[parents[i]]) : new TransformMatrix();
            jointTransform[i].multLocal(tempTransform, tempPosition);
        }
        Matrix3f tempRot = new Matrix3f();
        Vector3f[] offset = mesh.getVertexOffset();
        int[] bone = mesh.getVertexBone();
        for (int i = 0; i < mesh.getVertexCount(); ++i) {
            tempTransform = jointTransform[bone[i]];
            offset[i].subtractLocal(tempTransform.getTranslation(tempPosition));
            offset[i].divideLocal(tempTransform.getScale(tempPosition));
            tempTransform.getRotation(tempRot).invertLocal().multLocal(offset[i]);
        }
    }
}

