/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;

public class AnimationArrayCache {
    private static final ThreadLocal THREADLOCAL = new ThreadLocal();
    private Vector3f[] positions;
    private Vector3f[] positionsAccum;
    private Quaternion[] rotations;
    private Quaternion[] rotationsAccum;

    public static AnimationArrayCache get() {
        AnimationArrayCache cache = (AnimationArrayCache)THREADLOCAL.get();
        if (cache == null) {
            cache = new AnimationArrayCache();
            THREADLOCAL.set(cache);
        }
        return cache;
    }

    public Vector3f[] getPositions(int size) {
        block3: {
            block2: {
                if (this.positions != null) break block2;
                this.positions = new Vector3f[size];
                for (int i = 0; i < size; ++i) {
                    this.positions[i] = new Vector3f();
                }
                break block3;
            }
            if (this.positions.length >= size) break block3;
            Vector3f[] oldPos = this.positions;
            this.positions = new Vector3f[size];
            System.arraycopy(oldPos, 0, this.positions, 0, oldPos.length);
            for (int i = oldPos.length; i < this.positions.length; ++i) {
                this.positions[i] = new Vector3f();
            }
        }
        return this.positions;
    }

    public Vector3f[] getPositionsAccum(int size) {
        block3: {
            block2: {
                if (this.positionsAccum != null) break block2;
                this.positionsAccum = new Vector3f[size];
                for (int i = 0; i < size; ++i) {
                    this.positionsAccum[i] = new Vector3f();
                }
                break block3;
            }
            if (this.positionsAccum.length >= size) break block3;
            Vector3f[] oldPos = this.positionsAccum;
            this.positionsAccum = new Vector3f[size];
            System.arraycopy(oldPos, 0, this.positionsAccum, 0, oldPos.length);
            for (int i = oldPos.length; i < this.positionsAccum.length; ++i) {
                this.positionsAccum[i] = new Vector3f();
            }
        }
        return this.positionsAccum;
    }

    public Quaternion[] getRotations(int size) {
        block3: {
            block2: {
                if (this.rotations != null) break block2;
                this.rotations = new Quaternion[size];
                for (int i = 0; i < size; ++i) {
                    this.rotations[i] = new Quaternion();
                }
                break block3;
            }
            if (this.rotations.length >= size) break block3;
            Quaternion[] oldRot = this.rotations;
            this.rotations = new Quaternion[size];
            System.arraycopy(oldRot, 0, this.rotations, 0, oldRot.length);
            for (int i = oldRot.length; i < this.rotations.length; ++i) {
                this.rotations[i] = new Quaternion();
            }
        }
        return this.rotations;
    }

    public Quaternion[] getRotationsAccum(int size) {
        block3: {
            block2: {
                if (this.rotationsAccum != null) break block2;
                this.rotationsAccum = new Quaternion[size];
                for (int i = 0; i < size; ++i) {
                    this.rotationsAccum[i] = new Quaternion();
                }
                break block3;
            }
            if (this.rotationsAccum.length >= size) break block3;
            Quaternion[] oldRot = this.rotationsAccum;
            this.rotationsAccum = new Quaternion[size];
            System.arraycopy(oldRot, 0, this.rotationsAccum, 0, oldRot.length);
            for (int i = oldRot.length; i < this.rotationsAccum.length; ++i) {
                this.rotationsAccum[i] = new Quaternion();
            }
        }
        return this.rotationsAccum;
    }
}

