/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.TransformMatrix;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import model.ModelInstance;
import model.ModelUtils;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.AnimationArrayCache;
import model.animation.Animator;
import model.animation.BindAnimator;
import model.animation.IAnimationListener;

public class AnimationController
extends Controller {
    private static final long serialVersionUID = 1L;
    protected ModelInstance instance;
    protected List animators = new ArrayList(2);
    private EventHandler eventHandler = new EventHandler();
    protected boolean updatingBounds;
    private float skipRate;
    private float currentSkip;
    protected boolean updatingLocalTransform;

    public AnimationController(ModelInstance instance) {
        if (instance.isSkeletal() != this.isSkeletal()) {
            throw new IllegalArgumentException("skeletal/non skeletal mismatch");
        }
        if (!this.isSkeletal() && instance.getMeshes().length > 1) {
            throw new IllegalArgumentException("vertex animations can only have one mesh");
        }
        this.instance = instance;
    }

    public void update(float timePassed) {
        if (!this.isActive()) {
            return;
        }
        this.currentSkip += timePassed;
        if (!(this.currentSkip >= this.skipRate)) {
            return;
        }
        timePassed = this.currentSkip;
        this.currentSkip = 0.0f;
        timePassed *= this.getSpeed();
        float weightMod = 0.0f;
        for (int i = 0; i < this.animators.size(); ++i) {
            Animator animator = (Animator)this.animators.get(i);
            if (animator.updateWeight(timePassed) && animator.update(timePassed) && animator.getWeight() != Float.POSITIVE_INFINITY) {
                weightMod += animator.getWeight();
                continue;
            }
            this.animators.remove(i--);
            this.eventHandler.notify(animator, 2, null);
        }
        if (weightMod > 0.0f) {
            this.animate(1.0f / weightMod);
        } else {
            this.instance.loadBindFrame();
        }
        if (this.animators.isEmpty()) {
            this.setActive(false);
        }
    }

    protected void animate(float weightMod) {
        int i;
        int vertexCount = this.instance.getModel().getMeshes()[0].getVertexCount();
        AnimationArrayCache cache = AnimationArrayCache.get();
        Vector3f[] positionsCache = cache.getPositions(vertexCount);
        Vector3f[] target = BufferUtils.getVector3Array((FloatBuffer)this.instance.getMeshes()[0].getVertexBuffer(0));
        TransformMatrix base = this.instance.getTransformation();
        boolean identity = ModelUtils.isIdentity(base);
        Vector3f temp = new Vector3f();
        for (i = 0; i < vertexCount; ++i) {
            target[i].set(0.0f, 0.0f, 0.0f);
        }
        for (i = 0; i < this.animators.size(); ++i) {
            Animator animator = (Animator)this.animators.get(i);
            float weight = animator.getWeight() * weightMod;
            Vector3f[] positions = animator.getPositions(positionsCache, null);
            for (int j = 0; j < vertexCount; ++j) {
                target[j].addLocal(temp.set(positions[i]).multLocal(weight));
            }
        }
        if (!identity) {
            for (i = 0; i < vertexCount; ++i) {
                base.multPoint(target[i]);
            }
        }
        if (this.updatingBounds) {
            this.instance.getMeshes()[0].updateModelBound();
        }
    }

    public void clearAnimators() {
        this.animators.clear();
        this.eventHandler.notify(null, 3, null);
    }

    public AnimationAnimator addAnimation(Animation animation) {
        AnimationAnimator animator = new AnimationAnimator(animation);
        this.addAnimator(animator);
        return animator;
    }

    protected void setupAnimator(Animator animator) {
        animator.setAnimationController(this);
    }

    public void addAnimator(Animator animator) {
        this.setActive(true);
        this.setupAnimator(animator);
        this.animators.add(animator);
        this.eventHandler.notify(animator, 1, null);
    }

    public void addAnimator(int index, Animator animator) {
        this.setActive(true);
        this.setupAnimator(animator);
        this.animators.add(index, animator);
        this.eventHandler.notify(animator, 1, null);
    }

    public void setAnimator(int index, Animator animator) {
        this.setActive(true);
        this.setupAnimator(animator);
        this.animators.set(index, animator);
        this.eventHandler.notify(animator, 1, null);
    }

    public void fadeToAnimator(Animator animator, float fadeTime) {
        for (int i = 0; i < this.animators.size(); ++i) {
            ((Animator)this.animators.get(i)).fadeOut(fadeTime, true);
        }
        this.addAnimator(animator);
        animator.fadeIn(fadeTime);
    }

    public int getAnimatorCount() {
        return this.animators.size();
    }

    public Animator getAnimatorAt(int index) {
        return (Animator)this.animators.get(index);
    }

    public Animator removeAnimator(int index) {
        Animator removed = (Animator)this.animators.remove(index);
        removed.setAnimationController(null);
        this.eventHandler.notify(removed, 2, null);
        return removed;
    }

    public ModelInstance getModelInstance() {
        return this.instance;
    }

    public boolean isUpdatingBounds() {
        return this.updatingBounds;
    }

    public void setUpdatingBounds(boolean updatingBounds) {
        this.updatingBounds = updatingBounds;
    }

    public void addListener(IAnimationListener listener) {
        this.eventHandler.addListener(listener);
    }

    public void removeListener(IAnimationListener listener) {
        this.eventHandler.removeListener(listener);
    }

    public Animator createBindAnimator() {
        return new BindAnimator();
    }

    public boolean isSkeletal() {
        return false;
    }

    private float getTotalWeight() {
        float total = 0.0f;
        for (int i = 0; i < this.animators.size(); ++i) {
            total += ((Animator)this.animators.get(i)).getWeight();
        }
        return total;
    }

    protected void updateTransform(Animator animator, int type) {
        if (type != 4) {
            return;
        }
        Vector3f trans = animator.getMovementTranslation(null);
        trans.multLocal(this.instance.getLocalScale());
        trans.multLocal(animator.getWeight() / this.getTotalWeight());
        this.instance.getLocalTranslation().addLocal(trans);
    }

    public boolean isUpdatingLocalTransform() {
        return this.updatingLocalTransform;
    }

    public void setUpdatingLocalTransform(boolean updatingLocalTransform) {
        this.updatingLocalTransform = updatingLocalTransform;
    }

    public float getSkipRate() {
        return this.skipRate;
    }

    public void setSkipRate(float skipRate) {
        this.skipRate = skipRate;
    }

    public IAnimationListener getEventHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements IAnimationListener {
        private List listeners;

        private EventHandler() {
        }

        @Override
        public void notify(Animator animator, int type, Object userObject) {
            if (AnimationController.this.updatingLocalTransform) {
                AnimationController.this.updateTransform(animator, type);
            }
            if (this.listeners != null) {
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                } else {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ((IAnimationListener)this.listeners.get(i)).notify(animator, type, userObject);
                    }
                }
            }
        }

        public void addListener(IAnimationListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(1);
            }
            this.listeners.add(listener);
        }

        public void removeListener(IAnimationListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }
}

