/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Vector3f;
import java.util.BitSet;
import model.ModelInstance;
import model.animation.AnimationController;

public abstract class Animator {
    protected float speed = 1.0f;
    protected float weight = 1.0f;
    protected float fadePerSec = 0.0f;
    protected float fadeTarget = -1.0f;
    protected boolean removedAfterFade = false;
    protected AnimationController animationController;

    public void setAnimationController(AnimationController animationController) {
        this.animationController = animationController;
    }

    protected ModelInstance getModelInstance() {
        return this.animationController.getModelInstance();
    }

    public boolean updateWeight(float timeDelta) {
        if (this.fadePerSec != 0.0f) {
            this.weight += this.fadePerSec * timeDelta;
            if (this.fadePerSec > 0.0f && this.weight >= this.fadeTarget) {
                this.fadePerSec = 0.0f;
                this.weight = this.fadeTarget;
                if (this.removedAfterFade) {
                    return false;
                }
            } else if (this.fadePerSec < 0.0f && this.weight <= this.fadeTarget) {
                this.fadePerSec = 0.0f;
                this.weight = this.fadeTarget;
                if (this.removedAfterFade) {
                    return false;
                }
            }
        }
        return true;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public void fadeIn(float time) {
        this.setWeight(0.0f);
        this.fadeTo(1.0f, time);
    }

    public void fadeOut(float time, boolean removedAfterFade) {
        this.fadeTo(0.0f, time);
        this.setRemovedAfterFade(removedAfterFade);
    }

    public void fadeTo(float weight, float time) {
        this.fadeTarget = weight;
        this.fadePerSec = (weight - this.weight) / time;
    }

    public boolean isRemovedAfterFade() {
        return this.removedAfterFade;
    }

    public void setRemovedAfterFade(boolean removedAfterFade) {
        this.removedAfterFade = removedAfterFade;
    }

    public abstract boolean update(float var1);

    public abstract Vector3f[] getPositions(Vector3f[] var1, BitSet var2);

    public abstract Vector3f getMovementTranslation(Vector3f var1);

    public abstract Vector3f getBasePosition(Vector3f var1);
}

