/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import java.util.BitSet;
import model.KeyFrame;
import model.SkeletalKeyFrame;
import model.SkeletalModel;
import model.Skeleton;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.AnimationController;
import model.animation.ISkeletalAnimator;
import model.animation.SkeletalAnimation;

public class SkeletalAnimationAnimator
extends AnimationAnimator
implements ISkeletalAnimator {
    private int[] boneMap;

    public SkeletalAnimationAnimator(Animation animation) {
        super(animation);
    }

    @Override
    public Vector3f[] getPositions(Vector3f[] positions, BitSet provided) {
        KeyFrame frame;
        float delta = this.getDelta();
        if (this.animation.size() == 1) {
            return this.populatePositions(positions, this.animation.first(), provided);
        }
        if ((double)delta < 0.5) {
            frame = this.animation.getKeyFrame(this.timePoint - 1);
            if (this.time - frame.time < this.interpolationThreshold) {
                return this.populatePositions(positions, frame, provided);
            }
        } else {
            frame = this.animation.getKeyFrame(this.timePoint);
            if (frame.time - this.time < this.interpolationThreshold) {
                return this.populatePositions(positions, frame, provided);
            }
        }
        Vector3f[] base = this.animation.getBaseFrame().positions;
        Vector3f[] prev = this.animation.getKeyFrame((int)(this.timePoint - 1)).positions;
        Vector3f[] next = this.animation.getKeyFrame((int)this.timePoint).positions;
        BitSet set = this.animation.getSuppliedPositions();
        int pos = 0;
        int length = this.animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            int index = this.boneMap[i];
            provided.set(index);
            if (set.get(i)) {
                positions[index].interpolate(prev[pos], next[pos++], delta);
                continue;
            }
            positions[index].set(base[i]);
        }
        return positions;
    }

    private Vector3f[] populatePositions(Vector3f[] positions, KeyFrame frame, BitSet provided) {
        Vector3f[] base = this.animation.getBaseFrame().positions;
        Vector3f[] cur = frame.positions;
        if (this.boneMap == null) {
            return frame.positions;
        }
        BitSet set = this.animation.getSuppliedPositions();
        int pos = 0;
        int length = this.animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            int index = this.boneMap[i];
            provided.set(index);
            if (set.get(i)) {
                positions[index].set(cur[pos++]);
                continue;
            }
            positions[index].set(base[i]);
        }
        return positions;
    }

    @Override
    public Quaternion[] getRotations(Quaternion[] rotations, BitSet provided) {
        SkeletalKeyFrame frame;
        SkeletalAnimation animation = this.getAnimationSkeletal();
        float delta = this.getDelta();
        if (animation.size() == 1) {
            return this.populateRotations(rotations, animation.firstSkeletal(), provided);
        }
        if ((double)delta < 0.5) {
            frame = animation.getSkeletal(this.timePoint - 1);
            if (this.time - frame.time < this.interpolationThreshold) {
                return this.populateRotations(rotations, frame, provided);
            }
        } else {
            frame = animation.getSkeletal(this.timePoint);
            if (frame.time - this.time < this.interpolationThreshold) {
                return this.populateRotations(rotations, frame, provided);
            }
        }
        Quaternion[] base = animation.getBaseFrameSkeletal().rotations;
        Quaternion[] prev = animation.getSkeletal((int)(this.timePoint - 1)).rotations;
        Quaternion[] next = animation.getSkeletal((int)this.timePoint).rotations;
        BitSet set = animation.getSuppliedRotations();
        int pos = 0;
        int length = animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            int index = this.boneMap[i];
            provided.set(index);
            if (set.get(i)) {
                rotations[index].slerp(prev[pos], next[pos++], delta);
                continue;
            }
            rotations[index].set(base[i]);
        }
        return rotations;
    }

    private Quaternion[] populateRotations(Quaternion[] rotations, SkeletalKeyFrame frame, BitSet provided) {
        SkeletalAnimation animation = this.getAnimationSkeletal();
        Quaternion[] base = animation.getBaseFrameSkeletal().rotations;
        Quaternion[] cur = frame.rotations;
        if (this.boneMap == null) {
            return frame.rotations;
        }
        BitSet set = animation.getSuppliedRotations();
        int pos = 0;
        int length = animation.getBaseFrame().positions.length;
        for (int i = 0; i < length; ++i) {
            int index = this.boneMap[i];
            provided.set(index);
            if (set.get(i)) {
                rotations[index].set(cur[pos++]);
                continue;
            }
            rotations[index].set(base[i]);
        }
        return rotations;
    }

    @Override
    public void setAnimationController(AnimationController animationController) {
        super.setAnimationController(animationController);
        if (animationController == null) {
            this.boneMap = null;
            return;
        }
        Skeleton from = ((SkeletalAnimation)this.animation).getSkeleton();
        Skeleton to = ((SkeletalModel)this.getModelInstance().getModel()).getSkeleton();
        this.boneMap = new int[from.getJointCount()];
        for (int i = 0; i < from.getJointCount(); ++i) {
            String joint = to.getJointNames()[i];
            int index = to.findJoint(joint);
            if (index < 0) {
                throw new IllegalArgumentException("Missing joint: " + joint);
            }
            this.boneMap[i] = index;
        }
    }

    public SkeletalAnimation getAnimationSkeletal() {
        return (SkeletalAnimation)this.animation;
    }

    @Override
    public Quaternion getMovementRotation(Quaternion rotation) {
        if (rotation == null) {
            rotation = new Quaternion(this.getAnimationSkeletal().getMovementRotation());
        } else {
            rotation.set(this.getAnimationSkeletal().getMovementRotation());
        }
        return rotation;
    }

    @Override
    public Quaternion getBaseRotation(Quaternion target) {
        if (target == null) {
            return new Quaternion(this.getAnimationSkeletal().getBaseFrameSkeletal().rotations[0]);
        }
        return target.set(this.getAnimationSkeletal().getBaseFrameSkeletal().rotations[0]);
    }

    @Override
    public boolean isSkeletal() {
        return true;
    }
}

