/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import model.SkeletalKeyFrame;
import model.SkeletalModelInstance;
import model.Skeleton;
import model.animation.Animation;
import model.animation.AnimationAnimator;
import model.animation.AnimationArrayCache;
import model.animation.AnimationController;
import model.animation.Animator;
import model.animation.ISkeletalAnimator;
import model.animation.SkeletalAnimationAnimator;
import model.animation.SkeletalBindAnimator;

public class SkeletalAnimationController
extends AnimationController {
    private static final Quaternion ZERO = new Quaternion();
    private static Vector3f tempV = new Vector3f();
    private static Quaternion tempQ = new Quaternion();
    private static Quaternion tempQ2 = new Quaternion();
    private float[] posWeight;
    private float[] rotWeight;
    BitSet providedPos = new BitSet();
    BitSet providedRot = new BitSet();
    private Map lastPosition = new WeakHashMap();
    private Map lastRotation = new WeakHashMap();

    public SkeletalAnimationController(SkeletalModelInstance instance) {
        super(instance);
        this.posWeight = new float[instance.getModelSkeletal().getSkeleton().getJointCount()];
        this.rotWeight = new float[this.posWeight.length];
    }

    @Override
    protected void animate(float weightMod) {
        int i;
        SkeletalModelInstance instance = (SkeletalModelInstance)this.instance;
        Skeleton skeleton = instance.getModelSkeletal().getSkeleton();
        int jointCount = skeleton.getJointCount();
        SkeletalKeyFrame bind = instance.getModelSkeletal().getBindSkeletal();
        AnimationArrayCache cache = AnimationArrayCache.get();
        Vector3f[] positionsCache = cache.getPositions(jointCount);
        Vector3f[] positionsAccum = cache.getPositionsAccum(jointCount);
        Quaternion[] rotationsCache = cache.getRotations(jointCount);
        Quaternion[] rotationsAccum = cache.getRotationsAccum(jointCount);
        for (i = 0; i < jointCount; ++i) {
            positionsAccum[i].set(0.0f, 0.0f, 0.0f);
            rotationsAccum[i].set(0.0f, 0.0f, 0.0f, 1.0f);
            this.posWeight[i] = 0.0f;
            this.rotWeight[i] = 0.0f;
        }
        for (i = 0; i < this.animators.size(); ++i) {
            Animator animator = (Animator)this.animators.get(i);
            ISkeletalAnimator skeletal = (ISkeletalAnimator)this.animators.get(i);
            float weight = animator.getWeight();
            this.providedPos.clear();
            this.providedRot.clear();
            Vector3f[] positions = animator.getPositions(positionsCache, this.providedPos);
            Quaternion[] rotations = skeletal.getRotations(rotationsCache, this.providedRot);
            for (int j = 0; j < jointCount; ++j) {
                float factor;
                Quaternion rot;
                Vector3f pos;
                if (j == 0 && this.updatingLocalTransform && weight != Float.POSITIVE_INFINITY) {
                    pos = this.updatePosition(positions[0], animator, weight * weightMod);
                    rot = this.updateRotation(rotations[0], animator, weight * weightMod);
                } else {
                    pos = positions[j];
                    rot = rotations[j];
                }
                if (this.providedPos.get(j)) {
                    if (weight == Float.POSITIVE_INFINITY || this.posWeight[j] == 0.0f) {
                        positionsAccum[j].set(pos);
                    } else if (this.posWeight[j] <= Float.POSITIVE_INFINITY) {
                        factor = weight / (this.posWeight[j] + weight);
                        positionsAccum[j].interpolate(pos, factor);
                    }
                    int n = j;
                    this.posWeight[n] = this.posWeight[n] + weight;
                }
                if (!this.providedRot.get(j)) continue;
                if (weight == Float.POSITIVE_INFINITY || this.rotWeight[j] == 0.0f) {
                    rotationsAccum[j].set(rot);
                } else if (weight == Float.POSITIVE_INFINITY || this.rotWeight[j] <= Float.POSITIVE_INFINITY) {
                    factor = weight / (this.rotWeight[j] + weight);
                    rotationsAccum[j].slerp(rot, factor);
                }
                int n = j;
                this.rotWeight[n] = this.rotWeight[n] + weight;
            }
        }
        for (i = 0; i < jointCount; ++i) {
            if (this.posWeight[i] == 0.0f) {
                positionsAccum[i] = bind.positions[i];
            }
            if (this.rotWeight[i] != 0.0f) continue;
            rotationsAccum[i] = bind.rotations[i];
        }
        if (instance.getName().equals("body")) {
            System.out.println(rotationsAccum[0]);
        }
        instance.setRelativeTransforms(positionsAccum, rotationsAccum);
        instance.skinMeshes(this.updatingBounds);
    }

    private Vector3f updatePosition(Vector3f base, Animator animator, float weight) {
        animator.getBasePosition(tempV).subtractLocal(base).negateLocal();
        Vector3f lp = (Vector3f)this.lastPosition.get(animator);
        if (lp == null) {
            this.lastPosition.put(animator, new Vector3f(tempV));
        } else {
            lp.subtractLocal(tempV).negateLocal().multLocal(this.instance.getLocalScale()).multLocal(weight);
            this.instance.getLocalTranslation().addLocal(lp);
            lp.set(tempV);
        }
        return animator.getBasePosition(tempV);
    }

    private Quaternion updateRotation(Quaternion base, Animator animator, float weight) {
        ISkeletalAnimator skeletal = (ISkeletalAnimator)((Object)animator);
        tempQ.set(base).multLocal(skeletal.getBaseRotation(tempQ2).inverseLocal());
        Quaternion lr = (Quaternion)this.lastRotation.get(animator);
        if (lr == null) {
            this.lastRotation.put(animator, new Quaternion(tempQ));
        } else {
            tempQ2.set(tempQ).multLocal(lr.inverseLocal());
            tempQ2.slerp(ZERO, 1.0f - weight);
            this.instance.getLocalRotation().multLocal(tempQ2);
            lr.set(tempQ);
        }
        return skeletal.getBaseRotation(tempQ);
    }

    @Override
    public void setUpdatingLocalTransform(boolean updatingLocalTransform) {
        super.setUpdatingLocalTransform(updatingLocalTransform);
        if (!updatingLocalTransform) {
            this.lastPosition.clear();
            this.lastRotation.clear();
        } else {
            if (this.instance.getLocalTranslation() == null) {
                this.instance.setLocalTranslation(new Vector3f());
            }
            if (this.instance.getLocalRotation() == null) {
                this.instance.setLocalRotation(new Quaternion());
            }
        }
    }

    @Override
    protected void setupAnimator(Animator animator) {
        if (!(animator instanceof ISkeletalAnimator)) {
            throw new ClassCastException();
        }
        super.setupAnimator(animator);
    }

    @Override
    public AnimationAnimator addAnimation(Animation animation) {
        SkeletalAnimationAnimator animator = new SkeletalAnimationAnimator(animation);
        this.addAnimator(animator);
        return animator;
    }

    @Override
    public Animator createBindAnimator() {
        return new SkeletalBindAnimator();
    }

    private float getTotalWeight() {
        float total = 0.0f;
        for (int i = 0; i < this.animators.size(); ++i) {
            Animator animator = (Animator)this.animators.get(i);
            if (animator.getWeight() == Float.POSITIVE_INFINITY) continue;
            total += animator.getWeight();
        }
        return total;
    }

    @Override
    protected void updateTransform(Animator animator, int type) {
        if (type == 4) {
            Vector3f lp = (Vector3f)this.lastPosition.get(animator);
            Quaternion lr = (Quaternion)this.lastRotation.get(animator);
            if (animator.getWeight() == Float.POSITIVE_INFINITY || lp == null || lr == null) {
                return;
            }
            lp.subtractLocal(animator.getMovementTranslation(null));
            lr.multLocal(((ISkeletalAnimator)((Object)animator)).getMovementRotation(null).inverseLocal());
        } else if (type == 2 || type == 5) {
            this.lastPosition.remove(animator);
            this.lastRotation.remove(animator);
        } else if (type == 3) {
            this.lastPosition.clear();
            this.lastRotation.clear();
        }
    }

    @Override
    public boolean isSkeletal() {
        return true;
    }
}

