/*
 * Decompiled with CFR 0.152.
 */
package org.md5reader2.parser;

import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.URI;
import java.net.URISyntaxException;
import org.md5reader2.md5.MD5Animation;
import org.md5reader2.md5.MD5Model;

public abstract class MD5Parser {
    protected MD5Model model;
    protected MD5Animation animation;

    public void parse(String fileName) {
        try {
            int token;
            FileReader reader = null;
            try {
                reader = new FileReader(new File(new URI(fileName)));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return;
            }
            if (reader == null) {
                System.out.println("MD5 Reader 2, ERROR: org.md5reader2.parser.MD5Parser: for some unknown reason FileReader, reader, has not been initialized.");
                return;
            }
            StreamTokenizer st = new StreamTokenizer(reader);
            st.quoteChar(34);
            st.ordinaryChar(123);
            st.ordinaryChar(125);
            st.ordinaryChar(40);
            st.ordinaryChar(41);
            st.parseNumbers();
            st.slashSlashComments(true);
            st.eolIsSignificant(true);
            while ((token = st.nextToken()) != -1) {
                this.parseSections(st, token);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public MD5Model parseModel(String fileName) {
        this.model = new MD5Model();
        this.parse(fileName);
        return this.model;
    }

    public MD5Animation parseAnimation(String fileName) {
        this.animation = new MD5Animation();
        this.parse(fileName);
        return this.animation;
    }

    public void computeW(Quaternion q) {
        float t = 1.0f - q.x * q.x - q.y * q.y - q.z * q.z;
        q.w = t < 0.0f ? 0.0f : -FastMath.sqrt((float)t);
    }

    protected abstract void parseSections(StreamTokenizer var1, int var2) throws IOException;
}

