/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jme.math.Line;
import com.jme.math.Rectangle;
import com.jme.math.Ring;
import com.jme.math.Vector3f;
import com.jmex.editors.swing.particles.ParticleEditPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import com.jmex.editors.swing.widget.VectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParticleOriginPanel
extends ParticleEditPanel {
    private static final long serialVersionUID = 1L;
    private VectorPanel translationPanel = new VectorPanel(-3.4028235E38f, Float.MAX_VALUE, 1.0f);
    private VectorPanel rotationPanel = new VectorPanel(-180.0f, 180.0f, 1.0f);
    private ValuePanel scalePanel = new ValuePanel("System Scale: ", " ", 0.0f, Float.MAX_VALUE, 0.01f);
    private JComboBox originTypeBox;
    private JPanel originParamsPanel;
    private JPanel pointParamsPanel;
    private JPanel lineParamsPanel;
    private ValuePanel lineLengthPanel = new ValuePanel("Length: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private JPanel rectParamsPanel;
    private ValuePanel rectWidthPanel = new ValuePanel("Width: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private ValuePanel rectHeightPanel = new ValuePanel("Height: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private JPanel ringParamsPanel;
    private ValuePanel ringInnerPanel = new ValuePanel("Inner Radius: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private ValuePanel ringOuterPanel = new ValuePanel("Outer Radius: ", "", 0.0f, Float.MAX_VALUE, 1.0f);

    public ParticleOriginPanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder(" EMITTER TRANSFORM "));
        this.translationPanel.setBorder(this.createTitledBorder(" TRANSLATION "));
        this.translationPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleOriginPanel.this.getEdittedParticles().getLocalTranslation().set(ParticleOriginPanel.this.translationPanel.getValue());
            }
        });
        this.rotationPanel.setBorder(this.createTitledBorder(" ROTATION "));
        this.rotationPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Vector3f vector3f = ParticleOriginPanel.this.rotationPanel.getValue().multLocal((float)Math.PI / 180);
                ParticleOriginPanel.this.getEdittedParticles().getLocalRotation().fromAngles(vector3f.x, vector3f.y, vector3f.z);
            }
        });
        this.scalePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleOriginPanel.this.getEdittedParticles().setLocalScale(ParticleOriginPanel.this.scalePanel.getFloatValue());
            }
        });
        jPanel.add((Component)this.translationPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.rotationPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.scalePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.originTypeBox = new JComboBox<String>(new String[]{"Point", "Line", "Rectangle", "Ring"});
        this.originTypeBox.setBorder(this.createTitledBorder(" EMITTER TYPE "));
        this.originTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleOriginPanel.this.updateOriginParams();
            }
        });
        this.originParamsPanel = new JPanel(new BorderLayout());
        this.pointParamsPanel = this.createPointParamsPanel();
        this.lineParamsPanel = this.createLineParamsPanel();
        this.rectParamsPanel = this.createRectParamsPanel();
        this.ringParamsPanel = this.createRingParamsPanel();
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.originTypeBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.originParamsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 10, 5, 5), 0, 0));
    }

    private JPanel createPointParamsPanel() {
        return new JPanel();
    }

    private JPanel createLineParamsPanel() {
        this.lineLengthPanel.setBorder(this.createTitledBorder(" LINE PARAMETERS "));
        this.lineLengthPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Line line = ParticleOriginPanel.this.getEdittedParticles().getLine();
                float f = ParticleOriginPanel.this.lineLengthPanel.getFloatValue();
                line.getOrigin().set(-f / 2.0f, 0.0f, 0.0f);
                line.getDirection().set(f / 2.0f, 0.0f, 0.0f);
            }
        });
        return this.lineLengthPanel;
    }

    private JPanel createRectParamsPanel() {
        this.rectWidthPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Rectangle rectangle = ParticleOriginPanel.this.getEdittedParticles().getRectangle();
                float f = ParticleOriginPanel.this.rectWidthPanel.getFloatValue();
                rectangle.getA().x = -f / 2.0f;
                rectangle.getB().x = f / 2.0f;
                rectangle.getC().x = -f / 2.0f;
            }
        });
        this.rectHeightPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Rectangle rectangle = ParticleOriginPanel.this.getEdittedParticles().getRectangle();
                float f = ParticleOriginPanel.this.rectHeightPanel.getFloatValue();
                rectangle.getA().z = -f / 2.0f;
                rectangle.getB().z = -f / 2.0f;
                rectangle.getC().z = f / 2.0f;
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder(" RECTANGLE PARAMETERS "));
        jPanel.add((Component)this.rectWidthPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.rectHeightPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        return jPanel;
    }

    private JPanel createRingParamsPanel() {
        this.ringInnerPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Ring ring = ParticleOriginPanel.this.getEdittedParticles().getRing();
                ring.setInnerRadius(ParticleOriginPanel.this.ringInnerPanel.getFloatValue());
            }
        });
        this.ringOuterPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Ring ring = ParticleOriginPanel.this.getEdittedParticles().getRing();
                ring.setOuterRadius(ParticleOriginPanel.this.ringOuterPanel.getFloatValue());
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.createTitledBorder(" RING PARAMETERS "));
        jPanel.add((Component)this.ringInnerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        jPanel.add((Component)this.ringOuterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
        return jPanel;
    }

    public void updateWidgets() {
        this.translationPanel.setValue(this.getEdittedParticles().getLocalTranslation());
        float[] fArray = this.getEdittedParticles().getLocalRotation().toAngles(null);
        this.rotationPanel.setValue(new Vector3f(fArray[0], fArray[1], fArray[2]).multLocal(57.295776f));
        this.scalePanel.setValue(this.getEdittedParticles().getLocalScale().x);
        switch (this.getEdittedParticles().getEmitType()) {
            case 0: {
                this.originTypeBox.setSelectedItem("Point");
                break;
            }
            case 1: {
                this.originTypeBox.setSelectedItem("Line");
                break;
            }
            case 2: {
                this.originTypeBox.setSelectedItem("Rectangle");
                break;
            }
            case 4: {
                this.originTypeBox.setSelectedItem("Ring");
            }
        }
        this.updateOriginParams();
    }

    private void updateOriginParams() {
        this.originParamsPanel.removeAll();
        String string = (String)this.originTypeBox.getSelectedItem();
        if (string.equals("Point")) {
            this.getEdittedParticles().setEmitType(0);
            this.originParamsPanel.add(this.pointParamsPanel);
        } else if (string.equals("Line")) {
            this.getEdittedParticles().setEmitType(1);
            Line line = this.getEdittedParticles().getLine();
            if (line == null) {
                line = new Line();
                this.getEdittedParticles().setGeometry(line);
            }
            this.lineLengthPanel.setValue(line.getOrigin().distance(line.getDirection()));
            this.originParamsPanel.add(this.lineParamsPanel);
        } else if (string.equals("Rectangle")) {
            this.getEdittedParticles().setEmitType(2);
            Rectangle rectangle = this.getEdittedParticles().getRectangle();
            if (rectangle == null) {
                rectangle = new Rectangle();
                this.getEdittedParticles().setGeometry(rectangle);
            }
            this.rectWidthPanel.setValue(rectangle.getA().distance(rectangle.getB()));
            this.rectHeightPanel.setValue(rectangle.getA().distance(rectangle.getC()));
            this.originParamsPanel.add(this.rectParamsPanel);
        } else if (string.equals("Ring")) {
            this.getEdittedParticles().setEmitType(4);
            Ring ring = this.getEdittedParticles().getRing();
            if (ring == null) {
                ring = new Ring();
                this.getEdittedParticles().setGeometry(ring);
            }
            this.ringInnerPanel.setValue(ring.getInnerRadius());
            this.ringOuterPanel.setValue(ring.getOuterRadius());
            this.originParamsPanel.add(this.ringParamsPanel);
        }
        this.originParamsPanel.getParent().validate();
        this.originParamsPanel.getParent().repaint();
    }
}

